/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.wireless;

import java.util.List;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.blocks.logic.wireless.RedstoneChannelTileEntity;
import mcjty.rftools.blocks.logic.wireless.RedstoneChannels;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RedstoneReceiverTileEntity
extends RedstoneChannelTileEntity
implements ITickable {
    public static final String CMD_SETANALOG = "receiver.setAnalog";
    private boolean analog = false;

    public boolean getAnalog() {
        return this.analog;
    }

    public void setAnalog(boolean analog) {
        this.analog = analog;
        this.markDirtyClient();
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            this.checkStateServer();
        }
    }

    protected void checkStateServer() {
        this.setRedstoneState(this.checkOutput());
    }

    public int checkOutput() {
        RedstoneChannels channels;
        RedstoneChannels.RedstoneChannel ch;
        if (this.channel != -1 && (ch = (channels = RedstoneChannels.getChannels(this.getWorld())).getChannel(this.channel)) != null) {
            int newout = ch.getValue();
            if (!this.analog && newout > 0) {
                return 15;
            }
            return newout;
        }
        return 0;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.powerOutput = tagCompound.hasKey("rs", 3) ? tagCompound.getInteger("rs") : (tagCompound.getBoolean("rs") ? 15 : 0);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setInteger("rs", this.powerOutput);
        return tagCompound;
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.analog = tagCompound.getBoolean("analog");
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.setBoolean("analog", this.analog);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETANALOG.equals(command)) {
            this.setAnalog((Boolean)params.get(ToggleButton.PARAM_ON));
            return true;
        }
        return false;
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        probeInfo.text(TextFormatting.GREEN + "Analog mode: " + this.getAnalog());
        probeInfo.text(TextFormatting.GREEN + "Output: " + TextFormatting.WHITE + this.checkOutput());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public void addWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.addWailaBody(itemStack, currenttip, accessor, config);
        currenttip.add(TextFormatting.GREEN + "Analog mode: " + this.getAnalog());
    }
}

