/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.wireless;

import mcjty.rftools.blocks.logic.wireless.RedstoneChannelTileEntity;
import mcjty.rftools.blocks.logic.wireless.RedstoneChannels;
import net.minecraft.nbt.NBTTagCompound;

public class RedstoneTransmitterTileEntity
extends RedstoneChannelTileEntity {
    private int prevIn = -1;

    @Override
    public void setChannel(int channel) {
        super.setChannel(channel);
        this.update();
    }

    public void update() {
        if (this.getWorld().isRemote) {
            return;
        }
        if (this.channel == -1) {
            return;
        }
        if (this.powerLevel != this.prevIn) {
            this.prevIn = this.powerLevel;
            this.markDirty();
            RedstoneChannels channels = RedstoneChannels.getChannels(this.getWorld());
            RedstoneChannels.RedstoneChannel ch = channels.getOrCreateChannel(this.channel);
            ch.setValue(this.powerLevel);
            channels.save();
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.prevIn = tagCompound.hasKey("prevIn", 3) ? tagCompound.getInteger("prevIn") : (tagCompound.getBoolean("prevIn") ? 15 : 0);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setInteger("prevIn", this.prevIn);
        return tagCompound;
    }
}

