/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.monitor;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ScrollableLabel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.BlockTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.monitor.LiquidMonitorBlockTileEntity;
import mcjty.rftools.blocks.monitor.PacketContentsMonitor;
import mcjty.rftools.blocks.monitor.PacketGetAdjacentTankBlocks;
import mcjty.rftools.blocks.monitor.RFMonitorMode;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiLiquidMonitor
extends GenericGuiContainer<LiquidMonitorBlockTileEntity> {
    private WidgetList list;
    private ChoiceLabel alarmModeChoiceLabel;
    private ScrollableLabel alarmLabel;
    private int listDirty;
    public static final int TEXT_COLOR_SELECTED = 0xFFFFFF;
    private List<BlockPos> adjacentBlocks = null;
    public static List<BlockPos> fromServer_clientAdjacentBlocks = null;

    public GuiLiquidMonitor(LiquidMonitorBlockTileEntity liquidMonitorBlockTileEntity, GenericContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)liquidMonitorBlockTileEntity, (Container)container, GuiProxy.GUI_MANUAL_MAIN, "liqmonitor");
        this.xSize = 256;
        this.ySize = 180;
    }

    public void initGui() {
        super.initGui();
        this.list = ((WidgetList)new WidgetList(this.mc, (Gui)this).setName("list")).addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void select(Widget<?> parent, int index) {
                GuiLiquidMonitor.this.setSelectedBlock(index);
            }
        });
        this.listDirty = 0;
        Slider listSlider = ((Slider)new Slider(this.mc, (Gui)this).setDesiredWidth(10)).setVertical().setScrollableName("list");
        Panel listPanel = (Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(3)).setSpacing(1)).addChildren(new Widget[]{this.list, listSlider});
        this.alarmModeChoiceLabel = ((ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.mc, (Gui)this).addChoices(new String[]{RFMonitorMode.MODE_OFF.getDescription(), RFMonitorMode.MODE_LESS.getDescription(), RFMonitorMode.MODE_MORE.getDescription()}).setDesiredWidth(60)).setDesiredHeight(15)).setTooltips(new String[]{"Control when a redstone", "signal should be sent"})).addChoiceEvent((parent, newChoice) -> this.changeAlarmMode(RFMonitorMode.getModeFromDescription(newChoice)));
        this.alarmModeChoiceLabel.setChoice(((LiquidMonitorBlockTileEntity)this.tileEntity).getAlarmMode().getDescription());
        this.alarmLabel = ((ScrollableLabel)((ScrollableLabel)new ScrollableLabel(this.mc, (Gui)this).setName("alarm")).setSuffix("%").setDesiredWidth(30)).setRealMinimum(0).setRealMaximum(100).setRealValue(((LiquidMonitorBlockTileEntity)this.tileEntity).getAlarmLevel()).addValueEvent((parent, newValue) -> this.changeAlarmValue(newValue));
        Slider alarmSlider = ((Slider)((Slider)new Slider(this.mc, (Gui)this).setDesiredHeight(15)).setMinimumKnobSize(15).setHorizontal().setTooltips(new String[]{"Alarm level"})).setScrollableName("alarm");
        Panel alarmPanel = (Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChildren(new Widget[]{this.alarmModeChoiceLabel, alarmSlider, this.alarmLabel})).setDesiredHeight(20);
        Panel toplevel = (Panel)((Panel)new Panel(this.mc, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)new VerticalLayout()).addChildren(new Widget[]{listPanel, alarmPanel});
        toplevel.setBounds(new Rectangle(this.guiLeft, this.guiTop, this.xSize, this.ySize));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        fromServer_clientAdjacentBlocks = new ArrayList<BlockPos>();
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetAdjacentTankBlocks(((LiquidMonitorBlockTileEntity)this.tileEntity).getPos()));
    }

    private void changeAlarmMode(RFMonitorMode mode) {
        int alarmLevel = this.alarmLabel.getRealValue();
        ((LiquidMonitorBlockTileEntity)this.tileEntity).setAlarm(mode, alarmLevel);
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketContentsMonitor(((LiquidMonitorBlockTileEntity)this.tileEntity).getPos(), mode, alarmLevel));
    }

    private void changeAlarmValue(int newValue) {
        RFMonitorMode mode = RFMonitorMode.getModeFromDescription(this.alarmModeChoiceLabel.getCurrentChoice());
        ((LiquidMonitorBlockTileEntity)this.tileEntity).setAlarm(mode, newValue);
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketContentsMonitor(((LiquidMonitorBlockTileEntity)this.tileEntity).getPos(), mode, newValue));
    }

    private void refreshList() {
    }

    private void setSelectedBlock(int index) {
        if (index != -1) {
            BlockPos c = this.adjacentBlocks.get(index);
            ((LiquidMonitorBlockTileEntity)this.tileEntity).setMonitor(c);
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketContentsMonitor(((LiquidMonitorBlockTileEntity)this.tileEntity).getPos(), c));
        } else {
            ((LiquidMonitorBlockTileEntity)this.tileEntity).setInvalid();
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketContentsMonitor(((LiquidMonitorBlockTileEntity)this.tileEntity).getPos(), BlockPosTools.INVALID));
        }
    }

    private void populateList() {
        List<BlockPos> newAdjacentBlocks = fromServer_clientAdjacentBlocks;
        if (newAdjacentBlocks == null) {
            return;
        }
        if (newAdjacentBlocks.equals(this.adjacentBlocks)) {
            this.refreshList();
            return;
        }
        this.adjacentBlocks = new ArrayList<BlockPos>(newAdjacentBlocks);
        this.list.removeChildren();
        int index = 0;
        int sel = -1;
        for (BlockPos coordinate : this.adjacentBlocks) {
            IBlockState state = this.mc.world.getBlockState(coordinate);
            Block block = state.getBlock();
            int color = StyleConfig.colorTextInListNormal;
            String displayName = BlockTools.getReadableName((World)this.mc.world, (BlockPos)coordinate);
            if (coordinate.equals((Object)((LiquidMonitorBlockTileEntity)this.tileEntity).getMonitor())) {
                sel = index;
                color = 0xFFFFFF;
            }
            Panel panel = new Panel(this.mc, (Gui)this).setLayout((Layout)new HorizontalLayout());
            panel.addChild((Widget)new BlockRender(this.mc, (Gui)this).setRenderItem((Object)block));
            panel.addChild((Widget)((Label)((Label)((Label)new Label(this.mc, (Gui)this).setText(displayName)).setColor(color)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setDesiredWidth(90));
            panel.addChild((Widget)((Label)((Label)new Label(this.mc, (Gui)this).setDynamic(true)).setText(BlockPosTools.toString((BlockPos)coordinate))).setColor(color));
            this.list.addChild((Widget)panel);
            ++index;
        }
        this.list.setSelected(sel);
    }

    protected void drawGuiContainerBackgroundLayer(float v, int i, int i2) {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.populateList();
            this.listDirty = 5;
        }
        this.drawWindow();
    }
}

