/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modules;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.api.screens.IScreenDataHelper;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.api.screens.data.IModuleData;
import mcjty.rftools.blocks.elevator.ElevatorTileEntity;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.ScreenModuleHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ElevatorButtonScreenModule
implements IScreenModule<ModuleElevatorInfo> {
    protected int dim = 0;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    protected ScreenModuleHelper helper = new ScreenModuleHelper();
    private boolean vertical = false;
    private boolean large = false;

    @Override
    public ModuleElevatorInfo getData(IScreenDataHelper helper, World worldObj, long millis) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null) {
            return null;
        }
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)this.coordinate)) {
            return null;
        }
        TileEntity te = world.getTileEntity(this.coordinate);
        if (!(te instanceof ElevatorTileEntity)) {
            return null;
        }
        ElevatorTileEntity elevatorTileEntity = (ElevatorTileEntity)te;
        ArrayList<Integer> heights = new ArrayList<Integer>();
        elevatorTileEntity.findElevatorBlocks(heights);
        return new ModuleElevatorInfo(elevatorTileEntity.getCurrentLevel(heights), elevatorTileEntity.getLevelCount(heights), elevatorTileEntity.findBottomElevator(), heights);
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.coordinate = BlockPosTools.INVALID;
            if (tagCompound.hasKey("elevatorx")) {
                this.dim = tagCompound.hasKey("elevatordim") ? tagCompound.getInteger("elevatordim") : tagCompound.getInteger("dim");
                if (dim == this.dim) {
                    BlockPos c = new BlockPos(tagCompound.getInteger("elevatorx"), tagCompound.getInteger("elevatory"), tagCompound.getInteger("elevatorz"));
                    int dx = Math.abs(c.getX() - pos.getX());
                    int dz = Math.abs(c.getZ() - pos.getZ());
                    if (dx <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
                this.vertical = tagCompound.getBoolean("vertical");
                this.large = tagCompound.getBoolean("large");
            }
        }
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked, EntityPlayer player) {
        if (BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            if (player != null) {
                player.sendStatusMessage((ITextComponent)new TextComponentString(TextFormatting.RED + "Module is not linked to elevator!"), false);
            }
            return;
        }
        WorldServer w = DimensionManager.getWorld((int)this.dim);
        if (w == null) {
            return;
        }
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)this.coordinate)) {
            return;
        }
        TileEntity te = w.getTileEntity(this.coordinate);
        if (!(te instanceof ElevatorTileEntity)) {
            return;
        }
        ElevatorTileEntity elevatorTileEntity = (ElevatorTileEntity)te;
        ArrayList<Integer> heights = new ArrayList<Integer>();
        elevatorTileEntity.findElevatorBlocks(heights);
        int levelCount = elevatorTileEntity.getLevelCount(heights);
        int level = -1;
        if (this.vertical) {
            int max = this.large ? 6 : 8;
            int numcols = (levelCount + max - 1) / max;
            int colw = ElevatorButtonScreenModule.getColumnWidth(numcols);
            int yoffset = 0;
            if (y >= yoffset) {
                level = (y - yoffset) / ((this.large ? 22 : 16) - 2);
                if (level < 0) {
                    return;
                }
                if (numcols > 1) {
                    int col = (x - 5) / (colw + 7);
                    level = max - level - 1 + col * max;
                    if (col == numcols - 1) {
                        level -= max - levelCount % max;
                    }
                } else {
                    level = levelCount - level - 1;
                }
            }
        } else {
            int xoffset = 5;
            if (x >= xoffset) {
                level = (x - xoffset) / ((this.large ? 22 : 16) - 2);
            }
        }
        if (level >= 0 && level < levelCount) {
            elevatorTileEntity.toLevel(level);
        }
    }

    public static int getColumnWidth(int numcols) {
        int colw;
        switch (numcols) {
            case 1: {
                colw = 120;
                break;
            }
            case 2: {
                colw = 58;
                break;
            }
            case 3: {
                colw = 36;
                break;
            }
            case 4: {
                colw = 25;
                break;
            }
            case 5: {
                colw = 19;
                break;
            }
            default: {
                colw = 15;
            }
        }
        return colw;
    }

    @Override
    public int getRfPerTick() {
        return ScreenConfiguration.ELEVATOR_BUTTON_RFPERTICK.get();
    }

    public static class ModuleElevatorInfo
    implements IModuleData {
        public static final String ID = "rftools:elevator";
        private int level;
        private int maxLevel;
        private BlockPos pos;
        private List<Integer> heights;

        @Override
        public String getId() {
            return ID;
        }

        public ModuleElevatorInfo(int level, int maxLevel, BlockPos pos, List<Integer> heights) {
            this.level = level;
            this.maxLevel = maxLevel;
            this.pos = pos;
            this.heights = heights;
        }

        public ModuleElevatorInfo(ByteBuf buf) {
            this.level = buf.readInt();
            this.maxLevel = buf.readInt();
            this.pos = NetworkTools.readPos((ByteBuf)buf);
            int s = buf.readByte();
            this.heights = new ArrayList<Integer>(s);
            for (int i = 0; i < s; ++i) {
                this.heights.add(Integer.valueOf(buf.readShort()));
            }
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public List<Integer> getHeights() {
            return this.heights;
        }

        public int getLevel() {
            return this.level;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        @Override
        public void writeToBuf(ByteBuf buf) {
            buf.writeInt(this.level);
            buf.writeInt(this.maxLevel);
            NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
            buf.writeByte(this.heights.size());
            for (Integer height : this.heights) {
                buf.writeShort(height.intValue());
            }
        }
    }
}

