/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import javax.annotation.Nullable;
import mcjty.rftools.blocks.shield.ShieldRenderingMode;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NoTickShieldBlockTileEntity
extends TileEntity {
    private IBlockState mimic = null;
    private int camoId = -1;
    private int camoMeta = 0;
    private int hasTe = 0;
    private int shieldColor;
    private ShieldRenderingMode shieldRenderingMode = ShieldRenderingMode.MODE_SHIELD;
    protected int damageBits = 0;
    private int collisionData = 0;
    protected BlockPos shieldBlock;
    protected AxisAlignedBB beamBox = null;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.getBlock() != newSate.getBlock();
    }

    public void setDamageBits(int damageBits) {
        this.damageBits = damageBits;
        this.markDirtyClient();
    }

    private void markDirtyClient() {
        this.markDirty();
        if (this.getWorld() != null) {
            IBlockState state = this.getWorld().getBlockState(this.getPos());
            this.getWorld().notifyBlockUpdate(this.getPos(), state, state, 3);
        }
    }

    public int getCollisionData() {
        return this.collisionData;
    }

    public void setCollisionData(int collisionData) {
        this.collisionData = collisionData;
        this.markDirtyClient();
    }

    public int getShieldColor() {
        return this.shieldColor;
    }

    public void setShieldColor(int shieldColor) {
        this.shieldColor = shieldColor;
        this.markDirtyClient();
    }

    public ShieldRenderingMode getShieldRenderingMode() {
        return this.shieldRenderingMode;
    }

    public void setShieldRenderingMode(ShieldRenderingMode shieldRenderingMode) {
        this.shieldRenderingMode = shieldRenderingMode;
        this.markDirtyClient();
    }

    public IBlockState getMimicBlock() {
        return this.mimic;
    }

    public void setCamoBlock(int camoId, int meta, int hasTe) {
        this.camoId = camoId;
        this.camoMeta = meta;
        this.hasTe = hasTe;
        this.mimic = camoId == -1 ? null : Block.getBlockById((int)camoId).getStateFromMeta(meta);
        this.markDirtyClient();
    }

    public void setShieldBlock(BlockPos c) {
        this.shieldBlock = c;
        this.markDirtyClient();
    }

    public BlockPos getShieldBlock() {
        return this.shieldBlock;
    }

    public boolean getHasTe() {
        return this.hasTe != 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setInteger("camoId", this.camoId);
        tagCompound.setInteger("camoMeta", this.camoMeta);
        tagCompound.setInteger("hasTe", this.hasTe);
        tagCompound.setInteger("damageBits", this.damageBits);
        tagCompound.setInteger("collisionData", this.collisionData);
        tagCompound.setInteger("shieldColor", this.shieldColor);
        tagCompound.setInteger("stt", this.shieldRenderingMode.ordinal());
        if (this.shieldBlock != null) {
            tagCompound.setInteger("shieldX", this.shieldBlock.getX());
            tagCompound.setInteger("shieldY", this.shieldBlock.getY());
            tagCompound.setInteger("shieldZ", this.shieldBlock.getZ());
        }
        return tagCompound;
    }

    public NBTTagCompound getUpdateTag() {
        NBTTagCompound updateTag = super.getUpdateTag();
        this.writeToNBT(updateTag);
        return updateTag;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.camoId = tagCompound.getInteger("camoId");
        this.camoMeta = tagCompound.getInteger("camoMeta");
        this.hasTe = tagCompound.getInteger("hasTe");
        this.mimic = this.camoId == -1 ? null : Block.getBlockById((int)this.camoId).getStateFromMeta(this.camoMeta);
        this.damageBits = tagCompound.getInteger("damageBits");
        this.collisionData = tagCompound.getInteger("collisionData");
        this.shieldColor = tagCompound.getInteger("shieldColor");
        if (this.shieldColor == 0) {
            this.shieldColor = 9895880;
        }
        this.shieldRenderingMode = ShieldRenderingMode.values()[tagCompound.getInteger("stt")];
        int sx = tagCompound.getInteger("shieldX");
        int sy = tagCompound.getInteger("shieldY");
        int sz = tagCompound.getInteger("shieldZ");
        this.shieldBlock = new BlockPos(sx, sy, sz);
        if (this.getWorld() != null && this.getWorld().isRemote) {
            this.getWorld().markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
        }
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.getPos(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readFromNBT(packet.getNbtCompound());
    }

    public void handleDamage(Entity entity) {
    }
}

