/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.ICommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.shield.PacketFiltersReady;
import mcjty.rftools.blocks.shield.filters.ShieldFilter;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGetFilters
implements IMessage {
    protected BlockPos pos;
    protected TypedMap params;

    public PacketGetFilters() {
    }

    public PacketGetFilters(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketGetFilters(BlockPos pos) {
        this.pos = pos;
        this.params = TypedMap.EMPTY;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.params = TypedMapTools.readArguments((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        TypedMapTools.writeArguments((ByteBuf)buf, (TypedMap)this.params);
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = ctx.getSender().getEntityWorld().getTileEntity(this.pos);
            if (!(te instanceof ICommandHandler)) {
                Logging.log((String)"createStartScanPacket: TileEntity is not a CommandHandler!");
                return;
            }
            ICommandHandler commandHandler = (ICommandHandler)te;
            List list = commandHandler.executeWithResultList("getFilters", this.params, Type.create(ShieldFilter.class));
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketFiltersReady(this.pos, "getFilters", list), ctx.getSender());
        });
        ctx.setPacketHandled(true);
    }
}

