/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import com.mojang.authlib.GameProfile;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import mcjty.lib.api.information.IMachineInformation;
import mcjty.lib.api.smartwrench.SmartWrenchSelector;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.environmental.EnvironmentalSetup;
import mcjty.rftools.blocks.shield.AbstractShieldBlock;
import mcjty.rftools.blocks.shield.DamageTypeMode;
import mcjty.rftools.blocks.shield.GuiShield;
import mcjty.rftools.blocks.shield.NoTickShieldBlockTileEntity;
import mcjty.rftools.blocks.shield.RelCoordinate;
import mcjty.rftools.blocks.shield.RelCoordinateShield;
import mcjty.rftools.blocks.shield.ShieldConfiguration;
import mcjty.rftools.blocks.shield.ShieldContainer;
import mcjty.rftools.blocks.shield.ShieldRenderingMode;
import mcjty.rftools.blocks.shield.ShieldSetup;
import mcjty.rftools.blocks.shield.ShieldTemplateBlock;
import mcjty.rftools.blocks.shield.filters.AbstractShieldFilter;
import mcjty.rftools.blocks.shield.filters.PlayerFilter;
import mcjty.rftools.blocks.shield.filters.ShieldFilter;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.shapes.Shape;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public class ShieldTEBase
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
SmartWrenchSelector,
ITickable,
IMachineInformation,
SimpleComponent {
    public static final String CMD_APPLYCAMO = "shield.applyCamo";
    public static final Key<Integer> PARAM_PASS = new Key("pass", Type.INTEGER);
    public static final String CMD_ADDFILTER = "shield.addFilter";
    public static final Key<Integer> PARAM_ACTION = new Key("action", Type.INTEGER);
    public static final Key<String> PARAM_TYPE = new Key("type", Type.STRING);
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    public static final Key<Integer> PARAM_SELECTED = new Key("selected", Type.INTEGER);
    public static final String CMD_DELFILTER = "shield.delFilter";
    public static final String CMD_UPFILTER = "shield.upFilter";
    public static final String CMD_DOWNFILTER = "shield.downFilter";
    public static final String CMD_GETFILTERS = "getFilters";
    public static final String CLIENTCMD_GETFILTERS = "getFilters";
    public static final String COMPONENT_NAME = "shield_projector";
    public static final Key<Integer> VALUE_SHIELDVISMODE = new Key("shieldVisMode", Type.INTEGER);
    public static final Key<Integer> VALUE_DAMAGEMODE = new Key("damageMode", Type.INTEGER);
    public static final Key<Integer> VALUE_COLOR = new Key("color", Type.INTEGER);
    public static final Key<Boolean> VALUE_LIGHT = new Key("light", Type.BOOLEAN);
    private DamageTypeMode damageMode = DamageTypeMode.DAMAGETYPE_GENERIC;
    private boolean shieldComposed = false;
    private IBlockState templateState = Blocks.AIR.getDefaultState();
    private boolean shieldActive = false;
    private int powerTimeout = 0;
    private int shieldColor;
    private int camoRenderPass = 0;
    private boolean blockLight = false;
    private int supportedBlocks;
    private float damageFactor = 1.0f;
    private float costFactor = 1.0f;
    private final List<ShieldFilter> filters = new ArrayList<ShieldFilter>();
    private ShieldRenderingMode shieldRenderingMode = ShieldRenderingMode.MODE_SHIELD;
    private List<RelCoordinateShield> shieldBlocks = new ArrayList<RelCoordinateShield>();
    private List<IBlockState> blockStateTable = new ArrayList<IBlockState>();
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, ShieldContainer.factory, 3);
    private FakePlayer killer = null;
    private ItemStack lootingSword = ItemStack.EMPTY;

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_RSMODE, () -> ((ShieldTEBase)this).getRSModeInt(), arg_0 -> ((ShieldTEBase)this).setRSModeInt(arg_0)), new DefaultValue(VALUE_SHIELDVISMODE, () -> this.getShieldRenderingMode().ordinal(), value -> this.setShieldRenderingMode(ShieldRenderingMode.values()[value])), new DefaultValue(VALUE_DAMAGEMODE, () -> this.getDamageMode().ordinal(), value -> this.setDamageMode(DamageTypeMode.values()[value])), new DefaultValue(VALUE_COLOR, this::getShieldColor, this::setShieldColor), new DefaultValue(VALUE_LIGHT, this::isBlockLight, this::setBlockLight)};
    }

    public ShieldTEBase(int maxEnergy, int maxReceive) {
        super((long)maxEnergy, (long)maxReceive);
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public void setSupportedBlocks(int supportedBlocks) {
        this.supportedBlocks = supportedBlocks;
    }

    public void setDamageFactor(float factor) {
        this.damageFactor = factor;
    }

    public void setCostFactor(float factor) {
        this.costFactor = factor;
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Callback(doc="Get or set the current damage mode for the shield. 'Generic' means normal damage while 'Player' means damage like a player would do", getter=true, setter=true)
    @Optional.Method(modid="opencomputers")
    public Object[] damageMode(Context context, Arguments args) {
        if (args.count() == 0) {
            return new Object[]{this.getDamageMode().getDescription()};
        }
        String mode = args.checkString(0);
        return this.setDamageMode(mode);
    }

    private Object[] setDamageMode(String mode) {
        DamageTypeMode damageMode = DamageTypeMode.getMode(mode);
        if (damageMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setDamageMode(damageMode);
        return null;
    }

    @Callback(doc="Get or set the current redstone mode. Values are 'Ignored', 'Off', or 'On'", getter=true, setter=true)
    @Optional.Method(modid="opencomputers")
    public Object[] redstoneMode(Context context, Arguments args) {
        if (args.count() == 0) {
            return new Object[]{this.getRSMode().getDescription()};
        }
        String mode = args.checkString(0);
        return this.setRedstoneMode(mode);
    }

    private Object[] setRedstoneMode(String mode) {
        RedstoneMode redstoneMode = RedstoneMode.getMode((String)mode);
        if (redstoneMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setRSMode(redstoneMode);
        return null;
    }

    @Callback(doc="Get or set the current shield rendering mode. Values are 'Invisible', 'Shield', or 'Solid'", getter=true, setter=true)
    @Optional.Method(modid="opencomputers")
    public Object[] shieldRenderingMode(Context context, Arguments args) {
        if (args.count() == 0) {
            return new Object[]{this.getShieldRenderingMode().getDescription()};
        }
        String mode = args.checkString(0);
        return this.setShieldRenderingMode(mode);
    }

    private Object[] setShieldRenderingMode(String mode) {
        ShieldRenderingMode renderingMode = ShieldRenderingMode.getMode(mode);
        if (renderingMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setShieldRenderingMode(renderingMode);
        return null;
    }

    @Callback(doc="Return true if the shield is active", getter=true)
    @Optional.Method(modid="opencomputers")
    public Object[] isShieldActive(Context context, Arguments args) {
        return new Object[]{this.isShieldActive()};
    }

    @Callback(doc="Return true if the shield is composed (i.e. formed)", getter=true)
    @Optional.Method(modid="opencomputers")
    public Object[] isShieldComposed(Context context, Arguments args) {
        return new Object[]{this.isShieldComposed()};
    }

    @Callback(doc="Form the shield (compose it)")
    @Optional.Method(modid="opencomputers")
    public Object[] composeShield(Context context, Arguments args) {
        return this.composeShieldComp(false);
    }

    @Callback(doc="Form the shield (compose it). This version works in disconnected mode (template blocks will connect on corners too)")
    @Optional.Method(modid="opencomputers")
    public Object[] composeShieldDsc(Context context, Arguments args) {
        return this.composeShieldComp(true);
    }

    private Object[] composeShieldComp(boolean ctrl) {
        boolean done = false;
        if (!this.isShieldComposed()) {
            this.composeShield(ctrl);
            done = true;
        }
        return new Object[]{done};
    }

    @Callback(doc="Break down the shield (decompose it)")
    @Optional.Method(modid="opencomputers")
    public Object[] decomposeShield(Context context, Arguments args) {
        return this.decomposeShieldComp();
    }

    private Object[] decomposeShieldComp() {
        boolean done = false;
        if (this.isShieldComposed()) {
            this.decomposeShield();
            done = true;
        }
        return new Object[]{done};
    }

    public boolean isPowered() {
        return this.powerLevel > 0;
    }

    public List<ShieldFilter> getFilters() {
        return this.filters;
    }

    public boolean isBlockLight() {
        return this.blockLight;
    }

    public void setBlockLight(boolean blockLight) {
        this.blockLight = blockLight;
        this.updateShield();
        this.markDirtyClient();
    }

    public int getShieldColor() {
        return this.shieldColor;
    }

    public void setShieldColor(int shieldColor) {
        this.shieldColor = shieldColor;
        this.updateShield();
        this.markDirtyClient();
    }

    private void delFilter(int selected) {
        this.filters.remove(selected);
        this.updateShield();
        this.markDirtyClient();
    }

    private void upFilter(int selected) {
        ShieldFilter filter1 = this.filters.get(selected - 1);
        ShieldFilter filter2 = this.filters.get(selected);
        this.filters.set(selected - 1, filter2);
        this.filters.set(selected, filter1);
        this.markDirtyClient();
    }

    private void downFilter(int selected) {
        ShieldFilter filter1 = this.filters.get(selected);
        ShieldFilter filter2 = this.filters.get(selected + 1);
        this.filters.set(selected, filter2);
        this.filters.set(selected + 1, filter1);
        this.markDirtyClient();
    }

    private void addFilter(int action, String type, String player, int selected) {
        ShieldFilter filter = AbstractShieldFilter.createFilter(type);
        filter.setAction(action);
        if (filter instanceof PlayerFilter) {
            ((PlayerFilter)filter).setName(player);
        }
        if (selected == -1) {
            this.filters.add(filter);
        } else {
            this.filters.add(selected, filter);
        }
        this.updateShield();
        this.markDirtyClient();
    }

    public DamageTypeMode getDamageMode() {
        return this.damageMode;
    }

    public void setDamageMode(DamageTypeMode damageMode) {
        this.damageMode = damageMode;
        this.markDirtyClient();
    }

    public ShieldRenderingMode getShieldRenderingMode() {
        return this.shieldRenderingMode;
    }

    public void setShieldRenderingMode(ShieldRenderingMode shieldRenderingMode) {
        this.shieldRenderingMode = shieldRenderingMode;
        if (this.shieldComposed) {
            this.updateShield();
        }
        this.markDirtyClient();
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return new int[]{2};
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index != 1 || stack.getItem() == BuilderSetup.shapeCardItem;
    }

    public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 2 && itemStackIn.getItem() == ModItems.dimensionalShardItem;
    }

    private int[] calculateCamoId() {
        ItemStack stack = this.getStackInSlot(0);
        int camoId = -1;
        int meta = 0;
        int te = 0;
        if (ShieldRenderingMode.MODE_MIMIC.equals((Object)this.shieldRenderingMode) && !stack.isEmpty() && stack.getItem() != null) {
            if (!(stack.getItem() instanceof ItemBlock)) {
                return new int[]{camoId, meta, te};
            }
            Block block = ((ItemBlock)stack.getItem()).getBlock();
            camoId = Block.getIdFromBlock((Block)block);
            meta = stack.getMetadata();
            if (block.hasTileEntity(block.getStateFromMeta(meta))) {
                te = 1;
            }
        }
        return new int[]{camoId, meta, te};
    }

    private Block calculateShieldBlock(int damageBits, int[] camoId, boolean blockLight) {
        if (!this.shieldActive || this.powerTimeout > 0) {
            return Blocks.AIR;
        }
        if (ShieldConfiguration.allowInvisibleShield.get() && ShieldRenderingMode.MODE_INVISIBLE.equals((Object)this.shieldRenderingMode)) {
            if (damageBits == 0) {
                return blockLight ? ShieldSetup.noTickInvisibleShieldBlockOpaque : ShieldSetup.noTickInvisibleShieldBlock;
            }
            return blockLight ? ShieldSetup.invisibleShieldBlockOpaque : ShieldSetup.invisibleShieldBlock;
        }
        if (camoId[0] == -1) {
            if (damageBits == 0) {
                return blockLight ? ShieldSetup.noTickSolidShieldBlockOpaque : ShieldSetup.noTickSolidShieldBlock;
            }
            return blockLight ? ShieldSetup.solidShieldBlockOpaque : ShieldSetup.solidShieldBlock;
        }
        if (damageBits == 0) {
            return blockLight ? ShieldSetup.noTickCamoShieldBlockOpaque : ShieldSetup.noTickCamoShieldBlock;
        }
        return blockLight ? ShieldSetup.camoShieldBlockOpaque : ShieldSetup.camoShieldBlock;
    }

    private int calculateDamageBits() {
        int bits = 0;
        for (ShieldFilter filter : this.filters) {
            if ((filter.getAction() & 2) == 0) continue;
            if ("item".equals(filter.getFilterName())) {
                bits |= 1;
                continue;
            }
            if ("animal".equals(filter.getFilterName())) {
                bits |= 2;
                continue;
            }
            if ("hostile".equals(filter.getFilterName())) {
                bits |= 4;
                continue;
            }
            if ("player".equals(filter.getFilterName())) {
                bits |= 8;
                continue;
            }
            if (!"default".equals(filter.getFilterName())) continue;
            bits |= 0xF;
        }
        return bits;
    }

    private int calculateShieldCollisionData() {
        int cd = 0;
        for (ShieldFilter filter : this.filters) {
            if ((filter.getAction() & 1) == 0) continue;
            if ("item".equals(filter.getFilterName())) {
                cd |= 1;
                continue;
            }
            if ("animal".equals(filter.getFilterName())) {
                cd |= 2;
                continue;
            }
            if ("hostile".equals(filter.getFilterName())) {
                cd |= 4;
                continue;
            }
            if ("player".equals(filter.getFilterName())) {
                cd |= 8;
                continue;
            }
            if (!"default".equals(filter.getFilterName())) continue;
            cd |= 0xF;
        }
        return cd;
    }

    private int calculateRfPerTick() {
        if (!this.shieldActive) {
            return 0;
        }
        int s = this.shieldBlocks.size() - 50;
        if (s < 10) {
            s = 10;
        }
        int rf = ShieldConfiguration.rfBase.get() * s / 10;
        if (ShieldRenderingMode.MODE_SHIELD.equals((Object)this.shieldRenderingMode)) {
            rf += ShieldConfiguration.rfShield.get() * s / 10;
        } else if (ShieldRenderingMode.MODE_MIMIC.equals((Object)this.shieldRenderingMode)) {
            rf += ShieldConfiguration.rfCamo.get() * s / 10;
        }
        return rf;
    }

    public boolean isShieldComposed() {
        return this.shieldComposed;
    }

    public boolean isShieldActive() {
        return this.shieldActive;
    }

    public void applyDamageToEntity(Entity entity) {
        DamageSource source;
        int rf;
        if (DamageTypeMode.DAMAGETYPE_GENERIC.equals((Object)this.damageMode)) {
            rf = ShieldConfiguration.rfDamage.get();
            source = DamageSource.GENERIC;
        } else {
            rf = ShieldConfiguration.rfDamagePlayer.get();
            if (this.killer == null) {
                this.killer = FakePlayerFactory.get((WorldServer)DimensionManager.getWorld((int)0), (GameProfile)new GameProfile(UUID.nameUUIDFromBytes("rftools_shield".getBytes()), "rftools_shield"));
            }
            this.killer.setWorld(this.world);
            this.killer.setPosition((double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ());
            FakePlayer fakePlayer = this.killer;
            ItemStack shards = this.getStackInSlot(2);
            if (!shards.isEmpty() && shards.getCount() >= ShieldConfiguration.shardsPerLootingKill.get()) {
                this.decrStackSize(2, ShieldConfiguration.shardsPerLootingKill.get());
                if (this.lootingSword.isEmpty()) {
                    this.lootingSword = EnvironmentalSetup.createEnchantedItem(Items.DIAMOND_SWORD, Enchantments.LOOTING, ShieldConfiguration.lootingKillBonus.get());
                }
                this.lootingSword.setItemDamage(0);
                fakePlayer.setHeldItem(EnumHand.MAIN_HAND, this.lootingSword);
            } else {
                fakePlayer.setHeldItem(EnumHand.MAIN_HAND, ItemStack.EMPTY);
            }
            source = DamageSource.causePlayerDamage((EntityPlayer)fakePlayer);
        }
        rf = (int)((float)rf * this.costFactor * (4.0f - this.getInfusedFactor()) / 4.0f);
        if (this.getStoredPower() < (long)rf) {
            return;
        }
        this.consumeEnergy(rf);
        float damage = (float)ShieldConfiguration.damage.get();
        damage *= this.damageFactor;
        entity.attackEntityFrom(source, damage *= 1.0f + this.getInfusedFactor() / 2.0f);
    }

    public long getEnergyDiffPerTick() {
        return this.shieldActive ? (long)this.getRfPerTick() : 0L;
    }

    @Nullable
    public String getEnergyUnitName() {
        return "RF";
    }

    public boolean isMachineActive() {
        return this.shieldActive;
    }

    public boolean isMachineRunning() {
        return this.shieldActive;
    }

    @Nullable
    public String getMachineStatus() {
        return this.shieldActive ? "active" : "idle";
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        boolean newShieldActive;
        if (!this.shieldComposed) {
            return;
        }
        boolean checkPower = false;
        if (this.powerTimeout > 0) {
            --this.powerTimeout;
            this.markDirty();
            if (this.powerTimeout > 0) {
                return;
            }
            checkPower = true;
        }
        boolean needsUpdate = false;
        int rf = this.getRfPerTick();
        if (rf > 0) {
            if (this.getStoredPower() < (long)rf) {
                this.powerTimeout = 100;
                needsUpdate = true;
            } else {
                if (checkPower) {
                    needsUpdate = true;
                }
                this.consumeEnergy(rf);
            }
        }
        if ((newShieldActive = this.isMachineEnabled()) != this.shieldActive) {
            needsUpdate = true;
            this.shieldActive = newShieldActive;
        }
        if (needsUpdate) {
            this.updateShield();
            this.markDirty();
        }
    }

    private int getRfPerTick() {
        int rf = this.calculateRfPerTick();
        rf = (int)((float)rf * (2.0f - this.getInfusedFactor()) / 2.0f);
        return rf;
    }

    public void composeDecomposeShield(boolean ctrl) {
        if (this.shieldComposed) {
            this.decomposeShield();
        } else {
            this.composeShield(ctrl);
        }
    }

    public void composeShield(boolean ctrl) {
        HashMap<BlockPos, IBlockState> coordinates;
        this.shieldBlocks.clear();
        this.blockStateTable.clear();
        if (this.isShapedShield()) {
            this.templateState = Blocks.AIR.getDefaultState();
            ItemStack shapeItem = this.inventoryHelper.getStackInSlot(1);
            Shape shape = ShapeCardItem.getShape(shapeItem);
            boolean solid = ShapeCardItem.isSolid(shapeItem);
            BlockPos dimension = ShapeCardItem.getClampedDimension(shapeItem, ShieldConfiguration.maxShieldDimension.get());
            BlockPos offset = ShapeCardItem.getClampedOffset(shapeItem, ShieldConfiguration.maxShieldOffset.get());
            HashMap<BlockPos, IBlockState> col = new HashMap<BlockPos, IBlockState>();
            ShapeCardItem.composeFormula(shapeItem, shape.getFormulaFactory().get(), this.getWorld(), this.getPos(), dimension, offset, col, this.supportedBlocks, solid, false, null);
            coordinates = col;
        } else {
            if (!this.findTemplateState()) {
                return;
            }
            HashMap<BlockPos, IBlockState> col = new HashMap<BlockPos, IBlockState>();
            this.findTemplateBlocks(col, this.templateState, ctrl, this.getPos());
            coordinates = col;
        }
        int xCoord = this.getPos().getX();
        int yCoord = this.getPos().getY();
        int zCoord = this.getPos().getZ();
        for (Map.Entry entry : coordinates.entrySet()) {
            BlockPos c = (BlockPos)entry.getKey();
            IBlockState state = (IBlockState)entry.getValue();
            int st = -1;
            if (state != null) {
                for (int i = 0; i < this.blockStateTable.size(); ++i) {
                    if (!state.equals(this.blockStateTable.get(i))) continue;
                    st = i;
                    break;
                }
                if (st == -1) {
                    st = this.blockStateTable.size();
                    this.blockStateTable.add(state);
                }
            }
            this.shieldBlocks.add(new RelCoordinateShield(c.getX() - xCoord, c.getY() - yCoord, c.getZ() - zCoord, st));
            this.getWorld().setBlockToAir(c);
        }
        this.shieldComposed = true;
        this.updateShield();
    }

    private boolean isShapedShield() {
        return !this.inventoryHelper.getStackInSlot(1).isEmpty();
    }

    private boolean findTemplateState() {
        for (EnumFacing dir : EnumFacing.VALUES) {
            IBlockState state;
            BlockPos p = this.getPos().offset(dir);
            if (p.getY() < 0 || p.getY() >= this.getWorld().getHeight() || !((Object)((Object)ShieldSetup.shieldTemplateBlock)).equals((state = this.getWorld().getBlockState(p)).getBlock())) continue;
            this.templateState = state;
            return true;
        }
        return false;
    }

    public void selectBlock(EntityPlayer player, BlockPos pos) {
        if (!this.shieldComposed) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Shield is not composed. Nothing happens!"));
            return;
        }
        float squaredDistance = (float)this.getPos().distanceSq((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (squaredDistance > (float)(ShieldConfiguration.maxDisjointShieldDistance.get() * ShieldConfiguration.maxDisjointShieldDistance.get())) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "This template is too far to connect to the shield!"));
            return;
        }
        int xCoord = this.getPos().getX();
        int yCoord = this.getPos().getY();
        int zCoord = this.getPos().getZ();
        Block origBlock = this.getWorld().getBlockState(pos).getBlock();
        if (origBlock == ShieldSetup.shieldTemplateBlock) {
            if (this.isShapedShield()) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "You cannot add template blocks to a shaped shield (using a shape card)!"));
                return;
            }
            HashMap<BlockPos, IBlockState> templateBlocks = new HashMap<BlockPos, IBlockState>();
            IBlockState state = this.getWorld().getBlockState(pos);
            templateBlocks.put(pos, null);
            this.findTemplateBlocks(templateBlocks, state, false, pos);
            int[] camoId = this.calculateCamoId();
            int cddata = this.calculateShieldCollisionData();
            int damageBits = this.calculateDamageBits();
            Block block = this.calculateShieldBlock(damageBits, camoId, this.blockLight);
            for (Map.Entry entry : templateBlocks.entrySet()) {
                BlockPos templateBlock = (BlockPos)entry.getKey();
                RelCoordinateShield relc = new RelCoordinateShield(templateBlock.getX() - xCoord, templateBlock.getY() - yCoord, templateBlock.getZ() - zCoord, -1);
                this.shieldBlocks.add(relc);
                this.updateShieldBlock(camoId, cddata, damageBits, block, relc);
            }
        } else if (origBlock instanceof AbstractShieldBlock) {
            this.shieldBlocks.remove(new RelCoordinate(pos.getX() - xCoord, pos.getY() - yCoord, pos.getZ() - zCoord));
            this.getWorld().setBlockState(pos, this.templateState, 2);
        } else {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "The selected shield can't do anything with this block!"));
            return;
        }
        this.markDirtyClient();
    }

    private void updateShield() {
        int[] camoId = this.calculateCamoId();
        int cddata = this.calculateShieldCollisionData();
        int damageBits = this.calculateDamageBits();
        Block block = this.calculateShieldBlock(damageBits, camoId, this.blockLight);
        int xCoord = this.getPos().getX();
        int yCoord = this.getPos().getY();
        int zCoord = this.getPos().getZ();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (RelCoordinateShield c : this.shieldBlocks) {
            if (Blocks.AIR.equals(block)) {
                pos.setPos(xCoord + c.getDx(), yCoord + c.getDy(), zCoord + c.getDz());
                IBlockState oldState = this.getWorld().getBlockState((BlockPos)pos);
                if (!(oldState.getBlock() instanceof AbstractShieldBlock)) continue;
                this.getWorld().setBlockToAir((BlockPos)pos);
                continue;
            }
            this.updateShieldBlock(camoId, cddata, damageBits, block, c);
        }
        this.markDirtyClient();
    }

    private void updateShieldBlock(int[] camoId, int cddata, int damageBits, Block block, RelCoordinateShield c) {
        int xCoord = this.getPos().getX();
        int yCoord = this.getPos().getY();
        int zCoord = this.getPos().getZ();
        BlockPos pp = new BlockPos(xCoord + c.getDx(), yCoord + c.getDy(), zCoord + c.getDz());
        IBlockState oldState = this.getWorld().getBlockState(pp);
        if (!oldState.getBlock().isReplaceable((IBlockAccess)this.getWorld(), pp) && oldState.getBlock() != ShieldSetup.shieldTemplateBlock) {
            return;
        }
        this.getWorld().setBlockState(pp, block.getStateFromMeta(camoId[1]), 2);
        TileEntity te = this.getWorld().getTileEntity(pp);
        if (te instanceof NoTickShieldBlockTileEntity) {
            NoTickShieldBlockTileEntity shieldBlockTileEntity = (NoTickShieldBlockTileEntity)te;
            if (c.getState() != -1) {
                IBlockState state = this.blockStateTable.get(c.getState());
                int id = Block.getIdFromBlock((Block)state.getBlock());
                shieldBlockTileEntity.setCamoBlock(id, state.getBlock().getMetaFromState(state), 0);
            } else {
                shieldBlockTileEntity.setCamoBlock(camoId[0], camoId[1], camoId[2]);
            }
            shieldBlockTileEntity.setShieldBlock(this.getPos());
            shieldBlockTileEntity.setDamageBits(damageBits);
            shieldBlockTileEntity.setCollisionData(cddata);
            shieldBlockTileEntity.setShieldColor(this.shieldColor);
            shieldBlockTileEntity.setShieldRenderingMode(this.shieldRenderingMode);
        }
    }

    public void decomposeShield() {
        int xCoord = this.getPos().getX();
        int yCoord = this.getPos().getY();
        int zCoord = this.getPos().getZ();
        BlockPos.MutableBlockPos pp = new BlockPos.MutableBlockPos();
        for (RelCoordinate relCoordinate : this.shieldBlocks) {
            int cx = xCoord + relCoordinate.getDx();
            int cy = yCoord + relCoordinate.getDy();
            int cz = zCoord + relCoordinate.getDz();
            pp.setPos(cx, cy, cz);
            Block block = this.getWorld().getBlockState((BlockPos)pp).getBlock();
            if (this.getWorld().isAirBlock((BlockPos)pp) || block instanceof AbstractShieldBlock) {
                this.getWorld().setBlockState(new BlockPos((Vec3i)pp), this.templateState, 2);
                continue;
            }
            if (this.templateState.getMaterial() == Material.AIR || this.isShapedShield()) continue;
            BlockTools.spawnItemStack((World)this.getWorld(), (int)cx, (int)cy, (int)cz, (ItemStack)this.templateState.getBlock().getItem(this.getWorld(), new BlockPos(cx, cy, cz), this.templateState));
        }
        this.shieldComposed = false;
        this.shieldActive = false;
        this.shieldBlocks.clear();
        this.blockStateTable.clear();
        this.markDirtyClient();
    }

    private void findTemplateBlocks(Map<BlockPos, IBlockState> coordinateSet, IBlockState templateState, boolean ctrl, BlockPos start) {
        ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
        if (ctrl) {
            this.addToTodoCornered(coordinateSet, todo, start, templateState);
            while (!todo.isEmpty() && coordinateSet.size() < this.supportedBlocks) {
                BlockPos coordinate = (BlockPos)todo.pollFirst();
                coordinateSet.put(coordinate, null);
                this.addToTodoCornered(coordinateSet, todo, coordinate, templateState);
            }
        } else {
            this.addToTodoStraight(coordinateSet, todo, start, templateState);
            while (!todo.isEmpty() && coordinateSet.size() < this.supportedBlocks) {
                BlockPos coordinate = (BlockPos)todo.pollFirst();
                coordinateSet.put(coordinate, null);
                this.addToTodoStraight(coordinateSet, todo, coordinate, templateState);
            }
        }
    }

    private void addToTodoStraight(Map<BlockPos, IBlockState> coordinateSet, Deque<BlockPos> todo, BlockPos coordinate, IBlockState templateState) {
        for (EnumFacing dir : EnumFacing.VALUES) {
            IBlockState state;
            BlockPos pp = coordinate.offset(dir);
            if (pp.getY() < 0 || pp.getY() >= this.getWorld().getHeight() || coordinateSet.containsKey(pp) || (state = this.getWorld().getBlockState(pp)) != templateState || todo.contains(pp)) continue;
            todo.addLast(pp);
        }
    }

    private void addToTodoCornered(Map<BlockPos, IBlockState> coordinateSet, Deque<BlockPos> todo, BlockPos coordinate, IBlockState templateState) {
        int x = coordinate.getX();
        int y = coordinate.getY();
        int z = coordinate.getZ();
        BlockPos.MutableBlockPos c = new BlockPos.MutableBlockPos();
        for (int xx = x - 1; xx <= x + 1; ++xx) {
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                for (int zz = z - 1; zz <= z + 1; ++zz) {
                    IBlockState state;
                    if (xx == x && yy == y && zz == z || yy < 0 || yy >= this.getWorld().getHeight()) continue;
                    c.setPos(xx, yy, zz);
                    if (coordinateSet.containsKey(c) || (state = this.getWorld().getBlockState((BlockPos)c)) != templateState || todo.contains(c)) continue;
                    todo.addLast(c.toImmutable());
                }
            }
        }
    }

    private static short bytesToShort(byte b1, byte b2) {
        short s1 = (short)(b1 & 0xFF);
        short s2 = (short)(b2 & 0xFF);
        return (short)(s1 * 256 + s2);
    }

    private static byte shortToByte1(short s) {
        return (byte)((s & 0xFF00) >> 8);
    }

    private static byte shortToByte2(short s) {
        return (byte)(s & 0xFF);
    }

    public void readClientDataFromNBT(NBTTagCompound tagCompound) {
        this.powerLevel = tagCompound.getByte("powered");
        this.shieldComposed = tagCompound.getBoolean("composed");
        this.shieldActive = tagCompound.getBoolean("active");
        this.powerTimeout = tagCompound.getInteger("powerTimeout");
        if (tagCompound.hasKey("templateColor")) {
            int templateColor = tagCompound.getInteger("templateColor");
            this.templateState = ShieldSetup.shieldTemplateBlock.getDefaultState().withProperty(ShieldTemplateBlock.COLOR, (Comparable)((Object)ShieldTemplateBlock.TemplateColor.values()[templateColor]));
        } else if (tagCompound.hasKey("templateMeta")) {
            int meta = tagCompound.getInteger("templateMeta");
            this.templateState = ShieldSetup.shieldTemplateBlock.getStateFromMeta(meta);
        } else {
            this.templateState = Blocks.AIR.getDefaultState();
        }
        this.shieldRenderingMode = ShieldRenderingMode.values()[tagCompound.getInteger("visMode")];
        this.rsMode = RedstoneMode.values()[tagCompound.getByte("rsMode")];
        this.damageMode = DamageTypeMode.values()[tagCompound.getByte("damageMode")];
        this.camoRenderPass = tagCompound.getInteger("camoRenderPass");
        this.blockLight = tagCompound.getBoolean("blocklight");
        this.shieldColor = tagCompound.getInteger("shieldColor");
        if (this.shieldColor == 0) {
            this.shieldColor = 9895880;
        }
        this.readFiltersFromNBT(tagCompound);
    }

    public void writeClientDataToNBT(NBTTagCompound tagCompound) {
        tagCompound.setByte("powered", (byte)this.powerLevel);
        tagCompound.setBoolean("composed", this.shieldComposed);
        tagCompound.setBoolean("active", this.shieldActive);
        tagCompound.setInteger("powerTimeout", this.powerTimeout);
        if (this.templateState.getMaterial() != Material.AIR) {
            tagCompound.setInteger("templateColor", ((ShieldTemplateBlock.TemplateColor)((Object)this.templateState.getValue(ShieldTemplateBlock.COLOR))).ordinal());
        }
        tagCompound.setInteger("visMode", this.shieldRenderingMode.ordinal());
        tagCompound.setByte("rsMode", (byte)this.rsMode.ordinal());
        tagCompound.setByte("damageMode", (byte)this.damageMode.ordinal());
        tagCompound.setInteger("camoRenderPass", this.camoRenderPass);
        tagCompound.setBoolean("blocklight", this.blockLight);
        tagCompound.setInteger("shieldColor", this.shieldColor);
        this.writeFiltersToNBT(tagCompound);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.shieldComposed = tagCompound.getBoolean("composed");
        this.shieldActive = tagCompound.getBoolean("active");
        this.powerTimeout = tagCompound.getInteger("powerTimeout");
        if (!this.isShapedShield()) {
            if (tagCompound.hasKey("templateColor")) {
                int templateColor = tagCompound.getInteger("templateColor");
                this.templateState = ShieldSetup.shieldTemplateBlock.getDefaultState().withProperty(ShieldTemplateBlock.COLOR, (Comparable)((Object)ShieldTemplateBlock.TemplateColor.values()[templateColor]));
            } else if (tagCompound.hasKey("templateMeta")) {
                int meta = tagCompound.getInteger("templateMeta");
                this.templateState = ShieldSetup.shieldTemplateBlock.getStateFromMeta(meta);
            } else {
                this.templateState = Blocks.AIR.getDefaultState();
            }
        } else {
            this.templateState = Blocks.AIR.getDefaultState();
        }
        this.shieldBlocks.clear();
        this.blockStateTable.clear();
        if (tagCompound.hasKey("relcoordsNew")) {
            byte[] byteArray = tagCompound.getByteArray("relcoordsNew");
            int j = 0;
            for (int i = 0; i < byteArray.length / 8; ++i) {
                short dx = ShieldTEBase.bytesToShort(byteArray[j + 0], byteArray[j + 1]);
                short dy = ShieldTEBase.bytesToShort(byteArray[j + 2], byteArray[j + 3]);
                short dz = ShieldTEBase.bytesToShort(byteArray[j + 4], byteArray[j + 5]);
                short st = ShieldTEBase.bytesToShort(byteArray[j + 6], byteArray[j + 7]);
                j += 8;
                this.shieldBlocks.add(new RelCoordinateShield(dx, dy, dz, st));
            }
            NBTTagList list = tagCompound.getTagList("gstates", 10);
            for (int i = 0; i < list.tagCount(); ++i) {
                NBTTagCompound tc = (NBTTagCompound)list.get(i);
                String b = tc.getString("b");
                int m = tc.getInteger("m");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(b));
                if (block == null) {
                    block = Blocks.STONE;
                    m = 0;
                }
                IBlockState state = block.getStateFromMeta(m);
                this.blockStateTable.add(state);
            }
        } else {
            byte[] byteArray = tagCompound.getByteArray("relcoords");
            int j = 0;
            for (int i = 0; i < byteArray.length / 6; ++i) {
                short dx = ShieldTEBase.bytesToShort(byteArray[j + 0], byteArray[j + 1]);
                short dy = ShieldTEBase.bytesToShort(byteArray[j + 2], byteArray[j + 3]);
                short dz = ShieldTEBase.bytesToShort(byteArray[j + 4], byteArray[j + 5]);
                j += 6;
                this.shieldBlocks.add(new RelCoordinateShield(dx, dy, dz, -1));
            }
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.shieldRenderingMode = ShieldRenderingMode.values()[tagCompound.getInteger("visMode")];
        this.damageMode = DamageTypeMode.values()[tagCompound.getByte("damageMode")];
        this.camoRenderPass = tagCompound.getInteger("camoRenderPass");
        this.blockLight = tagCompound.getBoolean("blocklight");
        this.shieldColor = tagCompound.getInteger("shieldColor");
        if (this.shieldColor == 0) {
            this.shieldColor = 9895880;
        }
        this.readFiltersFromNBT(tagCompound);
    }

    private void readFiltersFromNBT(NBTTagCompound tagCompound) {
        this.filters.clear();
        NBTTagList filterList = tagCompound.getTagList("filters", 10);
        if (filterList != null) {
            for (int i = 0; i < filterList.tagCount(); ++i) {
                NBTTagCompound compound = filterList.getCompoundTagAt(i);
                this.filters.add(AbstractShieldFilter.createFilter(compound));
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setBoolean("composed", this.shieldComposed);
        tagCompound.setBoolean("active", this.shieldActive);
        tagCompound.setInteger("powerTimeout", this.powerTimeout);
        if (this.templateState.getMaterial() != Material.AIR) {
            tagCompound.setInteger("templateColor", ((ShieldTemplateBlock.TemplateColor)((Object)this.templateState.getValue(ShieldTemplateBlock.COLOR))).ordinal());
        }
        byte[] blocks = new byte[this.shieldBlocks.size() * 8];
        int j = 0;
        for (RelCoordinateShield c : this.shieldBlocks) {
            blocks[j + 0] = ShieldTEBase.shortToByte1((short)c.getDx());
            blocks[j + 1] = ShieldTEBase.shortToByte2((short)c.getDx());
            blocks[j + 2] = ShieldTEBase.shortToByte1((short)c.getDy());
            blocks[j + 3] = ShieldTEBase.shortToByte2((short)c.getDy());
            blocks[j + 4] = ShieldTEBase.shortToByte1((short)c.getDz());
            blocks[j + 5] = ShieldTEBase.shortToByte2((short)c.getDz());
            blocks[j + 6] = ShieldTEBase.shortToByte1((short)c.getState());
            blocks[j + 7] = ShieldTEBase.shortToByte2((short)c.getState());
            j += 8;
        }
        tagCompound.setByteArray("relcoordsNew", blocks);
        NBTTagList list = new NBTTagList();
        for (IBlockState state : this.blockStateTable) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.setString("b", state.getBlock().getRegistryName().toString());
            tc.setInteger("m", state.getBlock().getMetaFromState(state));
            list.appendTag((NBTBase)tc);
        }
        tagCompound.setTag("gstates", (NBTBase)list);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.setInteger("visMode", this.shieldRenderingMode.ordinal());
        tagCompound.setByte("damageMode", (byte)this.damageMode.ordinal());
        tagCompound.setInteger("camoRenderPass", this.camoRenderPass);
        tagCompound.setBoolean("blocklight", this.blockLight);
        tagCompound.setInteger("shieldColor", this.shieldColor);
        this.writeFiltersToNBT(tagCompound);
    }

    private void writeFiltersToNBT(NBTTagCompound tagCompound) {
        NBTTagList filterList = new NBTTagList();
        for (ShieldFilter filter : this.filters) {
            NBTTagCompound compound = new NBTTagCompound();
            filter.writeToNBT(compound);
            filterList.appendTag((NBTBase)compound);
        }
        tagCompound.setTag("filters", (NBTBase)filterList);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_APPLYCAMO.equals(command)) {
            this.camoRenderPass = (Integer)params.get(PARAM_PASS);
            this.updateShield();
            return true;
        }
        if (CMD_ADDFILTER.equals(command)) {
            int action = (Integer)params.get(PARAM_ACTION);
            String type = (String)params.get(PARAM_TYPE);
            String player = (String)params.get(PARAM_PLAYER);
            int selected = (Integer)params.get(PARAM_SELECTED);
            this.addFilter(action, type, player, selected);
            return true;
        }
        if (CMD_DELFILTER.equals(command)) {
            int selected = (Integer)params.get(PARAM_SELECTED);
            this.delFilter(selected);
            return true;
        }
        if (CMD_UPFILTER.equals(command)) {
            int selected = (Integer)params.get(PARAM_SELECTED);
            this.upFilter(selected);
            return true;
        }
        if (CMD_DOWNFILTER.equals(command)) {
            int selected = (Integer)params.get(PARAM_SELECTED);
            this.downFilter(selected);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getFilters".equals(command)) {
            return type.convert(this.getFilters());
        }
        return Collections.emptyList();
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if ("getFilters".equals(command)) {
            GuiShield.storeFiltersForClient(Type.create(ShieldFilter.class).convert(list));
            return true;
        }
        return false;
    }

    public ItemStack removeStackFromSlot(int index) {
        if (index == 1 && !this.inventoryHelper.getStackInSlot(index).isEmpty()) {
            this.decomposeShield();
        }
        return this.getInventoryHelper().removeStackFromSlot(index);
    }

    public ItemStack decrStackSize(int index, int amount) {
        ItemStack stackInSlot;
        if (index == 1 && !this.inventoryHelper.getStackInSlot(index).isEmpty() && amount > 0) {
            this.decomposeShield();
        }
        if (!(stackInSlot = this.inventoryHelper.getStackInSlot(index)).isEmpty()) {
            if (stackInSlot.getCount() <= amount) {
                ItemStack old = stackInSlot.copy();
                this.inventoryHelper.setInventorySlotContents(this.getInventoryStackLimit(), index, ItemStack.EMPTY);
                this.markDirty();
                return old;
            }
            ItemStack its = stackInSlot.splitStack(amount);
            if (stackInSlot.isEmpty()) {
                this.inventoryHelper.setInventorySlotContents(this.getInventoryStackLimit(), index, ItemStack.EMPTY);
            }
            this.markDirty();
            return its;
        }
        return ItemStack.EMPTY;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        if (index == 1) {
            this.decomposeShield();
        }
        this.inventoryHelper.setInventorySlotContents(this.getInventoryStackLimit(), index, stack);
        if (!stack.isEmpty() && stack.getCount() > this.getInventoryStackLimit()) {
            int amount = this.getInventoryStackLimit();
            if (amount <= 0) {
                stack.setCount(0);
            } else {
                stack.setCount(amount);
            }
        }
        this.markDirty();
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }
}

