/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spawner;

import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.spawner.MatterBeamerContainer;
import mcjty.rftools.blocks.spawner.SpawnerConfiguration;
import mcjty.rftools.blocks.spawner.SpawnerTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MatterBeamerTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable {
    public static final int TICKTIME = 20;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, MatterBeamerContainer.factory, 1);
    public static final Key<BlockPos> VALUE_DESTINATION = new Key("destination", Type.BLOCKPOS);
    private BlockPos destination = null;
    private boolean glowing = false;
    private int ticker = 20;

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_DESTINATION, this::getDestination, this::setDestination)};
    }

    public MatterBeamerTileEntity() {
        super((long)SpawnerConfiguration.BEAMER_MAXENERGY, (long)SpawnerConfiguration.BEAMER_RECEIVEPERTICK);
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            this.checkStateServer();
        }
    }

    public boolean isPowered() {
        return this.powerLevel != 0;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    private void checkStateServer() {
        if (this.powerLevel == 0) {
            this.disableBlockGlow();
            return;
        }
        --this.ticker;
        if (this.ticker > 0) {
            return;
        }
        this.ticker = 20;
        TileEntity te = null;
        if (this.destination != null) {
            te = this.getWorld().getTileEntity(this.destination);
            if (!(te instanceof SpawnerTileEntity)) {
                this.setDestination(null);
                return;
            }
        } else {
            return;
        }
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack.isEmpty()) {
            this.disableBlockGlow();
            return;
        }
        SpawnerTileEntity spawnerTileEntity = (SpawnerTileEntity)te;
        int maxblocks = (int)((double)SpawnerConfiguration.beamBlocksPerSend * (1.01 + (double)this.getInfusedFactor() * 2.0));
        int numblocks = Math.min(maxblocks, itemStack.getCount());
        int rf = (int)((float)(SpawnerConfiguration.beamRfPerObject * numblocks) * (4.0f - this.getInfusedFactor()) / 4.0f);
        if (this.getStoredPower() < (long)rf) {
            return;
        }
        this.consumeEnergy(rf);
        if (spawnerTileEntity.addMatter(itemStack, numblocks, this.getInfusedFactor())) {
            this.inventoryHelper.decrStackSize(0, numblocks);
            this.enableBlockGlow();
        }
    }

    private void disableBlockGlow() {
        if (this.glowing) {
            this.glowing = false;
            this.markDirtyClient();
        }
    }

    private void enableBlockGlow() {
        if (!this.glowing) {
            this.glowing = true;
            this.markDirtyClient();
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean oldglowing = this.glowing;
        super.onDataPacket(net, packet);
        if (this.getWorld().isRemote && oldglowing != this.glowing) {
            this.getWorld().markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int xCoord = this.getPos().getX();
        int yCoord = this.getPos().getY();
        int zCoord = this.getPos().getZ();
        return new AxisAlignedBB((double)(xCoord - 4), (double)(yCoord - 4), (double)(zCoord - 4), (double)(xCoord + 5), (double)(yCoord + 5), (double)(zCoord + 5));
    }

    public void useWrench(EntityPlayer player) {
        BlockPos coord = RFTools.instance.clientInfo.getSelectedTE();
        TileEntity tileEntity = null;
        if (coord != null) {
            tileEntity = this.getWorld().getTileEntity(coord);
        }
        if (!(tileEntity instanceof MatterBeamerTileEntity)) {
            RFTools.instance.clientInfo.setSelectedTE(this.getPos());
            SpawnerTileEntity destinationTE = this.getDestinationTE();
            if (destinationTE == null) {
                RFTools.instance.clientInfo.setDestinationTE(null);
            } else {
                RFTools.instance.clientInfo.setDestinationTE(destinationTE.getPos());
            }
            Logging.message((EntityPlayer)player, (String)"Select a spawner as destination");
        } else if (coord.equals((Object)this.getPos())) {
            RFTools.instance.clientInfo.setSelectedTE(null);
            RFTools.instance.clientInfo.setDestinationTE(null);
            this.setDestination(null);
            Logging.message((EntityPlayer)player, (String)"Destination cleared!");
        }
    }

    public void setDestination(BlockPos destination) {
        this.destination = destination;
        this.disableBlockGlow();
        this.markDirty();
        if (this.getWorld().isRemote) {
            this.valueToServer(RFToolsMessages.INSTANCE, VALUE_DESTINATION, destination);
        } else {
            this.markDirtyClient();
        }
    }

    public BlockPos getDestination() {
        return this.destination;
    }

    private SpawnerTileEntity getDestinationTE() {
        if (this.destination == null) {
            return null;
        }
        TileEntity te = this.getWorld().getTileEntity(this.destination);
        if (te instanceof SpawnerTileEntity) {
            return (SpawnerTileEntity)te;
        }
        this.destination = null;
        this.markDirtyClient();
        return null;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.destination = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"dest");
        this.glowing = tagCompound.getBoolean("glowing");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"dest", (BlockPos)this.destination);
        tagCompound.setBoolean("glowing", this.glowing);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return MatterBeamerContainer.factory.getAccessibleSlots();
    }

    public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
        return MatterBeamerContainer.factory.isInputSlot(index);
    }

    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        return MatterBeamerContainer.factory.isOutputSlot(index);
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }
}

