/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.storage.LevelEmitterContainer;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class LevelEmitterTileEntity
extends LogicTileEntity
implements DefaultSidedInventory,
ITickable {
    public static final Key<Integer> VALUE_AMOUNT = new Key("amount", Type.INTEGER);
    public static final Key<Boolean> VALUE_OREDICT = new Key("oredict", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_STARRED = new Key("starred", Type.BOOLEAN);
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, LevelEmitterContainer.factory, 2);
    private int amount = 1;
    private boolean oreDict = false;
    private boolean starred = false;
    private int checkCounter = 0;

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_AMOUNT, this::getAmount, this::setAmount), new DefaultValue(VALUE_OREDICT, this::isOreDict, this::setOreDict), new DefaultValue(VALUE_STARRED, this::isStarred, this::setStarred)};
    }

    public void update() {
        if (this.getWorld().isRemote) {
            return;
        }
        --this.checkCounter;
        if (this.checkCounter > 0) {
            return;
        }
        this.checkCounter = 10;
        int count = this.getCurrentCount();
        this.setRedstoneState(count >= this.amount ? 15 : 0);
    }

    public int getCurrentCount() {
        ItemStack module = this.inventoryHelper.getStackInSlot(0);
        int count = -1;
        if (!module.isEmpty()) {
            TileEntity te;
            ItemStack matcher = this.inventoryHelper.getStackInSlot(1);
            if (matcher.isEmpty()) {
                return count;
            }
            int dimension = RFToolsTools.getDimensionFromModule(module);
            BlockPos scannerPos = RFToolsTools.getPositionFromModule(module);
            WorldServer world = DimensionManager.getWorld((int)dimension);
            if (WorldTools.chunkLoaded((World)world, (BlockPos)scannerPos) && (te = world.getTileEntity(scannerPos)) instanceof StorageScannerTileEntity) {
                StorageScannerTileEntity scannerTE = (StorageScannerTileEntity)te;
                count = scannerTE.countItems(matcher, this.starred, this.oreDict);
            }
        }
        return count;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean module = !this.inventoryHelper.getStackInSlot(0).isEmpty();
        super.onDataPacket(net, packet);
        if (this.getWorld().isRemote) {
            boolean newmodule;
            boolean bl = newmodule = !this.inventoryHelper.getStackInSlot(0).isEmpty();
            if (newmodule != module) {
                this.getWorld().markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
            }
        }
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.getInventoryStackLimit(), index, stack);
        if (!this.getWorld().isRemote) {
            this.markDirtyClient();
        } else {
            this.getWorld().markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.powerOutput = tagCompound.getBoolean("rs") ? 15 : 0;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.amount = tagCompound.getInteger("amount");
        this.oreDict = tagCompound.getBoolean("oredict");
        this.starred = tagCompound.getBoolean("starred");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setBoolean("rs", this.powerOutput > 0);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.setInteger("amount", this.amount);
        tagCompound.setBoolean("oredict", this.oreDict);
        tagCompound.setBoolean("starred", this.starred);
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        if (index == 0 && stack.getItem() != ScreenSetup.storageControlModuleItem) {
            return false;
        }
        return index != 1;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.markDirty();
    }

    public boolean isOreDict() {
        return this.oreDict;
    }

    public void setOreDict(boolean oreDict) {
        this.oreDict = oreDict;
        this.markDirty();
    }

    public boolean isStarred() {
        return this.starred;
    }

    public void setStarred(boolean starred) {
        this.starred = starred;
        this.markDirty();
    }
}

