/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotFactory;
import mcjty.lib.container.SlotType;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.blocks.storage.PacketSyncSlotsToClient;
import mcjty.rftools.craftinggrid.CraftingGridInventory;
import mcjty.rftools.items.storage.StorageFilterItem;
import mcjty.rftools.items.storage.StorageTypeItem;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class ModularStorageContainer
extends GenericContainer {
    public static final String CONTAINER_INVENTORY = "container";
    public static final String CONTAINER_GRID = "grid";
    public static final int SLOT_STORAGE_MODULE = 0;
    public static final int SLOT_TYPE_MODULE = 1;
    public static final int SLOT_FILTER_MODULE = 2;
    public static final int SLOT_STORAGE = 3;
    public static final int MAXSIZE_STORAGE = 300;
    private ModularStorageTileEntity modularStorageTileEntity;
    public static final ContainerFactory factory = new ContainerFactory(){

        protected void setup() {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)ModularStorageSetup.storageModuleItem)}), ModularStorageContainer.CONTAINER_INVENTORY, 0, 5, 157, 1, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, StorageTypeItem.class), ModularStorageContainer.CONTAINER_INVENTORY, 1, 5, 175, 1, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, StorageFilterItem.class), ModularStorageContainer.CONTAINER_INVENTORY, 2, 5, 193, 1, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_INPUT, new ItemStack[0]), ModularStorageContainer.CONTAINER_INVENTORY, 3, -500, -500, 30, 0, 10, 0);
            this.layoutPlayerInventorySlots(91, 157);
            this.layoutGridInventorySlots(CraftingGridInventory.GRID_XOFFSET, CraftingGridInventory.GRID_YOFFSET);
        }

        protected void layoutGridInventorySlots(int leftCol, int topRow) {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_GHOST, new ItemStack[0]), ModularStorageContainer.CONTAINER_GRID, CraftingGridInventory.SLOT_GHOSTINPUT, leftCol, topRow, 3, 18, 3, 18);
            this.addSlotRange(new SlotDefinition(SlotType.SLOT_GHOSTOUT, new ItemStack[0]), ModularStorageContainer.CONTAINER_GRID, CraftingGridInventory.SLOT_GHOSTOUTPUT, leftCol, topRow += 58, 1, 18);
        }
    };

    public ModularStorageTileEntity getModularStorageTileEntity() {
        return this.modularStorageTileEntity;
    }

    public ModularStorageContainer(EntityPlayer player, IInventory containerInventory) {
        super(factory);
        this.modularStorageTileEntity = (ModularStorageTileEntity)containerInventory;
        this.addInventory(CONTAINER_INVENTORY, containerInventory);
        this.addInventory("player", (IInventory)player.inventory);
        this.addInventory(CONTAINER_GRID, this.modularStorageTileEntity.getCraftingGrid().getCraftingGridInventory());
        this.generateSlots();
    }

    public void generateSlots() {
        for (SlotFactory slotFactory : factory.getSlots()) {
            Object slot;
            if (CONTAINER_GRID.equals(slotFactory.getInventoryName())) {
                SlotType slotType = slotFactory.getSlotType();
                IInventory inventory = (IInventory)this.inventories.get(slotFactory.getInventoryName());
                int index = slotFactory.getIndex();
                int x = slotFactory.getX();
                int y = slotFactory.getY();
                slot = this.createSlot(slotFactory, inventory, index, x, y, slotType);
            } else if (slotFactory.getSlotType() == SlotType.SLOT_SPECIFICITEM) {
                final SlotDefinition slotDefinition = slotFactory.getSlotDefinition();
                slot = new Slot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()){

                    public boolean isItemValid(ItemStack stack) {
                        return slotDefinition.itemStackMatches(stack);
                    }
                };
            } else {
                slot = slotFactory.getSlotType() == SlotType.SLOT_PLAYERINV || slotFactory.getSlotType() == SlotType.SLOT_PLAYERHOTBAR ? new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()) : new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()){

                    public boolean getHasStack() {
                        if (this.getSlotIndex() >= ModularStorageContainer.this.modularStorageTileEntity.getMaxSize() + 3) {
                            return false;
                        }
                        return super.getHasStack();
                    }

                    public ItemStack getStack() {
                        if (this.getSlotIndex() >= ModularStorageContainer.this.modularStorageTileEntity.getMaxSize() + 3) {
                            return ItemStack.EMPTY;
                        }
                        return super.getStack();
                    }

                    public boolean canTakeStack(EntityPlayer player) {
                        if (this.getSlotIndex() >= ModularStorageContainer.this.modularStorageTileEntity.getMaxSize() + 3) {
                            return false;
                        }
                        return super.canTakeStack(player);
                    }

                    public boolean isItemValid(ItemStack stack) {
                        if (this.getSlotIndex() >= ModularStorageContainer.this.modularStorageTileEntity.getMaxSize() + 3) {
                            return false;
                        }
                        if (!ModularStorageContainer.this.modularStorageTileEntity.isItemValidForSlot(this.getSlotIndex(), stack)) {
                            return false;
                        }
                        return super.isItemValid(stack);
                    }
                };
            }
            this.addSlotToContainer((Slot)slot);
        }
    }

    public void putStackInSlot(int slotID, ItemStack stack) {
        super.putStackInSlot(slotID, stack);
    }

    public ItemStack slotClick(int index, int button, ClickType mode, EntityPlayer player) {
        if (index == 0 && !player.getEntityWorld().isRemote) {
            this.modularStorageTileEntity.copyToModule();
        }
        return super.slotClick(index, button, mode, player);
    }

    public void detectAndSendChanges() {
        ArrayList<Object> differentSlots = new ArrayList<Pair<Integer, ItemStack>>();
        for (int i = 0; i < this.inventorySlots.size(); ++i) {
            ItemStack itemstack = ((Slot)this.inventorySlots.get(i)).getStack();
            ItemStack itemstack1 = (ItemStack)this.inventoryItemStacks.get(i);
            if (ItemStack.areItemStacksEqual((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            itemstack1 = itemstack.isEmpty() ? ItemStack.EMPTY : itemstack.copy();
            this.inventoryItemStacks.set(i, (Object)itemstack1);
            differentSlots.add((Pair<Integer, ItemStack>)Pair.of((Object)i, (Object)itemstack));
            if (differentSlots.size() < 30) continue;
            this.syncSlotsToListeners(differentSlots);
            differentSlots = new ArrayList();
        }
        if (!differentSlots.isEmpty()) {
            this.syncSlotsToListeners(differentSlots);
        }
    }

    private void syncSlotsToListeners(List<Pair<Integer, ItemStack>> differentSlots) {
        String sortMode = this.modularStorageTileEntity.getSortMode();
        String viewMode = this.modularStorageTileEntity.getViewMode();
        boolean groupMode = this.modularStorageTileEntity.isGroupMode();
        String filter = this.modularStorageTileEntity.getFilter();
        for (IContainerListener listener : this.listeners) {
            if (!(listener instanceof EntityPlayerMP)) continue;
            EntityPlayerMP player = (EntityPlayerMP)listener;
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketSyncSlotsToClient(this.modularStorageTileEntity.getPos(), sortMode, viewMode, groupMode, filter, this.modularStorageTileEntity.getMaxSize(), this.modularStorageTileEntity.getNumStacks(), differentSlots), player);
        }
    }
}

