/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.compat.jei.JEIRecipeAcceptor;
import mcjty.rftools.craftinggrid.CraftingGrid;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.InventoriesItemSource;
import mcjty.rftools.craftinggrid.StorageCraftingTools;
import mcjty.rftools.items.storage.StorageModuleItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;

public class ModularStorageItemInventory
implements CraftingGridProvider,
JEIRecipeAcceptor,
IInventory {
    private ItemStackList stacks;
    private final EntityPlayer entityPlayer;
    private CraftingGrid craftingGrid = new CraftingGrid();
    private ItemStack storageItem = null;

    public ModularStorageItemInventory(EntityPlayer player, ItemStack storageItem) {
        this.entityPlayer = player;
        this.storageItem = storageItem;
        int maxSize = this.getMaxSize();
        this.stacks = ItemStackList.create((int)maxSize);
        NBTTagList bufferTagList = this.getStorageItem().getTagCompound().getTagList("Items", 10);
        for (int i = 0; i < Math.min(bufferTagList.tagCount(), maxSize); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.getCompoundTagAt(i);
            this.stacks.set(i, (Object)new ItemStack(nbtTagCompound));
        }
    }

    public ModularStorageItemInventory(EntityPlayer player) {
        this.entityPlayer = player;
        int maxSize = this.getMaxSize();
        this.stacks = ItemStackList.create((int)maxSize);
        NBTTagCompound tagCompound = this.getStorageItem().getTagCompound();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            this.getStorageItem().setTagCompound(tagCompound);
        }
        tagCompound.setInteger("maxSize", maxSize);
        NBTTagList bufferTagList = tagCompound.getTagList("Items", 10);
        for (int i = 0; i < Math.min(bufferTagList.tagCount(), maxSize); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.getCompoundTagAt(i);
            this.stacks.set(i, (Object)new ItemStack(nbtTagCompound));
        }
        this.craftingGrid.readFromNBT(tagCompound.getCompoundTag("grid"));
    }

    private ItemStack getStorageItem() {
        if (this.storageItem != null) {
            return this.storageItem;
        }
        return this.entityPlayer.getHeldItem(EnumHand.MAIN_HAND);
    }

    @Override
    public void setGridContents(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.craftingGrid.getCraftingGridInventory().setInventorySlotContents(i, stacks.get(i));
        }
        this.markDirty();
    }

    @Override
    public void storeRecipe(int index) {
        this.getCraftingGrid().storeRecipe(index);
    }

    @Override
    public void setRecipe(int index, ItemStack[] stacks) {
        this.craftingGrid.setRecipe(index, stacks);
        this.markDirty();
    }

    @Override
    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public void markInventoryDirty() {
        this.markDirty();
    }

    @Override
    @Nonnull
    public int[] craft(EntityPlayer player, int n, boolean test) {
        InventoriesItemSource itemSource = new InventoriesItemSource().add((IInventory)player.inventory, 0).add(this, 0);
        if (test) {
            return StorageCraftingTools.testCraftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        }
        StorageCraftingTools.craftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        return new int[0];
    }

    private int getMaxSize() {
        ItemStack heldItem = this.getStorageItem();
        if (heldItem.isEmpty()) {
            return 0;
        }
        if (heldItem.getItem() != ModularStorageSetup.storageModuleTabletItem) {
            return 0;
        }
        if (heldItem.getTagCompound() == null) {
            return 0;
        }
        return StorageModuleItem.MAXSIZE[heldItem.getTagCompound().getInteger("childDamage")];
    }

    public ItemStackList getStacks() {
        return this.stacks;
    }

    public int getSizeInventory() {
        return this.getMaxSize();
    }

    public ItemStack getStackInSlot(int index) {
        if (index >= this.getMaxSize()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.stacks.get(index);
    }

    public ItemStack decrStackSize(int index, int amount) {
        if (index >= this.stacks.size()) {
            return ItemStack.EMPTY;
        }
        if (!((ItemStack)this.stacks.get(index)).isEmpty()) {
            if (((ItemStack)this.stacks.get(index)).getCount() <= amount) {
                ItemStack old = (ItemStack)this.stacks.get(index);
                this.stacks.set(index, (Object)ItemStack.EMPTY);
                this.markDirty();
                return old;
            }
            ItemStack its = ((ItemStack)this.stacks.get(index)).splitStack(amount);
            if (((ItemStack)this.stacks.get(index)).isEmpty()) {
                this.stacks.set(index, (Object)ItemStack.EMPTY);
            }
            this.markDirty();
            return its;
        }
        return ItemStack.EMPTY;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        if (index >= this.stacks.size()) {
            return;
        }
        this.stacks.set(index, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getInventoryStackLimit()) {
            int amount = this.getInventoryStackLimit();
            if (amount <= 0) {
                stack.setCount(0);
            } else {
                stack.setCount(amount);
            }
        }
        this.markDirty();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
        NBTTagList bufferTagList = new NBTTagList();
        int numStacks = 0;
        for (int i = 0; i < this.getMaxSize(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (!stack.isEmpty()) {
                stack.writeToNBT(nbtTagCompound);
                if (stack.getCount() > 0) {
                    ++numStacks;
                }
            }
            bufferTagList.appendTag((NBTBase)nbtTagCompound);
        }
        NBTTagCompound tagCompound = this.getStorageItem().getTagCompound();
        tagCompound.setTag("Items", (NBTBase)bufferTagList);
        tagCompound.setInteger("count", numStacks);
        tagCompound.setTag("grid", (NBTBase)this.craftingGrid.writeToNBT());
    }

    public boolean isUsable(EntityPlayer player) {
        return true;
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index < this.getMaxSize();
    }

    public ItemStack removeStackFromSlot(int index) {
        ItemStack stack = this.getStackInSlot(index);
        this.setInventorySlotContents(index, ItemStack.EMPTY);
        return stack;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
    }

    public String getName() {
        return "modular storage";
    }

    public boolean hasCustomName() {
        return false;
    }

    public ITextComponent getDisplayName() {
        return null;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.isUsable(player);
    }

    public boolean isEmpty() {
        return false;
    }
}

