/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.blocks.teleporter.GuiDialingDevice;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.MatterTransmitterTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinationClientInfo;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.blocks.teleporter.TeleporterSetup;
import mcjty.rftools.blocks.teleporter.TransmitterInfo;
import mcjty.rftools.playerprops.FavoriteDestinationsProperties;
import mcjty.rftools.playerprops.PlayerExtendedProperties;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class DialingDeviceTileEntity
extends GenericEnergyReceiverTileEntity {
    public static final String CMD_TELEPORT = "tp";
    public static final String CMD_GETRECEIVERS = "getReceivers";
    public static final String CLIENTCMD_GETRECEIVERS = "getReceivers";
    public static final String CMD_DIAL = "dial";
    public static final String CMD_DIALONCE = "dialOnce";
    public static final Key<Integer> PARAM_STATUS = new Key("status", Type.INTEGER);
    public static final String CMD_FAVORITE = "dialer.favorite";
    public static final String CMD_SHOWFAVORITE = "dialer.showFavorite";
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    public static final Key<BlockPos> PARAM_POS = new Key("pos", Type.BLOCKPOS);
    public static final Key<Integer> PARAM_DIMENSION = new Key("dimension", Type.INTEGER);
    public static final Key<BlockPos> PARAM_TRANSMITTER = new Key("transmitter", Type.BLOCKPOS);
    public static final Key<Integer> PARAM_TRANS_DIMENSION = new Key("transDimension", Type.INTEGER);
    public static final Key<Boolean> PARAM_FAVORITE = new Key("favorite", Type.BOOLEAN);
    public static final String CMD_GETTRANSMITTERS = "getTransmitters";
    public static final String CLIENTCMD_GETTRANSMITTERS = "getTransmitters";
    public static final String CMD_CHECKSTATUS = "checkStatus";
    public static final int DIAL_RECEIVER_BLOCKED_MASK = 1;
    public static final int DIAL_TRANSMITTER_BLOCKED_MASK = 2;
    public static final int DIAL_INVALID_DESTINATION_MASK = 4;
    public static final int DIAL_DIALER_POWER_LOW_MASK = 8;
    public static final int DIAL_RECEIVER_POWER_LOW_MASK = 16;
    public static final int DIAL_TRANSMITTER_NOACCESS = 32;
    public static final int DIAL_RECEIVER_NOACCESS = 64;
    public static final int DIAL_INTERRUPTED = 128;
    public static final int DIAL_INVALID_SOURCE_MASK = 256;
    public static final int DIAL_DIMENSION_POWER_LOW_MASK = 512;
    public static final int DIAL_INVALID_TRANSMITTER = 1024;
    public static final int DIAL_OK = 0;
    public static final String COMPONENT_NAME = "dialing_device";
    private boolean showOnlyFavorites = false;

    public DialingDeviceTileEntity() {
        super((long)TeleportConfiguration.DIALER_MAXENERGY.get(), (long)TeleportConfiguration.DIALER_RECEIVEPERTICK.get());
    }

    public static String calculateDistance(World world, TransmitterInfo transmitterInfo, TeleportDestination teleportDestination) {
        if (world.provider.getDimension() != teleportDestination.getDimension()) {
            return "dimension warp";
        }
        BlockPos c1 = transmitterInfo.getCoordinate();
        BlockPos c2 = teleportDestination.getCoordinate();
        double dist = new Vec3d((double)c1.getX(), (double)c1.getY(), (double)c1.getZ()).distanceTo(new Vec3d((double)c2.getX(), (double)c2.getY(), (double)c2.getZ()));
        return Integer.toString((int)dist);
    }

    public static boolean isMatterBoosterAvailable(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.VALUES) {
            if (!((Object)((Object)TeleporterSetup.matterBoosterBlock)).equals(world.getBlockState(pos.offset(facing)).getBlock())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDestinationAnalyzerAvailable(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.VALUES) {
            if (!((Object)((Object)TeleporterSetup.destinationAnalyzerBlock)).equals(world.getBlockState(pos.offset(facing)).getBlock())) continue;
            return true;
        }
        return false;
    }

    public boolean isShowOnlyFavorites() {
        return this.showOnlyFavorites;
    }

    public void setShowOnlyFavorites(boolean showOnlyFavorites) {
        this.showOnlyFavorites = showOnlyFavorites;
        this.markDirtyClient();
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.showOnlyFavorites = tagCompound.getBoolean("showFav");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.setBoolean("showFav", this.showOnlyFavorites);
    }

    private List<TeleportDestinationClientInfo> searchReceivers(String playerName) {
        TeleportDestinations destinations = TeleportDestinations.getDestinations(this.getWorld());
        return new ArrayList<TeleportDestinationClientInfo>(destinations.getValidDestinations(this.getWorld(), playerName));
    }

    public List<TransmitterInfo> searchTransmitters() {
        int x = this.getPos().getX();
        int y = this.getPos().getY();
        int z = this.getPos().getZ();
        int hrange = TeleportConfiguration.horizontalDialerRange.get();
        int vrange = TeleportConfiguration.verticalDialerRange.get();
        ArrayList<TransmitterInfo> transmitters = new ArrayList<TransmitterInfo>();
        for (int dy = -vrange; dy <= vrange; ++dy) {
            int yy = y + dy;
            if (yy < 0 || yy >= this.getWorld().getHeight()) continue;
            for (int dz = -hrange; dz <= hrange; ++dz) {
                int zz = z + dz;
                for (int dx = -hrange; dx <= hrange; ++dx) {
                    int xx = x + dx;
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    BlockPos c = new BlockPos(xx, yy, zz);
                    TileEntity tileEntity = this.getWorld().getTileEntity(c);
                    if (!(tileEntity instanceof MatterTransmitterTileEntity)) continue;
                    MatterTransmitterTileEntity matterTransmitterTileEntity = (MatterTransmitterTileEntity)tileEntity;
                    transmitters.add(new TransmitterInfo(c, matterTransmitterTileEntity.getName(), matterTransmitterTileEntity.getTeleportDestination()));
                }
            }
        }
        return transmitters;
    }

    private void changeFavorite(String playerName, BlockPos receiver, int dimension, boolean favorite) {
        List list = ((WorldServer)this.getWorld()).getMinecraftServer().getPlayerList().getPlayers();
        for (EntityPlayerMP entityplayermp : list) {
            if (!playerName.equals(entityplayermp.getName())) continue;
            FavoriteDestinationsProperties favoriteDestinations = PlayerExtendedProperties.getFavoriteDestinations((EntityPlayer)entityplayermp);
            favoriteDestinations.setDestinationFavorite(new GlobalCoordinate(receiver, dimension), favorite);
            return;
        }
    }

    private int dial(String player, BlockPos transmitter, int transDim, BlockPos coordinate, int dimension, boolean once) {
        return TeleportationTools.dial(this.getWorld(), this, player, transmitter, transDim, coordinate, dimension, once);
    }

    private int checkStatus(BlockPos c, int dim) {
        int cost = TeleportConfiguration.rfPerCheck.get();
        cost = (int)((float)cost * (2.0f - this.getInfusedFactor()) / 2.0f);
        if (this.getStoredPower() < (long)cost) {
            return 8;
        }
        this.consumeEnergy(cost);
        World w = mcjty.lib.varia.TeleportationTools.getWorldForDimension((int)dim);
        if (w == null) {
            TeleportDestinations destinations = TeleportDestinations.getDestinations(this.getWorld());
            destinations.cleanupInvalid();
            return 4;
        }
        TileEntity tileEntity = w.getTileEntity(c);
        if (!(tileEntity instanceof MatterReceiverTileEntity)) {
            TeleportDestinations destinations = TeleportDestinations.getDestinations(this.getWorld());
            destinations.cleanupInvalid();
            return 4;
        }
        MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)tileEntity;
        return matterReceiverTileEntity.checkStatus();
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getReceivers".equals(command)) {
            String playerName = (String)args.get(PARAM_PLAYER);
            return type.convert(this.searchReceivers(playerName));
        }
        if ("getTransmitters".equals(command)) {
            return type.convert(this.searchTransmitters());
        }
        return Collections.emptyList();
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return rc;
        }
        if (CMD_FAVORITE.equals(command)) {
            String player = (String)params.get(PARAM_PLAYER);
            BlockPos receiver = (BlockPos)params.get(PARAM_POS);
            int dimension = (Integer)params.get(PARAM_DIMENSION);
            boolean favorite = (Boolean)params.get(PARAM_FAVORITE);
            this.changeFavorite(player, receiver, dimension, favorite);
            return true;
        }
        if (CMD_SHOWFAVORITE.equals(command)) {
            boolean favorite = (Boolean)params.get(PARAM_FAVORITE);
            this.setShowOnlyFavorites(favorite);
            return true;
        }
        return false;
    }

    public TypedMap executeWithResult(String command, TypedMap args) {
        TypedMap rc = super.executeWithResult(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_CHECKSTATUS.equals(command)) {
            BlockPos c = (BlockPos)args.get(PARAM_POS);
            int dim = (Integer)args.get(PARAM_DIMENSION);
            return TypedMap.builder().put(PARAM_STATUS, (Object)this.checkStatus(c, dim)).build();
        }
        if (CMD_DIAL.equals(command)) {
            String player = (String)args.get(PARAM_PLAYER);
            BlockPos transmitter = (BlockPos)args.get(PARAM_TRANSMITTER);
            int transDim = (Integer)args.get(PARAM_TRANS_DIMENSION);
            BlockPos c = (BlockPos)args.get(PARAM_POS);
            int dim = (Integer)args.get(PARAM_DIMENSION);
            return TypedMap.builder().put(PARAM_STATUS, (Object)this.dial(player, transmitter, transDim, c, dim, false)).build();
        }
        if (CMD_DIALONCE.equals(command)) {
            String player = (String)args.get(PARAM_PLAYER);
            BlockPos transmitter = (BlockPos)args.get(PARAM_TRANSMITTER);
            int transDim = (Integer)args.get(PARAM_TRANS_DIMENSION);
            BlockPos c = (BlockPos)args.get(PARAM_POS);
            int dim = (Integer)args.get(PARAM_DIMENSION);
            return TypedMap.builder().put(PARAM_STATUS, (Object)this.dial(player, transmitter, transDim, c, dim, true)).build();
        }
        return null;
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if ("getReceivers".equals(command)) {
            GuiDialingDevice.fromServer_receivers = Type.create(TeleportDestinationClientInfo.class).convert(list);
            return true;
        }
        if ("getTransmitters".equals(command)) {
            GuiDialingDevice.fromServer_transmitters = Type.create(TransmitterInfo.class).convert(list);
            return true;
        }
        return false;
    }

    public boolean receiveDataFromServer(String command, @Nonnull TypedMap result) {
        boolean rc = super.receiveDataFromServer(command, result);
        if (rc) {
            return true;
        }
        if (CMD_CHECKSTATUS.equals(command)) {
            GuiDialingDevice.fromServer_receiverStatus = (Integer)result.get(PARAM_STATUS);
            return true;
        }
        if (CMD_DIAL.equals(command) || CMD_DIALONCE.equals(command)) {
            GuiDialingDevice.fromServer_dialResult = (Integer)result.get(PARAM_STATUS);
            return true;
        }
        return false;
    }
}

