/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class SimpleDialerTileEntity
extends LogicTileEntity {
    private GlobalCoordinate transmitter;
    private Integer receiver;
    private boolean onceMode = false;
    private boolean prevIn = false;

    public void update() {
        if (this.transmitter == null) {
            return;
        }
        if (this.powerLevel > 0 == this.prevIn) {
            return;
        }
        this.prevIn = this.powerLevel > 0;
        this.markDirty();
        if (this.powerLevel > 0) {
            int dial;
            GlobalCoordinate gc;
            TeleportDestinations destinations = TeleportDestinations.getDestinations(this.getWorld());
            BlockPos coordinate = null;
            int dim = 0;
            if (this.receiver != null && (gc = destinations.getCoordinateForId(this.receiver)) != null) {
                coordinate = gc.getCoordinate();
                dim = gc.getDimension();
            }
            if ((dial = TeleportationTools.dial(this.getWorld(), null, null, this.transmitter.getCoordinate(), this.transmitter.getDimension(), coordinate, dim, this.onceMode)) != 0) {
                // empty if block
            }
        }
    }

    public boolean isOnceMode() {
        return this.onceMode;
    }

    public void setOnceMode(boolean onceMode) {
        this.onceMode = onceMode;
        this.markDirtyClient();
    }

    public GlobalCoordinate getTransmitter() {
        return this.transmitter;
    }

    public Integer getReceiver() {
        return this.receiver;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.transmitter = tagCompound.hasKey("transX") ? new GlobalCoordinate(new BlockPos(tagCompound.getInteger("transX"), tagCompound.getInteger("transY"), tagCompound.getInteger("transZ")), tagCompound.getInteger("transDim")) : null;
        this.receiver = tagCompound.hasKey("receiver") ? Integer.valueOf(tagCompound.getInteger("receiver")) : null;
        this.onceMode = tagCompound.getBoolean("once");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        if (this.transmitter != null) {
            tagCompound.setInteger("transX", this.transmitter.getCoordinate().getX());
            tagCompound.setInteger("transY", this.transmitter.getCoordinate().getY());
            tagCompound.setInteger("transZ", this.transmitter.getCoordinate().getZ());
            tagCompound.setInteger("transDim", this.transmitter.getDimension());
        }
        if (this.receiver != null) {
            tagCompound.setInteger("receiver", this.receiver.intValue());
        }
        tagCompound.setBoolean("once", this.onceMode);
    }
}

