/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.rftools.commands.RfToolsCommand;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public abstract class DefaultCommand
implements ICommand {
    protected final Map<String, RfToolsCommand> commands = new HashMap<String, RfToolsCommand>();

    public DefaultCommand() {
        this.registerCommand(new CmdHelp());
    }

    protected void registerCommand(RfToolsCommand command) {
        this.commands.put(command.getCommand(), command);
    }

    public void showHelp(ICommandSender sender) {
        TextComponentString component1 = new TextComponentString(TextFormatting.BLUE + this.getName() + " <subcommand> <args>");
        if (sender instanceof EntityPlayer) {
            ((EntityPlayer)sender).sendStatusMessage((ITextComponent)component1, false);
        } else {
            sender.sendMessage((ITextComponent)component1);
        }
        for (Map.Entry<String, RfToolsCommand> me : this.commands.entrySet()) {
            TextComponentString component = new TextComponentString("    " + me.getKey() + " " + me.getValue().getHelp());
            if (sender instanceof EntityPlayer) {
                ((EntityPlayer)sender).sendStatusMessage((ITextComponent)component, false);
                continue;
            }
            sender.sendMessage((ITextComponent)component);
        }
    }

    public String getUsage(ICommandSender sender) {
        return this.getName() + " <subcommand> <args> (try '" + this.getName() + " help' for more info)";
    }

    public List<String> getAliases() {
        return Collections.emptyList();
    }

    public void execute(MinecraftServer server, ICommandSender sender, String[] args) {
        World world = sender.getEntityWorld();
        if (args.length <= 0) {
            if (!world.isRemote) {
                this.showHelp(sender);
            }
        } else {
            RfToolsCommand command = this.commands.get(args[0]);
            if (command == null) {
                if (!world.isRemote) {
                    TextComponentString component = new TextComponentString(TextFormatting.RED + "Unknown RfTools command: " + args[0]);
                    if (sender instanceof EntityPlayer) {
                        ((EntityPlayer)sender).sendStatusMessage((ITextComponent)component, false);
                    } else {
                        sender.sendMessage((ITextComponent)component);
                    }
                }
            } else if (world.isRemote) {
                if (command.isClientSide()) {
                    command.execute(sender, args);
                }
            } else if (!sender.canUseCommand(command.getPermissionLevel(), this.getName())) {
                TextComponentString component = new TextComponentString(TextFormatting.RED + "Command is not allowed!");
                if (sender instanceof EntityPlayer) {
                    ((EntityPlayer)sender).sendStatusMessage((ITextComponent)component, false);
                } else {
                    sender.sendMessage((ITextComponent)component);
                }
            } else {
                command.execute(sender, args);
            }
        }
    }

    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        return new ArrayList<String>();
    }

    public boolean checkPermission(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public boolean isUsernameIndex(String[] sender, int p_82358_2_) {
        return false;
    }

    public int compareTo(ICommand o) {
        return this.getName().compareTo(o.getName());
    }

    class CmdHelp
    implements RfToolsCommand {
        CmdHelp() {
        }

        @Override
        public String getHelp() {
            return "";
        }

        @Override
        public int getPermissionLevel() {
            return 0;
        }

        @Override
        public boolean isClientSide() {
            return false;
        }

        @Override
        public String getCommand() {
            return "help";
        }

        @Override
        public void execute(ICommandSender sender, String[] args) {
            DefaultCommand.this.showHelp(sender);
        }
    }
}

