/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.compat.wheelsupport;

import javax.annotation.Nullable;
import mcjty.intwheel.api.IWheelAction;
import mcjty.intwheel.api.WheelActionElement;
import mcjty.rftools.blocks.screens.ScreenBlock;
import mcjty.rftools.blocks.screens.ScreenHitBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ToggleScreenTransparentAction
implements IWheelAction {
    public static final String ACTION_TOGGLESCREENTRANSPARENT = "rftools.toggletransp";

    public String getId() {
        return ACTION_TOGGLESCREENTRANSPARENT;
    }

    public WheelActionElement createElement() {
        return new WheelActionElement(ACTION_TOGGLESCREENTRANSPARENT).description("Toggle screen transparency", null).texture("rftools:textures/gui/wheel_actions.png", 64, 0, 64, 32, 128, 128);
    }

    public boolean performClient(EntityPlayer player, World world, @Nullable BlockPos pos, boolean extended) {
        return true;
    }

    public void performServer(EntityPlayer player, World world, @Nullable BlockPos pos, boolean extended) {
        if (pos != null) {
            BlockPos screenPos;
            Block block = world.getBlockState(pos).getBlock();
            if (block instanceof ScreenBlock) {
                ((ScreenBlock)block).cycleTranspMode(world, pos);
            } else if (block instanceof ScreenHitBlock && (screenPos = ((ScreenHitBlock)block).getScreenBlockPos(world, pos)) != null && (block = world.getBlockState(screenPos).getBlock()) instanceof ScreenBlock) {
                ((ScreenBlock)block).cycleTranspMode(world, screenPos);
            }
        }
    }
}

