/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.crafting;

import com.google.gson.JsonObject;
import mcjty.rftools.items.storage.StorageModuleTabletItem;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ContainerToItemRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        ShapedOreRecipe recipe = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = recipe.getRecipeWidth();
        primer.height = recipe.getRecipeHeight();
        primer.mirrored = JsonUtils.getBoolean((JsonObject)json, (String)"mirrored", (boolean)true);
        primer.input = recipe.getIngredients();
        return new ContainerToItemRecipe(new ResourceLocation("rftools", "container_to_item"), recipe.getRecipeOutput(), primer);
    }

    public static class ContainerToItemRecipe
    extends ShapedOreRecipe {
        public ContainerToItemRecipe(ResourceLocation group, ItemStack result, CraftingHelper.ShapedPrimer primer) {
            super(group, result, primer);
        }

        public ItemStack getCraftingResult(InventoryCrafting inventoryCrafting) {
            ItemStack result = super.getCraftingResult(inventoryCrafting);
            if (!result.isEmpty()) {
                ItemStack tabletItem = ItemStack.EMPTY;
                for (int i = 0; i < inventoryCrafting.getSizeInventory(); ++i) {
                    ItemStack stack = inventoryCrafting.getStackInSlot(i);
                    if (stack.isEmpty() || !(stack.getItem() instanceof StorageModuleTabletItem)) continue;
                    tabletItem = stack;
                }
                NBTTagCompound tagCompound = null;
                if (!tabletItem.isEmpty()) {
                    tagCompound = tabletItem.getTagCompound();
                }
                int childDamage = 0;
                NBTTagCompound newtag = new NBTTagCompound();
                if (tagCompound != null) {
                    for (Object o : tagCompound.getKeySet()) {
                        String tag = (String)o;
                        if ("childDamage".equals(tag) || "Energy".equals(tag) || "grid".equals(tag)) continue;
                        newtag.setTag(tag, tagCompound.getTag(tag));
                    }
                    childDamage = tagCompound.getInteger("childDamage");
                    if (childDamage == 666) {
                        childDamage = 0;
                    }
                }
                result.setItemDamage(childDamage);
                result.setTagCompound(newtag);
            }
            return result;
        }
    }
}

