/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.builder;

import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GuiItemScreen;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.rftools.RFTools;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GuiChamberDetails
extends GuiItemScreen {
    private static final int CHAMBER_XSIZE = 390;
    private static final int CHAMBER_YSIZE = 210;
    private static Map<IBlockState, Integer> items = null;
    private static Map<IBlockState, Integer> costs = null;
    private static Map<IBlockState, ItemStack> stacks = null;
    private static Map<String, Integer> entities = null;
    private static Map<String, Integer> entityCosts = null;
    private static Map<String, Entity> realEntities = null;
    private static Map<String, String> playerNames = null;
    private WidgetList blockList;
    private Label infoLabel;
    private Label info2Label;

    public GuiChamberDetails() {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, 390, 210, GuiProxy.GUI_MANUAL_SHAPE, "chambercard");
        this.requestChamberInfoFromServer();
    }

    public static void setItemsWithCount(Map<IBlockState, Integer> items, Map<IBlockState, Integer> costs, Map<IBlockState, ItemStack> stacks, Map<String, Integer> entities, Map<String, Integer> entityCosts, Map<String, Entity> realEntities, Map<String, String> playerNames) {
        GuiChamberDetails.items = new HashMap<IBlockState, Integer>(items);
        GuiChamberDetails.costs = new HashMap<IBlockState, Integer>(costs);
        GuiChamberDetails.stacks = new HashMap<IBlockState, ItemStack>(stacks);
        GuiChamberDetails.entities = new HashMap<String, Integer>(entities);
        GuiChamberDetails.entityCosts = new HashMap<String, Integer>(entityCosts);
        GuiChamberDetails.realEntities = new HashMap<String, Entity>(realEntities);
        GuiChamberDetails.playerNames = new HashMap<String, String>(playerNames);
    }

    private void requestChamberInfoFromServer() {
        RFToolsMessages.sendToServer("getChamberInfo");
    }

    public void initGui() {
        super.initGui();
        this.blockList = (WidgetList)new WidgetList(this.mc, (Gui)this).setName("blocks");
        Slider listSlider = ((Slider)new Slider(this.mc, (Gui)this).setDesiredWidth(10)).setVertical().setScrollableName("blocks");
        Panel listPanel = (Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(3)).addChildren(new Widget[]{this.blockList, listSlider});
        this.infoLabel = (Label)new Label(this.mc, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        ((Label)this.infoLabel.setDesiredWidth(380)).setDesiredHeight(14);
        this.info2Label = (Label)new Label(this.mc, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        ((Label)this.info2Label.setDesiredWidth(380)).setDesiredHeight(14);
        Panel toplevel = (Panel)((Panel)new Panel(this.mc, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)((VerticalLayout)new VerticalLayout().setSpacing(1)).setVerticalMargin(3)).addChildren(new Widget[]{listPanel, this.infoLabel, this.info2Label});
        toplevel.setBounds(new Rectangle(this.guiLeft, this.guiTop, this.xSize, this.ySize));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
    }

    private void populateLists() {
        this.blockList.removeChildren();
        if (items == null) {
            return;
        }
        int totalCost = 0;
        for (Map.Entry<IBlockState, Integer> entry : items.entrySet()) {
            IBlockState bm = entry.getKey();
            int count = entry.getValue();
            int cost = costs.get(bm);
            Panel panel = (Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(16);
            ItemStack stack = stacks.containsKey(bm) ? stacks.get(bm) : new ItemStack(bm.getBlock(), 0, bm.getBlock().getMetaFromState(bm));
            BlockRender blockRender = new BlockRender(this.mc, (Gui)this).setRenderItem((Object)stack).setOffsetX(-1).setOffsetY(-1);
            Label nameLabel = (Label)((Label)new Label(this.mc, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setColor(StyleConfig.colorTextInListNormal);
            if (stack.getItem() == null) {
                ((Label)nameLabel.setText("?")).setDesiredWidth(160);
            } else {
                ((Label)nameLabel.setText(stack.getDisplayName())).setDesiredWidth(160);
            }
            Label countLabel = (Label)((Label)new Label(this.mc, (Gui)this).setText(String.valueOf(count))).setColor(StyleConfig.colorTextInListNormal);
            ((Label)countLabel.setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setDesiredWidth(50);
            Label costLabel = (Label)new Label(this.mc, (Gui)this).setColor(StyleConfig.colorTextInListNormal);
            costLabel.setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
            if (cost == -1) {
                costLabel.setText("NOT MOVABLE!");
            } else {
                costLabel.setText("Move Cost " + cost + " RF");
                totalCost += cost;
            }
            panel.addChildren(new Widget[]{blockRender, nameLabel, countLabel, costLabel});
            this.blockList.addChild((Widget)panel);
        }
        int totalCostEntities = 0;
        RenderHelper.rot += 0.5f;
        for (Map.Entry<String, Integer> entry : entities.entrySet()) {
            String className = entry.getKey();
            int count = entry.getValue();
            int cost = entityCosts.get(className);
            Panel panel = (Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(16);
            String entityName = "<?>";
            Entity entity = null;
            if (realEntities.containsKey(className)) {
                EntityItem entityItem;
                entity = realEntities.get(className);
                entityName = EntityList.getEntityString((Entity)entity);
                if (entity instanceof EntityItem && !(entityItem = (EntityItem)entity).getItem().isEmpty()) {
                    String displayName = entityItem.getItem().getDisplayName();
                    entityName = entityName + " (" + displayName + ")";
                }
            } else {
                try {
                    Class<?> aClass = Class.forName(className);
                    entity = (Entity)aClass.getConstructor(World.class).newInstance(this.mc.world);
                    entityName = aClass.getSimpleName();
                }
                catch (ClassNotFoundException aClass) {
                }
                catch (InstantiationException aClass) {
                }
                catch (IllegalAccessException aClass) {
                }
                catch (InvocationTargetException aClass) {
                }
                catch (NoSuchMethodException aClass) {
                    // empty catch block
                }
            }
            if (playerNames.containsKey(className)) {
                entityName = playerNames.get(className);
            }
            BlockRender blockRender = new BlockRender(this.mc, (Gui)this).setRenderItem((Object)entity).setOffsetX(-1).setOffsetY(-1);
            Label nameLabel = (Label)new Label(this.mc, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
            ((Label)nameLabel.setText(entityName)).setDesiredWidth(160);
            Label countLabel = (Label)new Label(this.mc, (Gui)this).setText(String.valueOf(count));
            ((Label)countLabel.setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setDesiredWidth(50);
            Label costLabel = new Label(this.mc, (Gui)this);
            costLabel.setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
            if (cost == -1) {
                costLabel.setText("NOT MOVABLE!");
            } else {
                costLabel.setText("Move Cost " + cost + " RF");
                totalCostEntities += cost;
            }
            panel.addChildren(new Widget[]{blockRender, nameLabel, countLabel, costLabel});
            this.blockList.addChild((Widget)panel);
        }
        this.infoLabel.setText("Total cost blocks: " + totalCost + " RF");
        this.info2Label.setText("Total cost entities: " + totalCostEntities + " RF");
    }

    public void drawScreen(int xSize_lo, int ySize_lo, float par3) {
        super.drawScreen(xSize_lo, ySize_lo, par3);
        this.populateLists();
        this.drawWindow();
    }
}

