/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.storage;

import java.util.HashSet;
import java.util.Set;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftools.blocks.storage.sorters.ModItemSorter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;

public class StorageFilterCache {
    private boolean matchDamage = true;
    private boolean oredictMode = false;
    private boolean blacklistMode = true;
    private boolean nbtMode = false;
    private boolean modMode = false;
    private ItemStackList stacks;
    private Set<Integer> oredictMatches = new HashSet<Integer>();

    StorageFilterCache(ItemStack stack) {
        NBTTagCompound tagCompound = stack.getTagCompound();
        if (tagCompound != null) {
            ItemStack s;
            NBTTagCompound nbtTagCompound;
            int i;
            this.matchDamage = tagCompound.getBoolean("damageMode");
            this.oredictMode = tagCompound.getBoolean("oredictMode");
            this.nbtMode = tagCompound.getBoolean("nbtMode");
            this.modMode = tagCompound.getBoolean("modMode");
            this.blacklistMode = "Black".equals(tagCompound.getString("blacklistMode"));
            NBTTagList bufferTagList = tagCompound.getTagList("Items", 10);
            int cnt = 0;
            for (i = 0; i < bufferTagList.tagCount(); ++i) {
                nbtTagCompound = bufferTagList.getCompoundTagAt(i);
                s = new ItemStack(nbtTagCompound);
                if (s.isEmpty()) continue;
                ++cnt;
            }
            this.stacks = ItemStackList.create((int)cnt);
            cnt = 0;
            for (i = 0; i < bufferTagList.tagCount(); ++i) {
                nbtTagCompound = bufferTagList.getCompoundTagAt(i);
                s = new ItemStack(nbtTagCompound);
                if (s.isEmpty()) continue;
                this.stacks.set(cnt++, (Object)s);
                if (!this.oredictMode) continue;
                for (int id : OreDictionary.getOreIDs((ItemStack)s)) {
                    this.oredictMatches.add(id);
                }
            }
        } else {
            this.stacks = ItemStackList.EMPTY;
        }
    }

    public boolean match(ItemStack stack) {
        if (!stack.isEmpty()) {
            boolean match = false;
            String modName = "";
            if (this.modMode) {
                modName = ModItemSorter.getMod(stack);
            }
            if (this.oredictMode) {
                int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
                if (oreIDs.length == 0) {
                    match = this.itemMatches(stack, modName);
                } else {
                    for (int id : oreIDs) {
                        if (!this.oredictMatches.contains(id)) continue;
                        match = true;
                        break;
                    }
                }
            } else {
                match = this.itemMatches(stack, modName);
            }
            return match != this.blacklistMode;
        }
        return false;
    }

    private boolean itemMatches(ItemStack stack, String modName) {
        if (this.stacks != null) {
            for (ItemStack itemStack : this.stacks) {
                if (this.matchDamage && itemStack.getMetadata() != stack.getMetadata() || this.nbtMode && !ItemStack.areItemStackTagsEqual((ItemStack)itemStack, (ItemStack)stack) || !(this.modMode ? modName.equals(ModItemSorter.getMod(itemStack)) : itemStack.getItem().equals(stack.getItem()))) continue;
                return true;
            }
        }
        return false;
    }
}

