/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.teleportprobe;

import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.TeleportationTools;
import mcjty.rftools.ClientCommandHandler;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.items.teleportprobe.AdvancedChargedPorterItem;
import mcjty.rftools.items.teleportprobe.PacketTargetsReady;
import mcjty.rftools.items.teleportprobe.TeleportProbeItem;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PorterTools {
    public static void clearTarget(EntityPlayer player, int index) {
        ItemStack heldItem = player.getHeldItem(EnumHand.MAIN_HAND);
        if (heldItem.isEmpty()) {
            return;
        }
        NBTTagCompound tagCompound = heldItem.getTagCompound();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.hasKey("target" + index)) {
            int id = tagCompound.getInteger("target" + index);
            if (tagCompound.hasKey("target") && tagCompound.getInteger("target") == id) {
                tagCompound.removeTag("target");
            }
            tagCompound.removeTag("target" + index);
        }
    }

    public static void forceTeleport(EntityPlayer player, int dimension, BlockPos pos) {
        boolean probeInOffHand;
        boolean probeInMainHand = !player.getHeldItemMainhand().isEmpty() && player.getHeldItemMainhand().getItem() instanceof TeleportProbeItem;
        boolean bl = probeInOffHand = !player.getHeldItemOffhand().isEmpty() && player.getHeldItemOffhand().getItem() instanceof TeleportProbeItem;
        if (!probeInMainHand && !probeInOffHand) {
            return;
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int currentId = player.getEntityWorld().provider.getDimension();
        if (currentId != dimension) {
            TeleportationTools.teleportToDimension((EntityPlayer)player, (int)dimension, (double)((double)x + 0.5), (double)(y + 1), (double)((double)z + 0.5));
        } else {
            player.setPositionAndUpdate((double)x + 0.5, (double)y + 1.5, (double)z + 0.5);
        }
    }

    public static void cycleDestination(EntityPlayer player, boolean next) {
        ItemStack stack = player.getHeldItemMainhand();
        if (!stack.isEmpty() && stack.getItem() instanceof AdvancedChargedPorterItem) {
            int tgt;
            NBTTagCompound tagCompound = stack.getTagCompound();
            if (tagCompound == null) {
                return;
            }
            TeleportDestinations destinations = TeleportDestinations.getDestinations(player.getEntityWorld());
            int curtarget = tagCompound.getInteger("target");
            int donext = 0;
            for (int i = 0; i < 16 && (donext = PorterTools.checkTarget(player, tagCompound, destinations, curtarget, donext, tgt = next ? i % 8 : (16 - i) % 8)) != 2; ++i) {
            }
        }
    }

    private static int checkTarget(EntityPlayer playerEntity, NBTTagCompound tagCompound, TeleportDestinations destinations, int curtarget, int donext, int tgt) {
        TeleportDestination destination;
        int target;
        GlobalCoordinate gc;
        if (tagCompound.hasKey("target" + tgt) && (gc = destinations.getCoordinateForId(target = tagCompound.getInteger("target" + tgt))) != null && (destination = destinations.getDestination(gc)) != null) {
            if (donext == 1) {
                String name = destination.getName() + " (dimension " + destination.getDimension() + ")";
                tagCompound.setInteger("target", target);
                TextComponentString component = new TextComponentString(TextFormatting.GREEN + "Target: " + TextFormatting.WHITE + name);
                if (playerEntity != null) {
                    playerEntity.sendStatusMessage((ITextComponent)component, false);
                }
                donext = 2;
            } else if (target == curtarget) {
                donext = 1;
            }
        }
        return donext;
    }

    public static void returnDestinationInfo(EntityPlayer player, int receiverId) {
        World world = player.getEntityWorld();
        TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
        String name = TeleportDestinations.getDestinationName(destinations, receiverId);
        RFToolsMessages.sendToClient(player, "returnDestinationInfo", TypedMap.builder().put(ClientCommandHandler.PARAM_ID, (Object)receiverId).put(ClientCommandHandler.PARAM_NAME, (Object)name));
    }

    public static void setTarget(EntityPlayer player, int target) {
        ItemStack heldItem = player.getHeldItem(EnumHand.MAIN_HAND);
        if (heldItem.isEmpty()) {
            return;
        }
        NBTTagCompound tagCompound = heldItem.getTagCompound();
        if (tagCompound == null) {
            return;
        }
        tagCompound.setInteger("target", target);
    }

    public static void returnTargets(EntityPlayer player) {
        int i;
        ItemStack heldItem = player.getHeldItem(EnumHand.MAIN_HAND);
        if (heldItem.isEmpty()) {
            return;
        }
        NBTTagCompound tagCompound = heldItem.getTagCompound();
        int target = -1;
        int[] targets = new int[8];
        String[] names = new String[8];
        TeleportDestinations destinations = TeleportDestinations.getDestinations(player.getEntityWorld());
        if (tagCompound != null) {
            target = tagCompound.hasKey("target") ? tagCompound.getInteger("target") : -1;
            for (i = 0; i < 8; ++i) {
                names[i] = "";
                if (tagCompound.hasKey("target" + i)) {
                    TeleportDestination destination;
                    targets[i] = tagCompound.getInteger("target" + i);
                    GlobalCoordinate gc = destinations.getCoordinateForId(targets[i]);
                    if (gc == null || (destination = destinations.getDestination(gc)) == null) continue;
                    names[i] = destination.getName() + " (dimension " + destination.getDimension() + ")";
                    continue;
                }
                targets[i] = -1;
            }
        } else {
            for (i = 0; i < 8; ++i) {
                targets[i] = -1;
                names[i] = "";
            }
        }
        PacketTargetsReady msg = new PacketTargetsReady(target, targets, names);
        RFToolsMessages.INSTANCE.sendTo((IMessage)msg, (EntityPlayerMP)player);
    }
}

