/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.ICommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.rftools.network.PacketHudLogReady;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGetHudLog
implements IMessage {
    public static String CMD_GETHUDLOG = "getHudLog";
    public static String CLIENTCMD_GETHUDLOG = "getHudLog";
    protected BlockPos pos;
    protected TypedMap params;

    public PacketGetHudLog() {
    }

    public PacketGetHudLog(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketGetHudLog(BlockPos pos) {
        this.pos = pos;
        this.params = TypedMap.EMPTY;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.params = TypedMapTools.readArguments((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        TypedMapTools.writeArguments((ByteBuf)buf, (TypedMap)this.params);
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = ctx.getSender().getEntityWorld().getTileEntity(this.pos);
            if (!(te instanceof ICommandHandler)) {
                Logging.log((String)"TileEntity is not a CommandHandler!");
                return;
            }
            ICommandHandler commandHandler = (ICommandHandler)te;
            List list = commandHandler.executeWithResultList(CMD_GETHUDLOG, this.params, Type.STRING);
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketHudLogReady(this.pos, CLIENTCMD_GETHUDLOG, list), ctx.getSender());
        });
        ctx.setPacketHandled(true);
    }
}

