/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.playerprops;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mcjty.lib.varia.GlobalCoordinate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public class FavoriteDestinationsProperties {
    private Set<GlobalCoordinate> favoriteDestinations = new HashSet<GlobalCoordinate>();

    public void copyFrom(FavoriteDestinationsProperties source) {
        this.favoriteDestinations = new HashSet<GlobalCoordinate>(source.favoriteDestinations);
    }

    public boolean isDestinationFavorite(GlobalCoordinate coordinate) {
        return this.favoriteDestinations.contains(coordinate);
    }

    public void setDestinationFavorite(GlobalCoordinate coordinate, boolean favorite) {
        if (favorite) {
            this.favoriteDestinations.add(coordinate);
        } else {
            this.favoriteDestinations.remove(coordinate);
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        FavoriteDestinationsProperties.writeFavoritesToNBT(compound, this.favoriteDestinations);
    }

    private static void writeFavoritesToNBT(NBTTagCompound tagCompound, Collection<GlobalCoordinate> destinations) {
        NBTTagList lst = new NBTTagList();
        for (GlobalCoordinate destination : destinations) {
            NBTTagCompound tc = new NBTTagCompound();
            BlockPos c = destination.getCoordinate();
            tc.setInteger("x", c.getX());
            tc.setInteger("y", c.getY());
            tc.setInteger("z", c.getZ());
            tc.setInteger("dim", destination.getDimension());
            lst.appendTag((NBTBase)tc);
        }
        tagCompound.setTag("destinations", (NBTBase)lst);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.favoriteDestinations.clear();
        FavoriteDestinationsProperties.readCoordinatesFromNBT(compound, this.favoriteDestinations);
    }

    private static void readCoordinatesFromNBT(NBTTagCompound tagCompound, Set<GlobalCoordinate> destinations) {
        NBTTagList lst = tagCompound.getTagList("destinations", 10);
        for (int i = 0; i < lst.tagCount(); ++i) {
            NBTTagCompound tc = lst.getCompoundTagAt(i);
            BlockPos c = new BlockPos(tc.getInteger("x"), tc.getInteger("y"), tc.getInteger("z"));
            destinations.add(new GlobalCoordinate(c, tc.getInteger("dim")));
        }
    }
}

