/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.shapes.IFormula;
import mcjty.rftools.shapes.Shape;
import mcjty.rftools.shapes.ShapeDataManagerServer;
import mcjty.rftools.shapes.ShapeID;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketRequestShapeData
implements IMessage {
    private ItemStack card;
    private ShapeID id;

    public void fromBytes(ByteBuf buf) {
        this.card = NetworkTools.readItemStack((ByteBuf)buf);
        this.id = new ShapeID(buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)this.card);
        this.id.toBytes(buf);
    }

    public PacketRequestShapeData() {
    }

    public PacketRequestShapeData(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketRequestShapeData(ItemStack card, ShapeID id) {
        this.card = card;
        this.id = id;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            Shape shape = ShapeCardItem.getShape(this.card);
            boolean solid = ShapeCardItem.isSolid(this.card);
            BlockPos dimension = ShapeCardItem.getDimension(this.card);
            BlockPos clamped = new BlockPos(Math.min(dimension.getX(), 512), Math.min(dimension.getY(), 256), Math.min(dimension.getZ(), 512));
            int dy = clamped.getY();
            this.card = this.card.copy();
            IFormula formula = shape.getFormulaFactory().get();
            formula = formula.correctFormula(solid);
            formula.setup(new BlockPos(0, 0, 0), clamped, new BlockPos(0, 0, 0), this.card.getTagCompound());
            for (int y = 0; y < dy; ++y) {
                ShapeDataManagerServer.pushWork(this.id, this.card, y, formula, ctx.getSender());
            }
        });
        ctx.setPacketHandled(true);
    }
}

