/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.shapes.ShapeBlockInfo;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import org.apache.commons.lang3.tuple.Pair;

public class RenderData {
    private static BufferBuilder vboBuffer = new BufferBuilder(0x200000);
    private RenderPlane[] planes = null;
    public String previewMessage = "";
    private long touchTime = 0L;
    private long checksum = -1L;
    private boolean wantData = true;

    public boolean hasData() {
        if (this.planes == null) {
            return false;
        }
        for (RenderPlane plane : this.planes) {
            if (plane == null || plane.vbo == null && plane.glList == -1) continue;
            return true;
        }
        return false;
    }

    public int getBlockCount() {
        if (this.planes != null) {
            int cnt = 0;
            for (RenderPlane plane : this.planes) {
                if (plane == null) continue;
                cnt += plane.getCount();
            }
            return cnt;
        }
        return 0;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    public boolean isWantData() {
        return this.planes == null || this.wantData;
    }

    public void setWantData(boolean wantData) {
        this.wantData = wantData;
    }

    public RenderPlane[] getPlanes() {
        return this.planes;
    }

    public void setPlaneData(@Nullable RenderPlane plane, int offsetY, int dy) {
        if (this.planes == null) {
            this.planes = new RenderPlane[dy];
        } else if (this.planes.length != dy) {
            this.cleanup();
            this.planes = new RenderPlane[dy];
        }
        if (plane != null) {
            if (this.planes[offsetY] == null) {
                this.planes[offsetY] = plane;
            } else {
                this.planes[offsetY].refreshData(plane);
            }
        }
    }

    public void touch() {
        this.touchTime = System.currentTimeMillis();
    }

    public boolean tooOld() {
        return this.touchTime + (long)ScannerConfiguration.clientRenderDataTimeout.get() < System.currentTimeMillis();
    }

    public void cleanup() {
        if (this.planes != null) {
            for (RenderPlane plane : this.planes) {
                if (plane == null) continue;
                plane.cleanup();
            }
        }
    }

    public BufferBuilder createRenderList(BufferBuilder buffer, int y) {
        if (this.planes != null) {
            return this.planes[y].createRenderList(buffer);
        }
        return null;
    }

    public void performRenderToList(Tessellator tessellator, BufferBuilder buffer, int y) {
        if (this.planes != null) {
            this.planes[y].performRenderToList(tessellator, buffer);
        }
    }

    public static class RenderPlane
    extends RenderElement {
        private RenderStrip[] strips;
        private int y;
        private int offsety;
        private int startz;
        private boolean dirty = true;
        private int count = 0;
        private long birthtime;

        public RenderPlane(RenderStrip[] strips, int y, int offsety, int startz, int count) {
            this.strips = strips;
            this.y = y;
            this.offsety = offsety;
            this.startz = startz;
            this.count = count;
            this.birthtime = System.currentTimeMillis();
        }

        public void refreshData(RenderPlane other) {
            this.strips = other.strips;
            this.y = other.y;
            this.offsety = other.offsety;
            this.startz = other.startz;
            this.count = other.count;
            this.dirty = true;
            this.birthtime = System.currentTimeMillis();
            super.cleanup();
        }

        public long getBirthtime() {
            return this.birthtime;
        }

        public int getCount() {
            return this.count;
        }

        public void markClean() {
            this.dirty = false;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public RenderStrip[] getStrips() {
            return this.strips;
        }

        public int getOffsety() {
            return this.offsety;
        }

        public int getY() {
            return this.y;
        }

        public int getStartz() {
            return this.startz;
        }
    }

    public static class RenderStrip {
        private final List<Pair<Integer, IBlockState>> data = new ArrayList<Pair<Integer, IBlockState>>();
        private final int x;
        private IBlockState last;
        private int cnt = 0;

        public RenderStrip(int x) {
            this.x = x;
        }

        public int getX() {
            return this.x;
        }

        public List<Pair<Integer, IBlockState>> getData() {
            return this.data;
        }

        public boolean isEmptyAt(int i, Map<IBlockState, ShapeBlockInfo> palette) {
            if (i < 0) {
                return true;
            }
            if (i >= this.data.size()) {
                return true;
            }
            IBlockState state = (IBlockState)this.data.get(i).getValue();
            if (ShapeBlockInfo.getBlockInfo(palette, state).isNonSolid()) {
                return true;
            }
            return state == null;
        }

        public void add(IBlockState state) {
            if (this.cnt == 0) {
                this.last = state;
                this.cnt = 1;
            } else if (this.last != state) {
                this.data.add((Pair<Integer, IBlockState>)Pair.of((Object)this.cnt, (Object)this.last));
                this.last = state;
                this.cnt = 1;
            } else {
                ++this.cnt;
            }
        }

        public void close() {
            if (this.cnt > 0) {
                this.data.add((Pair<Integer, IBlockState>)Pair.of((Object)this.cnt, (Object)this.last));
                this.cnt = 0;
            }
        }
    }

    public static class RenderElement {
        protected int glList = -1;
        protected VertexBuffer vbo;

        public void cleanup() {
            if (ScannerConfiguration.useVBO.get()) {
                if (this.vbo != null) {
                    this.vbo.deleteGlBuffers();
                    this.vbo = null;
                }
            } else if (this.glList != -1) {
                GLAllocation.deleteDisplayLists((int)this.glList);
                this.glList = -1;
            }
        }

        public void render() {
            if (ScannerConfiguration.useVBO.get()) {
                if (this.vbo != null) {
                    this.vbo.bindBuffer();
                    GlStateManager.glEnableClientState((int)32884);
                    GlStateManager.glVertexPointer((int)3, (int)5126, (int)16, (int)0);
                    GlStateManager.glEnableClientState((int)32886);
                    GlStateManager.glColorPointer((int)4, (int)5121, (int)16, (int)12);
                    this.vbo.drawArrays(7);
                    this.vbo.unbindBuffer();
                    GlStateManager.glDisableClientState((int)32886);
                    GlStateManager.glDisableClientState((int)32884);
                }
            } else if (this.glList != -1) {
                GlStateManager.callList((int)this.glList);
            }
        }

        public BufferBuilder createRenderList(BufferBuilder buffer) {
            if (ScannerConfiguration.useVBO.get()) {
                this.vbo = new VertexBuffer(DefaultVertexFormats.POSITION_COLOR);
                buffer = vboBuffer;
            } else {
                this.glList = GLAllocation.generateDisplayLists((int)1);
                GlStateManager.glNewList((int)this.glList, (int)4864);
            }
            return buffer;
        }

        public void performRenderToList(Tessellator tessellator, BufferBuilder buffer) {
            if (ScannerConfiguration.useVBO.get()) {
                buffer.finishDrawing();
                buffer.reset();
                this.vbo.bufferData(buffer.getByteBuffer());
            } else {
                tessellator.draw();
                GlStateManager.glEndList();
            }
        }
    }
}

