/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcjty.lib.api.information.IMachineInformation;
import mcjty.lib.api.smartwrench.SmartWrenchMode;
import mcjty.lib.client.BlockOutlineRenderer;
import mcjty.lib.client.HudRenderHelper;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.blockprotector.BlockProtectorConfiguration;
import mcjty.rftools.blocks.blockprotector.BlockProtectorTileEntity;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.builder.BuilderTileEntity;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.items.netmonitor.NetworkMonitorItem;
import mcjty.rftools.items.smartwrench.SmartWrenchItem;
import mcjty.rftools.network.MachineInfo;
import mcjty.rftools.network.PacketReturnRfInRange;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.shapes.ShapeDataManagerClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class RenderWorldLastEventHandler {
    private static long lastTime = 0L;
    public static final ResourceLocation YELLOWGLOW = new ResourceLocation("rftools", "textures/blocks/yellowglow.png");

    public static void tick(RenderWorldLastEvent evt) {
        RenderWorldLastEventHandler.renderHilightedBlock(evt);
        RenderWorldLastEventHandler.renderBuilderProgress(evt);
        RenderWorldLastEventHandler.renderProtectedBlocks(evt);
        RenderWorldLastEventHandler.renderPower(evt);
        ShapeDataManagerClient.cleanupOldRenderers();
    }

    private static void renderProtectedBlocks(RenderWorldLastEvent evt) {
        GlobalCoordinate current;
        int mode;
        Minecraft mc = Minecraft.getMinecraft();
        EntityPlayerSP p = mc.player;
        ItemStack heldItem = p.getHeldItem(EnumHand.MAIN_HAND);
        if (heldItem.isEmpty()) {
            return;
        }
        if (heldItem.getItem() == ModItems.smartWrenchItem) {
            BlockProtectorTileEntity blockProtectorTileEntity;
            Set<BlockPos> coordinates;
            TileEntity te;
            GlobalCoordinate current2;
            if (BlockProtectorConfiguration.enabled.get() && SmartWrenchItem.getCurrentMode(heldItem) == SmartWrenchMode.MODE_SELECT && (current2 = SmartWrenchItem.getCurrentBlock(heldItem)) != null && current2.getDimension() == mc.world.provider.getDimension() && (te = mc.world.getTileEntity(current2.getCoordinate())) instanceof BlockProtectorTileEntity && !(coordinates = (blockProtectorTileEntity = (BlockProtectorTileEntity)te).getProtectedBlocks()).isEmpty()) {
                RenderWorldLastEventHandler.renderHighlightedBlocks(evt, p, te.getPos(), coordinates);
            }
        } else if (heldItem.getItem() == BuilderSetup.shapeCardItem && ((mode = ShapeCardItem.getMode(heldItem)) == 1 || mode == 2) && (current = ShapeCardItem.getCurrentBlock(heldItem)) != null && current.getDimension() == mc.world.provider.getDimension()) {
            HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
            coordinates.add(new BlockPos(0, 0, 0));
            if (mode == 2) {
                BlockPos cur = current.getCoordinate();
                BlockPos c = ShapeCardItem.getCorner1(heldItem);
                if (c != null) {
                    coordinates.add(new BlockPos(c.getX() - cur.getX(), c.getY() - cur.getY(), c.getZ() - cur.getZ()));
                }
            }
            RenderWorldLastEventHandler.renderHighlightedBlocks(evt, p, current.getCoordinate(), coordinates);
        }
    }

    private static void renderHighlightedBlocks(RenderWorldLastEvent evt, EntityPlayerSP p, BlockPos base, Set<BlockPos> coordinates) {
        BlockOutlineRenderer.renderHighlightedBlocks((EntityPlayerSP)p, (BlockPos)base, coordinates, (ResourceLocation)YELLOWGLOW, (float)evt.getPartialTicks());
    }

    private static void renderBuilderProgress(RenderWorldLastEvent evt) {
        Map<BlockPos, Pair<Long, BlockPos>> scans = BuilderTileEntity.getScanLocClient();
        if (!scans.isEmpty()) {
            Minecraft mc = Minecraft.getMinecraft();
            EntityPlayerSP p = mc.player;
            double doubleX = p.lastTickPosX + (p.posX - p.lastTickPosX) * (double)evt.getPartialTicks();
            double doubleY = p.lastTickPosY + (p.posY - p.lastTickPosY) * (double)evt.getPartialTicks();
            double doubleZ = p.lastTickPosZ + (p.posZ - p.lastTickPosZ) * (double)evt.getPartialTicks();
            GlStateManager.pushMatrix();
            GlStateManager.color((float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.glLineWidth((float)3.0f);
            GlStateManager.translate((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
            GlStateManager.disableDepth();
            GlStateManager.disableTexture2D();
            Tessellator tessellator = Tessellator.getInstance();
            BufferBuilder buffer = tessellator.getBuffer();
            buffer.begin(1, DefaultVertexFormats.POSITION_COLOR);
            for (Map.Entry<BlockPos, Pair<Long, BlockPos>> entry : scans.entrySet()) {
                BlockPos c = (BlockPos)entry.getValue().getValue();
                float mx = c.getX();
                float my = c.getY();
                float mz = c.getZ();
                RenderHelper.renderHighLightedBlocksOutline((BufferBuilder)buffer, (float)mx, (float)my, (float)mz, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            tessellator.draw();
            GlStateManager.enableTexture2D();
            GlStateManager.popMatrix();
        }
    }

    private static void renderHilightedBlock(RenderWorldLastEvent evt) {
        BlockPos c = RFTools.instance.clientInfo.getHilightedBlock();
        if (c == null) {
            return;
        }
        Minecraft mc = Minecraft.getMinecraft();
        long time = System.currentTimeMillis();
        if (time > RFTools.instance.clientInfo.getExpireHilight()) {
            RFTools.instance.clientInfo.hilightBlock(null, -1L);
            return;
        }
        if ((time / 500L & 1L) == 0L) {
            return;
        }
        BlockOutlineRenderer.renderHilightedBlock((BlockPos)c, (float)evt.getPartialTicks());
    }

    private static void renderPower(RenderWorldLastEvent evt) {
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        ItemStack mainItem = player.getHeldItemMainhand();
        ItemStack offItem = player.getHeldItemOffhand();
        if (!mainItem.isEmpty() && mainItem.getItem() instanceof NetworkMonitorItem || !offItem.isEmpty() && offItem.getItem() instanceof NetworkMonitorItem) {
            double doubleX = player.lastTickPosX + (player.posX - player.lastTickPosX) * (double)evt.getPartialTicks();
            double doubleY = player.lastTickPosY + (player.posY - player.lastTickPosY) * (double)evt.getPartialTicks();
            double doubleZ = player.lastTickPosZ + (player.posZ - player.lastTickPosZ) * (double)evt.getPartialTicks();
            GlStateManager.pushMatrix();
            GlStateManager.translate((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
            GlStateManager.disableDepth();
            GlStateManager.enableTexture2D();
            if (System.currentTimeMillis() - lastTime > 500L) {
                lastTime = System.currentTimeMillis();
                RFToolsMessages.sendToServer("getRfInRange");
            }
            if (PacketReturnRfInRange.clientLevels == null) {
                return;
            }
            for (Map.Entry<BlockPos, MachineInfo> entry : PacketReturnRfInRange.clientLevels.entrySet()) {
                BlockPos pos = entry.getKey();
                ArrayList<String> log = new ArrayList<String>();
                MachineInfo info = entry.getValue();
                log.add(TextFormatting.BLUE + "RF:  " + TextFormatting.WHITE + info.getEnergy());
                log.add(TextFormatting.BLUE + "Max: " + TextFormatting.WHITE + info.getMaxEnergy());
                if (info.getEnergyPerTick() != null) {
                    long usage;
                    TileEntity te = player.getEntityWorld().getTileEntity(pos);
                    String unit = "";
                    if (te instanceof IMachineInformation && (unit = ((IMachineInformation)te).getEnergyUnitName()) == null) {
                        unit = "";
                    }
                    if ((usage = info.getEnergyPerTick().longValue()) < 0L) {
                        log.add(TextFormatting.RED + "" + usage + unit + "/t");
                    } else if (usage > 0L) {
                        log.add(TextFormatting.GREEN + "" + usage + unit + "/t");
                    }
                }
                HudRenderHelper.renderHud(log, (HudRenderHelper.HudPlacement)HudRenderHelper.HudPlacement.HUD_CENTER, (HudRenderHelper.HudOrientation)HudRenderHelper.HudOrientation.HUD_TOPLAYER, null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (float)2.0f);
                RenderWorldLastEventHandler.renderBoxOutline(pos);
            }
            GlStateManager.enableDepth();
            GlStateManager.popMatrix();
        }
    }

    private static void renderBoxOutline(BlockPos pos) {
        BlockPos c = RFTools.instance.clientInfo.getHilightedBlock();
        if (c != null && c.equals((Object)pos)) {
            return;
        }
        BlockOutlineRenderer.renderBoxOutline((BlockPos)pos);
    }
}

