/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.blockprotector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.blocks.blockprotector.BlockProtectorTileEntity;
import mcjty.rftools.blocks.blockprotector.BlockProtectors;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockProtectorEventHandlers {
    @SubscribeEvent
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        Collection<GlobalCoordinate> protectors;
        World world;
        int z;
        int y;
        int x = event.getPos().getX();
        if (BlockProtectors.checkHarvestProtection(x, y = event.getPos().getY(), z = event.getPos().getZ(), (IBlockAccess)(world = event.getWorld()), protectors = BlockProtectors.getProtectors(world, x, y, z))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onDetonate(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        Vec3d explosionVector = explosion.getPosition();
        Collection<GlobalCoordinate> protectors = BlockProtectors.getProtectors(event.getWorld(), (int)explosionVector.x, (int)explosionVector.y, (int)explosionVector.z);
        if (protectors.isEmpty()) {
            return;
        }
        List affectedBlocks = event.getAffectedBlocks();
        ArrayList<BlockPos> toremove = new ArrayList<BlockPos>();
        for (GlobalCoordinate protector : protectors) {
            BlockPos pos = protector.getCoordinate();
            TileEntity te = event.getWorld().getTileEntity(pos);
            if (!(te instanceof BlockProtectorTileEntity)) continue;
            BlockProtectorTileEntity blockProtectorTileEntity = (BlockProtectorTileEntity)te;
            for (BlockPos block : affectedBlocks) {
                BlockPos relative = blockProtectorTileEntity.absoluteToRelative(block);
                boolean b = blockProtectorTileEntity.isProtected(relative);
                if (!b) continue;
                Vec3d blockVector = new Vec3d((Vec3i)block);
                double distanceTo = explosionVector.distanceTo(blockVector);
                int rfneeded = blockProtectorTileEntity.attemptExplosionProtection((float)(distanceTo / (double)explosion.size), explosion.size);
                if (rfneeded > 0) {
                    toremove.add(block);
                    continue;
                }
                blockProtectorTileEntity.removeProtection(relative);
            }
        }
        affectedBlocks.removeAll(toremove);
    }

    @SubscribeEvent
    public static void onLivingDestroyBlock(LivingDestroyBlockEvent event) {
        Collection<GlobalCoordinate> protectors;
        World world;
        int z;
        int y;
        int x = event.getPos().getX();
        if (BlockProtectors.checkHarvestProtection(x, y = event.getPos().getY(), z = event.getPos().getZ(), (IBlockAccess)(world = event.getEntity().getEntityWorld()), protectors = BlockProtectors.getProtectors(world, x, y, z))) {
            event.setCanceled(true);
        }
    }
}

