/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.blockprotector;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import mcjty.lib.api.information.IMachineInformation;
import mcjty.lib.api.smartwrench.SmartWrenchSelector;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.blocks.blockprotector.BlockProtectorConfiguration;
import mcjty.rftools.blocks.blockprotector.BlockProtectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public class BlockProtectorTileEntity
extends GenericEnergyReceiverTileEntity
implements SmartWrenchSelector,
ITickable,
IMachineInformation,
SimpleComponent {
    public static final String CMD_RSMODE = "protector.setRsMode";
    public static final String COMPONENT_NAME = "block_protector";
    private int id = -1;
    private boolean active = false;
    private Set<BlockPos> protectedBlocks = new HashSet<BlockPos>();

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Callback(doc="Get or set the current redstone mode. Values are 'Ignored', 'Off', or 'On'", getter=true, setter=true)
    @Optional.Method(modid="opencomputers")
    public Object[] redstoneMode(Context context, Arguments args) {
        if (args.count() == 0) {
            return new Object[]{this.getRSMode().getDescription()};
        }
        String mode = args.checkString(0);
        return this.setRedstoneMode(mode);
    }

    private Object[] setRedstoneMode(String mode) {
        RedstoneMode redstoneMode = RedstoneMode.getMode((String)mode);
        if (redstoneMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setRSMode(redstoneMode);
        return null;
    }

    public BlockProtectorTileEntity() {
        super((long)BlockProtectorConfiguration.MAXENERGY.get(), (long)BlockProtectorConfiguration.RECEIVEPERTICK.get());
    }

    public long getEnergyDiffPerTick() {
        return this.active ? (long)(-this.getRfPerTick()) : 0L;
    }

    @Nullable
    public String getEnergyUnitName() {
        return "RF";
    }

    public boolean isMachineActive() {
        return this.active;
    }

    public boolean isMachineRunning() {
        return this.active;
    }

    @Nullable
    public String getMachineStatus() {
        return this.active ? "protecting blocks" : "idle";
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (this.protectedBlocks.isEmpty()) {
            this.setActive(false);
            return;
        }
        if (!this.isMachineEnabled()) {
            this.setActive(false);
            return;
        }
        this.setActive(true);
        this.consumeEnergy(this.getRfPerTick());
    }

    private int getRfPerTick() {
        return this.protectedBlocks.size() * BlockProtectorConfiguration.rfPerProtectedBlock.get();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean oldActive = this.active;
        super.onDataPacket(net, packet);
        if (this.getWorld().isRemote && this.active != oldActive) {
            this.getWorld().markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private void setActive(boolean a) {
        this.active = a;
        this.markDirtyClient();
    }

    public boolean attemptHarvestProtection() {
        if (!this.isMachineEnabled()) {
            return false;
        }
        long rf = this.getStoredPower();
        if ((long)BlockProtectorConfiguration.rfForHarvestAttempt.get() > rf) {
            return false;
        }
        this.consumeEnergy(BlockProtectorConfiguration.rfForHarvestAttempt.get());
        return true;
    }

    public int attemptExplosionProtection(float distance, float radius) {
        if (!this.isMachineEnabled()) {
            return -1;
        }
        long rf = this.getStoredPower();
        int rfneeded = (int)((double)BlockProtectorConfiguration.rfForExplosionProtection.get() * (1.0 - (double)distance) * (double)radius / 8.0) + 1;
        if ((long)(rfneeded = (int)((float)rfneeded * (2.0f - this.getInfusedFactor()) / 2.0f)) > rf) {
            return -1;
        }
        if (rfneeded <= 0) {
            rfneeded = 1;
        }
        this.consumeEnergy(rfneeded);
        return rfneeded;
    }

    public Set<BlockPos> getProtectedBlocks() {
        return this.protectedBlocks;
    }

    public BlockPos absoluteToRelative(BlockPos c) {
        return this.absoluteToRelative(c.getX(), c.getY(), c.getZ());
    }

    public BlockPos absoluteToRelative(int x, int y, int z) {
        return new BlockPos(x - this.getPos().getX(), y - this.getPos().getY(), z - this.getPos().getZ());
    }

    public boolean isProtected(BlockPos c) {
        return this.protectedBlocks.contains(c);
    }

    public void removeProtection(BlockPos relative) {
        this.protectedBlocks.remove(relative);
        this.markDirtyClient();
    }

    public void toggleCoordinate(GlobalCoordinate c) {
        if (c.getDimension() != this.getWorld().provider.getDimension()) {
            return;
        }
        BlockPos relative = this.absoluteToRelative(c.getCoordinate());
        if (this.protectedBlocks.contains(relative)) {
            this.protectedBlocks.remove(relative);
        } else {
            this.protectedBlocks.add(relative);
        }
        this.markDirtyClient();
    }

    public void selectBlock(EntityPlayer player, BlockPos pos) {
        int xCoord = this.getPos().getX();
        int yCoord = this.getPos().getY();
        int zCoord = this.getPos().getZ();
        if (Math.abs(pos.getX() - xCoord) > BlockProtectorConfiguration.maxProtectDistance.get() || Math.abs(pos.getY() - yCoord) > BlockProtectorConfiguration.maxProtectDistance.get() || Math.abs(pos.getZ() - zCoord) > BlockProtectorConfiguration.maxProtectDistance.get()) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Block out of range of the block protector!"));
            return;
        }
        GlobalCoordinate gc = new GlobalCoordinate(pos, this.getWorld().provider.getDimension());
        this.toggleCoordinate(gc);
    }

    public int getOrCalculateID() {
        if (this.id == -1) {
            BlockProtectors protectors = BlockProtectors.getProtectors(this.getWorld());
            GlobalCoordinate gc = new GlobalCoordinate(this.getPos(), this.getWorld().provider.getDimension());
            this.id = protectors.getNewId(gc);
            protectors.save();
            this.setId(this.id);
        }
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.markDirtyClient();
    }

    public void updateDestination() {
        BlockProtectors protectors = BlockProtectors.getProtectors(this.getWorld());
        GlobalCoordinate gc = new GlobalCoordinate(this.getPos(), this.getWorld().provider.getDimension());
        if (this.id == -1) {
            this.id = protectors.getNewId(gc);
            this.markDirty();
        } else {
            protectors.assignId(gc, this.id);
        }
        protectors.save();
        this.markDirtyClient();
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        NBTTagList tagList = tagCompound.getTagList("coordinates", 10);
        this.protectedBlocks.clear();
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound tag = (NBTTagCompound)tagList.get(i);
            this.protectedBlocks.add(BlockPosTools.readFromNBT((NBTTagCompound)tag, (String)"c"));
        }
        this.active = tagCompound.getBoolean("active");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.id = tagCompound.hasKey("protectorId") ? tagCompound.getInteger("protectorId") : -1;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        NBTTagList list = new NBTTagList();
        for (BlockPos block : this.protectedBlocks) {
            list.appendTag((NBTBase)BlockPosTools.writeToNBT((BlockPos)block));
        }
        tagCompound.setTag("coordinates", (NBTBase)list);
        tagCompound.setBoolean("active", this.active);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.setInteger("protectorId", this.id);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            this.setRSMode(RedstoneMode.values()[(Integer)params.get(ImageChoiceLabel.PARAM_CHOICE_IDX)]);
            return true;
        }
        return false;
    }
}

