/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.builder.BuilderConfiguration;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.builder.SpaceChamberRepository;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class SpaceChamberControllerTileEntity
extends GenericTileEntity {
    private BlockPos minCorner;
    private BlockPos maxCorner;
    private int channel = -1;

    public BlockPos getMinCorner() {
        return this.minCorner;
    }

    public BlockPos getMaxCorner() {
        return this.maxCorner;
    }

    public void createChamber(EntityPlayer player) {
        int i;
        int x1 = this.getPos().getX();
        int y1 = this.getPos().getY();
        int z1 = this.getPos().getZ();
        int x2 = x1;
        int y2 = y1;
        int z2 = z1;
        for (i = 1; i < BuilderConfiguration.maxSpaceChamberDimension.get(); ++i) {
            if (x2 == x1) {
                if (this.getWorld().getBlockState(new BlockPos(x1 - i, y1, z1)).getBlock() == BuilderSetup.spaceChamberBlock) {
                    x2 = x1 - i;
                } else if (this.getWorld().getBlockState(new BlockPos(x1 + i, y1, z1)).getBlock() == BuilderSetup.spaceChamberBlock) {
                    x2 = x1 + i;
                }
            }
            if (z2 != z1) continue;
            if (this.getWorld().getBlockState(new BlockPos(x1, y1, z1 - i)).getBlock() == BuilderSetup.spaceChamberBlock) {
                z2 = z1 - i;
                continue;
            }
            if (this.getWorld().getBlockState(new BlockPos(x1, y1, z1 + i)).getBlock() != BuilderSetup.spaceChamberBlock) continue;
            z2 = z1 + i;
        }
        if (x1 == x2 || z2 == z1) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        if (this.getWorld().getBlockState(new BlockPos(x2, y1, z2)).getBlock() != BuilderSetup.spaceChamberBlock) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        for (i = 1; i < BuilderConfiguration.maxSpaceChamberDimension.get(); ++i) {
            if (this.getWorld().getBlockState(new BlockPos(x1, y1 - i, z1)).getBlock() == BuilderSetup.spaceChamberBlock) {
                y2 = y1 - i;
                break;
            }
            if (this.getWorld().getBlockState(new BlockPos(x1, y1 + i, z1)).getBlock() != BuilderSetup.spaceChamberBlock) continue;
            y2 = y1 + i;
            break;
        }
        if (y1 == y2) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        if (this.getWorld().getBlockState(new BlockPos(x2, y2, z2)).getBlock() != BuilderSetup.spaceChamberBlock) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        if (this.getWorld().getBlockState(new BlockPos(x1, y2, z2)).getBlock() != BuilderSetup.spaceChamberBlock) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        if (this.getWorld().getBlockState(new BlockPos(x2, y2, z1)).getBlock() != BuilderSetup.spaceChamberBlock) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        this.minCorner = new BlockPos(Math.min(x1, x2) + 1, Math.min(y1, y2) + 1, Math.min(z1, z2) + 1);
        this.maxCorner = new BlockPos(Math.max(x1, x2) - 1, Math.max(y1, y2) - 1, Math.max(z1, z2) - 1);
        if (this.minCorner.getX() > this.maxCorner.getX() || this.minCorner.getY() > this.maxCorner.getY() || this.minCorner.getZ() > this.maxCorner.getZ()) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Chamber is too small!"));
            this.minCorner = null;
            this.maxCorner = null;
            return;
        }
        Logging.message((EntityPlayer)player, (String)(TextFormatting.WHITE + "Chamber succesfully created!"));
        SpaceChamberRepository chamberRepository = SpaceChamberRepository.getChannels(this.getWorld());
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = chamberRepository.getOrCreateChannel(this.channel);
        chamberChannel.setDimension(this.getWorld().provider.getDimension());
        chamberChannel.setMinCorner(this.minCorner);
        chamberChannel.setMaxCorner(this.maxCorner);
        chamberRepository.save();
        this.markDirtyClient();
    }

    public int getChannel() {
        return this.channel;
    }

    public int getChamberSize() {
        if (this.channel == -1) {
            return -1;
        }
        if (this.minCorner == null) {
            return -1;
        }
        return BlockPosTools.area((BlockPos)this.minCorner, (BlockPos)this.maxCorner);
    }

    public void setChannel(int channel) {
        this.channel = channel;
        this.markDirtyClient();
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.minCorner = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"minCorner");
        this.maxCorner = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"maxCorner");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.channel = tagCompound.getInteger("channel");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"minCorner", (BlockPos)this.minCorner);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"maxCorner", (BlockPos)this.maxCorner);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.setInteger("channel", this.channel);
    }
}

