/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.crafter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.NullSidedInvWrapper;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.blocks.crafter.CrafterConfiguration;
import mcjty.rftools.blocks.crafter.CrafterContainer;
import mcjty.rftools.compat.jei.JEIRecipeAcceptor;
import mcjty.rftools.craftinggrid.CraftingRecipe;
import mcjty.rftools.items.storage.StorageFilterCache;
import mcjty.rftools.items.storage.StorageFilterItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class CrafterBaseTE
extends GenericEnergyReceiverTileEntity
implements ITickable,
DefaultSidedInventory,
JEIRecipeAcceptor {
    public static final int SPEED_SLOW = 0;
    public static final int SPEED_FAST = 1;
    public static final String CMD_MODE = "crafter.setMode";
    public static final String CMD_RSMODE = "crafter.setRsMode";
    public static final String CMD_REMEMBER = "crafter.remember";
    public static final String CMD_FORGET = "crafter.forget";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CrafterContainer.CONTAINER_FACTORY, 41);
    private ItemStackList ghostSlots = ItemStackList.create((int)30);
    private final CraftingRecipe[] recipes;
    private StorageFilterCache filterCache = null;
    private int speedMode = 0;
    boolean noRecipesWork = false;
    private InventoryCrafting workInventory = new InventoryCrafting(new Container(){

        public boolean canInteractWith(EntityPlayer var1) {
            return false;
        }
    }, 3, 3);

    public CrafterBaseTE(int supportedRecipes) {
        super((long)CrafterConfiguration.MAXENERGY.get(), (long)CrafterConfiguration.RECEIVEPERTICK.get());
        this.recipes = new CraftingRecipe[supportedRecipes];
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i] = new CraftingRecipe();
        }
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public ItemStackList getGhostSlots() {
        return this.ghostSlots;
    }

    @Override
    public void setGridContents(List<ItemStack> stacks) {
        this.setInventorySlotContents(9, stacks.get(0));
        for (int i = 1; i < stacks.size(); ++i) {
            this.setInventorySlotContents(0 + i - 1, stacks.get(i));
        }
    }

    public void selectRecipe(int index) {
        CraftingRecipe recipe = this.recipes[index];
        this.setInventorySlotContents(9, recipe.getResult());
        InventoryCrafting inv = recipe.getInventory();
        int size = inv.getSizeInventory();
        for (int i = 0; i < size; ++i) {
            this.setInventorySlotContents(0 + i, inv.getStackInSlot(i));
        }
    }

    public int getSupportedRecipes() {
        return this.recipes.length;
    }

    public int getSpeedMode() {
        return this.speedMode;
    }

    public void setSpeedMode(int speedMode) {
        this.speedMode = speedMode;
        this.markDirtyClient();
    }

    public CraftingRecipe getRecipe(int index) {
        return this.recipes[index];
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        this.noRecipesWork = false;
        if (index == 40) {
            this.filterCache = null;
        }
        this.inventoryHelper.setInventorySlotContents(this.getInventoryStackLimit(), index, stack);
    }

    public ItemStack decrStackSize(int index, int count) {
        this.noRecipesWork = false;
        if (index == 40) {
            this.filterCache = null;
        }
        return this.getInventoryHelper().decrStackSize(index, count);
    }

    public ItemStack removeStackFromSlot(int index) {
        this.noRecipesWork = false;
        if (index == 40) {
            this.filterCache = null;
        }
        return this.inventoryHelper.removeStackFromSlot(index);
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    private void getFilterCache() {
        if (this.filterCache == null) {
            this.filterCache = StorageFilterItem.getCache(this.inventoryHelper.getStackInSlot(40));
        }
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        ItemStack ghostSlot;
        if (index >= 0 && index <= 9) {
            return false;
        }
        if (index >= 10 && index < 36) {
            ItemStack ghostSlot2 = (ItemStack)this.ghostSlots.get(index - 10);
            if (!ghostSlot2.isEmpty() && !ghostSlot2.isItemEqual(stack)) {
                return false;
            }
            if (this.inventoryHelper.containsItem(40)) {
                this.getFilterCache();
                if (this.filterCache != null) {
                    return this.filterCache.match(stack);
                }
            }
        } else if (index >= 36 && index < 40 && !(ghostSlot = (ItemStack)this.ghostSlots.get(index - 36 + 26)).isEmpty() && !ghostSlot.isItemEqual(stack)) {
            return false;
        }
        return true;
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return CrafterContainer.CONTAINER_FACTORY.getAccessibleSlots();
    }

    public boolean canInsertItem(int index, ItemStack stack, EnumFacing direction) {
        if (!this.isItemValidForSlot(index, stack)) {
            return false;
        }
        return CrafterContainer.CONTAINER_FACTORY.isInputSlot(index);
    }

    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        return CrafterContainer.CONTAINER_FACTORY.isOutputSlot(index);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.readGhostBufferFromNBT(tagCompound);
        this.readRecipesFromNBT(tagCompound);
        this.speedMode = tagCompound.getByte("speedMode");
    }

    private void readGhostBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.getTagList("GItems", 10);
        for (int i = 0; i < bufferTagList.tagCount(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.getCompoundTagAt(i);
            this.ghostSlots.set(i, (Object)new ItemStack(nbtTagCompound));
        }
    }

    private void readRecipesFromNBT(NBTTagCompound tagCompound) {
        NBTTagList recipeTagList = tagCompound.getTagList("Recipes", 10);
        for (int i = 0; i < recipeTagList.tagCount(); ++i) {
            NBTTagCompound nbtTagCompound = recipeTagList.getCompoundTagAt(i);
            this.recipes[i].readFromNBT(nbtTagCompound);
        }
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        this.writeGhostBufferToNBT(tagCompound);
        this.writeRecipesToNBT(tagCompound);
        tagCompound.setByte("speedMode", (byte)this.speedMode);
    }

    private void writeGhostBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (ItemStack stack : this.ghostSlots) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (!stack.isEmpty()) {
                stack.writeToNBT(nbtTagCompound);
            }
            bufferTagList.appendTag((NBTBase)nbtTagCompound);
        }
        tagCompound.setTag("GItems", (NBTBase)bufferTagList);
    }

    private void writeRecipesToNBT(NBTTagCompound tagCompound) {
        NBTTagList recipeTagList = new NBTTagList();
        for (CraftingRecipe recipe : this.recipes) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            recipe.writeToNBT(nbtTagCompound);
            recipeTagList.appendTag((NBTBase)nbtTagCompound);
        }
        tagCompound.setTag("Recipes", (NBTBase)recipeTagList);
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            this.checkStateServer();
        }
    }

    protected void checkStateServer() {
        int i;
        int steps;
        if (!this.isMachineEnabled() || this.noRecipesWork) {
            return;
        }
        int rf = (int)((float)CrafterConfiguration.rfPerOperation.get() * (2.0f - this.getInfusedFactor()) / 2.0f);
        int n = steps = this.speedMode == 1 ? CrafterConfiguration.speedOperations.get() : 1;
        if (rf > 0) {
            steps = (int)Math.min((long)steps, this.getStoredPower() / (long)rf);
        }
        for (i = 0; i < steps; ++i) {
            if (this.craftOneCycle()) continue;
            this.noRecipesWork = true;
            break;
        }
        if ((rf *= i) > 0) {
            this.consumeEnergy(rf);
        }
    }

    private boolean craftOneCycle() {
        boolean craftedAtLeastOneThing = false;
        for (CraftingRecipe craftingRecipe : this.recipes) {
            if (!this.craftOneItemNew(craftingRecipe)) continue;
            craftedAtLeastOneThing = true;
        }
        return craftedAtLeastOneThing;
    }

    private boolean craftOneItemNew(CraftingRecipe craftingRecipe) {
        IRecipe recipe = craftingRecipe.getCachedRecipe(this.getWorld());
        if (recipe == null) {
            return false;
        }
        HashMap<Integer, ItemStack> undo = new HashMap<Integer, ItemStack>();
        if (!this.testAndConsumeCraftingItems(craftingRecipe, undo, true)) {
            this.undo(undo);
            if (!this.testAndConsumeCraftingItems(craftingRecipe, undo, false)) {
                this.undo(undo);
                return false;
            }
        }
        ItemStack result = ItemStack.EMPTY;
        try {
            result = recipe.getCraftingResult(this.workInventory);
        }
        catch (RuntimeException e) {
            Logging.logError((String)"Problem with recipe!", (Throwable)e);
        }
        CraftingRecipe.CraftMode mode = craftingRecipe.getCraftMode();
        if (!result.isEmpty() && this.placeResult(mode, result, undo)) {
            NonNullList remaining = recipe.getRemainingItems(this.workInventory);
            if (remaining != null) {
                CraftingRecipe.CraftMode remainingMode = mode == CraftingRecipe.CraftMode.EXTC ? CraftingRecipe.CraftMode.INT : mode;
                for (ItemStack s : remaining) {
                    if (s.isEmpty() || this.placeResult(remainingMode, s, undo)) continue;
                    this.undo(undo);
                    return false;
                }
            }
            return true;
        }
        this.undo(undo);
        return false;
    }

    private static boolean match(ItemStack target, ItemStack input, boolean strictDamage) {
        if (strictDamage) {
            return OreDictionary.itemMatches((ItemStack)target, (ItemStack)input, (boolean)false);
        }
        if (input.isEmpty() && !target.isEmpty() || !input.isEmpty() && target.isEmpty()) {
            return false;
        }
        return target.isItemEqual(input);
    }

    private boolean testAndConsumeCraftingItems(CraftingRecipe craftingRecipe, Map<Integer, ItemStack> undo, boolean strictDamage) {
        int keep = craftingRecipe.isKeepOne() ? 1 : 0;
        InventoryCrafting inventory = craftingRecipe.getInventory();
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!stack.isEmpty()) {
                int count = stack.getCount();
                for (int j = 0; j < 26; ++j) {
                    int slotIdx = 10 + j;
                    ItemStack input = this.inventoryHelper.getStackInSlot(slotIdx);
                    if (!input.isEmpty() && input.getCount() > keep && CrafterBaseTE.match(stack, input, strictDamage)) {
                        this.workInventory.setInventorySlotContents(i, input.copy());
                        int ss = count;
                        if (input.getCount() - ss < keep) {
                            ss = input.getCount() - keep;
                        }
                        count -= ss;
                        if (!undo.containsKey(slotIdx)) {
                            undo.put(slotIdx, input.copy());
                        }
                        input.splitStack(ss);
                        if (input.isEmpty()) {
                            this.inventoryHelper.setStackInSlot(slotIdx, ItemStack.EMPTY);
                        }
                    }
                    if (count == 0) break;
                }
                if (count <= 0) continue;
                return false;
            }
            this.workInventory.setInventorySlotContents(i, ItemStack.EMPTY);
        }
        IRecipe recipe = craftingRecipe.getCachedRecipe(this.getWorld());
        return recipe.matches(this.workInventory, this.getWorld());
    }

    private void undo(Map<Integer, ItemStack> undo) {
        for (Map.Entry<Integer, ItemStack> entry : undo.entrySet()) {
            this.inventoryHelper.setStackInSlot(entry.getKey().intValue(), entry.getValue());
        }
        undo.clear();
    }

    private boolean placeResult(CraftingRecipe.CraftMode mode, ItemStack result, Map<Integer, ItemStack> undo) {
        int stop;
        int start;
        if (mode == CraftingRecipe.CraftMode.INT) {
            start = 10;
            stop = 36;
        } else {
            start = 36;
            stop = 40;
        }
        return InventoryHelper.mergeItemStack((IInventory)this, (boolean)true, (ItemStack)result, (int)start, (int)stop, undo) == 0;
    }

    private void rememberItems() {
        for (int i = 0; i < this.ghostSlots.size(); ++i) {
            int slotIdx = i < 26 ? i + 10 : i + 36 - 26;
            if (!this.inventoryHelper.containsItem(slotIdx)) continue;
            ItemStack stack = this.inventoryHelper.getStackInSlot(slotIdx).copy();
            stack.setCount(1);
            this.ghostSlots.set(i, (Object)stack);
        }
        this.noRecipesWork = false;
        this.markDirtyClient();
    }

    private void forgetItems() {
        for (int i = 0; i < this.ghostSlots.size(); ++i) {
            this.ghostSlots.set(i, (Object)ItemStack.EMPTY);
        }
        this.noRecipesWork = false;
        this.markDirtyClient();
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            this.setRSMode(RedstoneMode.values()[(Integer)params.get(ImageChoiceLabel.PARAM_CHOICE_IDX)]);
            return true;
        }
        if (CMD_MODE.equals(command)) {
            this.setSpeedMode((Integer)params.get(ImageChoiceLabel.PARAM_CHOICE_IDX));
            return true;
        }
        if (CMD_REMEMBER.equals(command)) {
            this.rememberItems();
            return true;
        }
        if (CMD_FORGET.equals(command)) {
            this.forgetItems();
            return true;
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.invHandlerNull == null) {
                this.invHandlerNull = new NullSidedInvWrapper((ISidedInventory)this);
            }
            return (T)this.invHandlerNull;
        }
        return (T)super.getCapability(capability, facing);
    }
}

