/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.crafter;

import java.util.List;
import java.util.function.BiFunction;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.api.Infusable;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.varia.ModuleSupport;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.crafter.CrafterBaseTE;
import mcjty.rftools.blocks.crafter.CrafterBlockTileEntity1;
import mcjty.rftools.blocks.crafter.CrafterBlockTileEntity2;
import mcjty.rftools.blocks.crafter.CrafterContainer;
import mcjty.rftools.blocks.crafter.GuiCrafter;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class CrafterBlock
extends GenericRFToolsBlock<CrafterBaseTE, CrafterContainer>
implements Infusable,
INBTPreservingIngredient {
    public CrafterBlock(String blockName, Class<? extends CrafterBaseTE> tileEntityClass) {
        super(Material.IRON, tileEntityClass, CrafterContainer::new, blockName, true);
    }

    @SideOnly(value=Side.CLIENT)
    public BiFunction<CrafterBaseTE, CrafterContainer, GenericGuiContainer<? super CrafterBaseTE>> getGuiFactory() {
        return GuiCrafter::new;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.getTagCompound();
        if (tagCompound != null) {
            int i;
            NBTTagList bufferTagList = tagCompound.getTagList("Items", 10);
            NBTTagList recipeTagList = tagCompound.getTagList("Recipes", 10);
            int rc = 0;
            for (i = 0; i < bufferTagList.tagCount(); ++i) {
                ItemStack stack;
                NBTTagCompound itemTag = bufferTagList.getCompoundTagAt(i);
                if (itemTag == null || (stack = new ItemStack(itemTag)).isEmpty()) continue;
                ++rc;
            }
            list.add(TextFormatting.GREEN + "Contents: " + rc + " stacks");
            rc = 0;
            for (i = 0; i < recipeTagList.tagCount(); ++i) {
                ItemStack stack;
                NBTTagCompound tagRecipe = recipeTagList.getCompoundTagAt(i);
                NBTTagCompound resultCompound = tagRecipe.getCompoundTag("Result");
                if (resultCompound == null || (stack = new ItemStack(resultCompound)).isEmpty()) continue;
                ++rc;
            }
            list.add(TextFormatting.GREEN + "Recipes: " + rc + " recipes");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            int amount = this.tileEntityClass.equals(CrafterBlockTileEntity1.class) ? 2 : (this.tileEntityClass.equals(CrafterBlockTileEntity2.class) ? 4 : 8);
            list.add(TextFormatting.WHITE + "This machine can handle up to " + amount + " recipes");
            list.add(TextFormatting.WHITE + "at once and allows recipes to use the crafting results");
            list.add(TextFormatting.WHITE + "of previous steps.");
            list.add(TextFormatting.YELLOW + "Infusing bonus: reduced power consumption.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    protected IModuleSupport getModuleSupport() {
        return new ModuleSupport(40){

            public boolean isModule(ItemStack itemStack) {
                return itemStack.getItem() == ModularStorageSetup.storageFilterItem;
            }
        };
    }

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        CrafterBaseTE crafterBaseTE = (CrafterBaseTE)tileEntity;
        crafterBaseTE.getInventoryHelper().setStackInSlot(9, ItemStack.EMPTY);
        for (int i = 0; i < 9; ++i) {
            crafterBaseTE.getInventoryHelper().setStackInSlot(i, ItemStack.EMPTY);
        }
        return super.createServerContainer(entityPlayer, tileEntity);
    }

    public boolean needsRedstoneCheck() {
        return true;
    }

    public int getGuiID() {
        return GuiProxy.GUI_CRAFTER;
    }
}

