/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.crafter;

import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericEnergyStorageTileEntity;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.crafter.CrafterBaseTE;
import mcjty.rftools.blocks.crafter.PacketCrafter;
import mcjty.rftools.craftinggrid.CraftingRecipe;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCrafter
extends GenericGuiContainer<CrafterBaseTE> {
    private EnergyBar energyBar;
    private WidgetList recipeList;
    private ChoiceLabel keepItem;
    private ChoiceLabel internalRecipe;
    private Button applyButton;
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private static int lastSelected = -1;

    public GuiCrafter(CrafterBaseTE te, GenericContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)te, (Container)container, GuiProxy.GUI_MANUAL_MAIN, "crafter");
        GenericEnergyStorageTileEntity.setCurrentRF((long)te.getStoredPower());
    }

    public void initGui() {
        this.window = new Window((GuiScreen)this, this.tileEntity, RFToolsMessages.INSTANCE, new ResourceLocation("rftools", "gui/crafter.gui"));
        super.initGui();
        this.initializeFields();
        if (lastSelected != -1 && lastSelected < ((CrafterBaseTE)this.tileEntity).getSizeInventory()) {
            this.recipeList.setSelected(lastSelected);
        }
        this.window.event("apply", (source, params) -> this.applyRecipe());
        this.window.event("select", (source, params) -> this.selectRecipe());
        ((CrafterBaseTE)this.tileEntity).requestRfFromServer("rftools");
    }

    private void initializeFields() {
        this.recipeList = (WidgetList)this.window.findChild("recipes");
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        this.applyButton = (Button)this.window.findChild("apply");
        this.keepItem = (ChoiceLabel)this.window.findChild("keep");
        this.internalRecipe = (ChoiceLabel)this.window.findChild("internal");
        this.energyBar.setMaxValue(((CrafterBaseTE)this.tileEntity).getCapacity());
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        ((ImageChoiceLabel)this.window.findChild("redstone")).setCurrentChoice(((CrafterBaseTE)this.tileEntity).getRSMode().ordinal());
        ((ImageChoiceLabel)this.window.findChild("speed")).setCurrentChoice(((CrafterBaseTE)this.tileEntity).getSpeedMode());
        this.populateList();
    }

    private void populateList() {
        this.recipeList.removeChildren();
        for (int i = 0; i < ((CrafterBaseTE)this.tileEntity).getSupportedRecipes(); ++i) {
            CraftingRecipe recipe = ((CrafterBaseTE)this.tileEntity).getRecipe(i);
            this.addRecipeLine(recipe.getResult());
        }
    }

    private void addRecipeLine(ItemStack craftingResult) {
        String readableName = BlockTools.getReadableName((ItemStack)craftingResult);
        int color = StyleConfig.colorTextInListNormal;
        if (craftingResult.isEmpty()) {
            readableName = "<no recipe>";
            color = -11513776;
        }
        Panel panel = (Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)new BlockRender(this.mc, (Gui)this).setRenderItem((Object)craftingResult).setTooltips(new String[]{"Double click to edit this recipe"}))).addChild((Widget)((Label)((Label)((Label)((Label)new Label(this.mc, (Gui)this).setColor(color)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setDynamic(true)).setText(readableName)).setTooltips(new String[]{"Double click to edit this recipe"}));
        this.recipeList.addChild((Widget)panel);
    }

    private void selectRecipe() {
        int selected;
        lastSelected = selected = this.recipeList.getSelected();
        if (selected == -1) {
            for (int i = 0; i < 10; ++i) {
                this.inventorySlots.getSlot(i).putStack(ItemStack.EMPTY);
            }
            this.keepItem.setChoice("All");
            this.internalRecipe.setChoice("Ext");
            return;
        }
        CraftingRecipe craftingRecipe = ((CrafterBaseTE)this.tileEntity).getRecipe(selected);
        InventoryCrafting inv = craftingRecipe.getInventory();
        for (int i = 0; i < 9; ++i) {
            this.inventorySlots.getSlot(i).putStack(inv.getStackInSlot(i));
        }
        this.inventorySlots.getSlot(9).putStack(craftingRecipe.getResult());
        this.keepItem.setChoice(craftingRecipe.isKeepOne() ? "Keep" : "All");
        this.internalRecipe.setChoice(craftingRecipe.getCraftMode().getDescription());
    }

    private void testRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean canInteractWith(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.setInventorySlotContents(i, this.inventorySlots.getSlot(i).getStack());
        }
        IRecipe recipe = CraftingRecipe.findRecipe((World)this.mc.world, inv);
        ItemStack newResult = recipe == null ? ItemStack.EMPTY : recipe.getCraftingResult(inv);
        this.inventorySlots.getSlot(9).putStack(newResult);
    }

    private void applyRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        if (selected >= ((CrafterBaseTE)this.tileEntity).getSupportedRecipes()) {
            this.recipeList.setSelected(-1);
            return;
        }
        CraftingRecipe craftingRecipe = ((CrafterBaseTE)this.tileEntity).getRecipe(selected);
        InventoryCrafting inv = craftingRecipe.getInventory();
        for (int i = 0; i < 9; ++i) {
            ItemStack newStack;
            ItemStack oldStack = inv.getStackInSlot(i);
            if (this.itemStacksEqual(oldStack, newStack = this.inventorySlots.getSlot(i).getStack())) continue;
            inv.setInventorySlotContents(i, newStack);
        }
        IRecipe recipe = CraftingRecipe.findRecipe((World)this.mc.world, inv);
        ItemStack newResult = recipe == null ? ItemStack.EMPTY : recipe.getCraftingResult(inv);
        ItemStack oldResult = this.inventorySlots.getSlot(9).getStack();
        if (!this.itemStacksEqual(oldResult, newResult)) {
            this.inventorySlots.getSlot(9).putStack(newResult);
        }
        craftingRecipe.setResult(newResult);
        this.updateRecipe();
        this.populateList();
    }

    private void updateRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        CraftingRecipe craftingRecipe = ((CrafterBaseTE)this.tileEntity).getRecipe(selected);
        boolean keepOne = "Keep".equals(this.keepItem.getCurrentChoice());
        CraftingRecipe.CraftMode mode = "Int".equals(this.internalRecipe.getCurrentChoice()) ? CraftingRecipe.CraftMode.INT : ("Ext".equals(this.internalRecipe.getCurrentChoice()) ? CraftingRecipe.CraftMode.EXT : CraftingRecipe.CraftMode.EXTC);
        craftingRecipe.setKeepOne(keepOne);
        craftingRecipe.setCraftMode(mode);
        this.sendChangeToServer(selected, craftingRecipe.getInventory(), craftingRecipe.getResult(), keepOne, mode);
    }

    private boolean itemStacksEqual(ItemStack matches, ItemStack oldStack) {
        if (matches.isEmpty()) {
            return oldStack.isEmpty();
        }
        return !oldStack.isEmpty() && matches.isItemEqual(oldStack);
    }

    private void sendChangeToServer(int index, InventoryCrafting inv, ItemStack result, boolean keepOne, CraftingRecipe.CraftMode mode) {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketCrafter(((CrafterBaseTE)this.tileEntity).getPos(), index, inv, result, keepOne, mode));
    }

    public void drawScreen(int par1, int par2, float par3) {
        this.updateButtons();
        super.drawScreen(par1, par2, par3);
        this.testRecipe();
    }

    private void updateButtons() {
        boolean selected = this.recipeList.getSelected() != -1;
        this.keepItem.setEnabled(selected);
        this.internalRecipe.setEnabled(selected);
        this.applyButton.setEnabled(selected);
    }

    protected void drawGuiContainerBackgroundLayer(float v, int x, int y) {
        this.drawWindow();
        long currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((CrafterBaseTE)this.tileEntity).requestRfFromServer("rftools");
        this.drawGhostSlots();
    }

    private void drawGhostSlots() {
        net.minecraft.client.renderer.RenderHelper.enableGUIStandardItemLighting();
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GlStateManager.color((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.enableRescaleNormal();
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)240.0f, (float)240.0f);
        ItemStackList ghostSlots = ((CrafterBaseTE)this.tileEntity).getGhostSlots();
        this.zLevel = 100.0f;
        this.itemRender.zLevel = 100.0f;
        GlStateManager.enableDepth();
        GlStateManager.disableBlend();
        GlStateManager.enableLighting();
        for (int i = 0; i < ghostSlots.size(); ++i) {
            int slotIdx;
            Slot slot;
            ItemStack stack = (ItemStack)ghostSlots.get(i);
            if (stack.isEmpty() || (slot = this.inventorySlots.getSlot(slotIdx = i < 26 ? i + 10 : i + 36 - 26)).getHasStack()) continue;
            this.itemRender.renderItemAndEffectIntoGUI(stack, slot.xPos, slot.yPos);
            GlStateManager.disableLighting();
            GlStateManager.enableBlend();
            GlStateManager.disableDepth();
            this.mc.getTextureManager().bindTexture(iconGuiElements);
            RenderHelper.drawTexturedModalRect((int)slot.xPos, (int)slot.yPos, (int)224, (int)48, (int)16, (int)16);
            GlStateManager.enableDepth();
            GlStateManager.disableBlend();
            GlStateManager.enableLighting();
        }
        this.itemRender.zLevel = 0.0f;
        this.zLevel = 0.0f;
        GlStateManager.popMatrix();
        net.minecraft.client.renderer.RenderHelper.disableStandardItemLighting();
    }
}

