/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.elevator;

import com.mojang.authlib.GameProfile;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Broadcaster;
import mcjty.rftools.blocks.builder.BuilderTileEntity;
import mcjty.rftools.blocks.elevator.ElevatorConfiguration;
import mcjty.rftools.blocks.elevator.ElevatorSetup;
import mcjty.rftools.blocks.elevator.ElevatorSounds;
import mcjty.rftools.blocks.shield.RelCoordinate;
import mcjty.rftools.playerprops.BuffProperties;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElevatorTileEntity
extends GenericEnergyReceiverTileEntity
implements ITickable {
    public static String CMD_SETNAME = "elevator.setName";
    private boolean prevIn = false;
    private double movingY = -1.0;
    private int startY;
    private int stopY;
    private String name = "";
    private Set<BlockPos> positions = new HashSet<BlockPos>();
    private Bounds bounds;
    private IBlockState movingState;
    private BlockPos cachedControllerPos;
    private int cachedLevels;
    private int cachedCurrent = -1;
    private boolean redstoneOut = false;
    private Set<Entity> entitiesOnPlatform = new HashSet<Entity>();
    private boolean entitiesOnPlatformComplete = false;
    private FakePlayer harvester = null;

    public ElevatorTileEntity() {
        super((long)ElevatorConfiguration.MAXENERGY.get(), (long)ElevatorConfiguration.RFPERTICK.get());
    }

    private FakePlayer getHarvester() {
        if (this.harvester == null) {
            this.harvester = FakePlayerFactory.get((WorldServer)((WorldServer)this.world), (GameProfile)new GameProfile(UUID.nameUUIDFromBytes("rftools_elevator".getBytes()), "rftools_elevator"));
        }
        this.harvester.setWorld(this.world);
        this.harvester.setPosition((double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ());
        return this.harvester;
    }

    public void clearCaches(EnumFacing side) {
        for (int y = 0; y < this.getWorld().getHeight(); ++y) {
            EnumFacing side2;
            TileEntity te;
            BlockPos pos2 = ElevatorTileEntity.getPosAtY(this.getPos(), y);
            if (this.getWorld().getBlockState(pos2).getBlock() != ElevatorSetup.elevatorBlock || !((te = this.getWorld().getTileEntity(pos2)) instanceof ElevatorTileEntity) || (side2 = (EnumFacing)this.getWorld().getBlockState(pos2).getValue((IProperty)BaseBlock.FACING_HORIZ)) != side) continue;
            ElevatorTileEntity tileEntity = (ElevatorTileEntity)te;
            tileEntity.cachedControllerPos = null;
            tileEntity.cachedLevels = 0;
            tileEntity.cachedCurrent = -1;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.markDirtyClient();
    }

    private void setRedstoneState() {
        this.markDirty();
        this.getWorld().notifyNeighborsOfStateChange(this.pos, this.getBlockType(), false);
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            boolean newout = this.isPlatformHere();
            if (newout != this.redstoneOut) {
                this.redstoneOut = newout;
                this.setRedstoneState();
            }
            if (this.isMoving()) {
                this.markDirty();
                double d = this.calculateSpeed();
                boolean stopped = this.handlePlatformMovement(d);
                if (stopped) {
                    this.stopMoving();
                    this.moveEntities(0.0, true);
                    this.clearMovement();
                } else {
                    this.moveEntities(d, false);
                }
                return;
            }
            if (this.powerLevel > 0 == this.prevIn) {
                return;
            }
            this.prevIn = this.powerLevel > 0;
            this.markDirty();
            if (this.powerLevel > 0) {
                this.movePlatformHere();
            }
        } else {
            if (this.isMoving()) {
                this.handleClientMovement();
            }
            this.handleSound();
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this.getWorld().isRemote) {
            this.stopSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopSounds() {
        ElevatorSounds.stopSound(this.getWorld(), this.getPos());
    }

    @SideOnly(value=Side.CLIENT)
    protected void handleSound() {
        boolean shutdown;
        if (ElevatorConfiguration.baseElevatorVolume.get() < (double)0.01f) {
            return;
        }
        if (!this.isMoving()) {
            this.stopSounds();
            return;
        }
        boolean startup = Math.abs((double)this.startY - this.movingY) < ElevatorConfiguration.maxSpeedDistanceStart.get();
        boolean bl = shutdown = Math.abs(this.movingY - (double)this.stopY) < ElevatorConfiguration.maxSpeedDistanceEnd.get() * 2.0;
        if (shutdown) {
            if (!ElevatorSounds.isStopPlaying(this.getWorld(), this.pos)) {
                ElevatorSounds.playStop(this.getWorld(), this.pos);
            }
        } else if (startup) {
            if (!ElevatorSounds.isStartupPlaying(this.getWorld(), this.pos)) {
                ElevatorSounds.playStartup(this.getWorld(), this.pos);
            }
        } else if (!ElevatorSounds.isLoopPlaying(this.getWorld(), this.pos)) {
            ElevatorSounds.playLoop(this.getWorld(), this.pos);
        }
        ElevatorSounds.moveSound(this.getWorld(), this.pos, (float)this.movingY);
    }

    @SideOnly(value=Side.CLIENT)
    private void handleClientMovement() {
        double d = this.calculateSpeed();
        this.handlePlatformMovement(d);
        if (this.bounds != null) {
            EntityPlayerSP player = Minecraft.getMinecraft().player;
            AxisAlignedBB aabb = this.getAABBAboveElevator(d);
            boolean on = player.getEntityBoundingBox().intersects(aabb);
            if (on) {
                player.setPosition(player.posX, this.movingY + 1.0, player.posZ);
            }
        }
    }

    private double calculateSpeed() {
        double speedDiff = ElevatorConfiguration.maximumSpeed.get() - ElevatorConfiguration.minimumSpeed.get();
        double speedFromStart = ElevatorConfiguration.minimumSpeed.get() + speedDiff * Math.abs((this.movingY - (double)this.startY) / ElevatorConfiguration.maxSpeedDistanceStart.get());
        double speedFromStop = ElevatorConfiguration.minimumSpeed.get() + speedDiff * Math.abs((this.movingY - (double)this.stopY) / ElevatorConfiguration.maxSpeedDistanceEnd.get());
        double d = Math.min(speedFromStart, speedFromStop);
        if (this.stopY < this.startY) {
            d = -d;
        }
        return d;
    }

    private boolean handlePlatformMovement(double d) {
        if (this.stopY > this.startY) {
            if (this.movingY >= (double)this.stopY) {
                return true;
            }
            this.movingY += d;
            if (this.movingY >= (double)this.stopY) {
                this.movingY = this.stopY;
            }
        } else {
            if (this.movingY <= (double)this.stopY) {
                return true;
            }
            this.movingY += d;
            if (this.movingY <= (double)this.stopY) {
                this.movingY = this.stopY;
            }
        }
        return false;
    }

    private void moveEntities(double speed, boolean stop) {
        if (this.bounds == null) {
            return;
        }
        double offset = speed > 0.0 ? speed * 2.0 : speed;
        Set<Entity> oldEntities = this.entitiesOnPlatform;
        this.entitiesOnPlatform = new HashSet<Entity>();
        List entities = this.getWorld().getEntitiesWithinAABB(Entity.class, this.getAABBAboveElevator(speed));
        for (Entity entity : entities) {
            entity.fallDistance = 0.0f;
            this.entitiesOnPlatform.add(entity);
            this.moveEntityOnPlatform(stop, offset, entity);
            entity.onGround = true;
            entity.fallDistance = 0.0f;
        }
        for (Entity entity : oldEntities) {
            if (this.entitiesOnPlatform.contains(entity)) continue;
            if ((entity instanceof EntityPlayer || this.entitiesOnPlatformComplete) && entity.getEntityBoundingBox().intersects(this.getAABBBigMargin())) {
                entity.fallDistance = 0.0f;
                this.entitiesOnPlatform.add(entity);
                this.moveEntityOnPlatform(stop, offset, entity);
                entity.onGround = true;
                entity.fallDistance = 0.0f;
            }
            if (!(entity instanceof EntityPlayer)) continue;
            BuffProperties.disableElevatorMode((EntityPlayer)entity);
        }
        this.entitiesOnPlatformComplete = true;
    }

    private void moveEntityOnPlatform(boolean stop, double offset, Entity entity) {
        if (entity instanceof EntityPlayer) {
            double dy = 1.0;
            EntityPlayer player = (EntityPlayer)entity;
            if (stop) {
                BuffProperties.disableElevatorMode(player);
                entity.posY = this.movingY + dy;
                entity.setPositionAndUpdate(entity.posX, this.movingY + dy, entity.posZ);
            } else {
                BuffProperties.enableElevatorMode(player);
                entity.setPosition(entity.posX, this.movingY + dy, entity.posZ);
            }
        } else {
            double dy = 1.2 + offset;
            entity.posY = this.movingY + dy;
            entity.setPositionAndUpdate(entity.posX, this.movingY + dy, entity.posZ);
        }
    }

    public BlockPos findBottomElevator() {
        if (this.cachedControllerPos != null) {
            return this.cachedControllerPos;
        }
        IBlockState blockState = this.getWorld().getBlockState(this.getPos());
        if (blockState.getBlock() != ElevatorSetup.elevatorBlock) {
            return null;
        }
        EnumFacing side = (EnumFacing)blockState.getValue((IProperty)BaseBlock.FACING_HORIZ);
        for (int y = 0; y < this.getWorld().getHeight(); ++y) {
            EnumFacing otherSide;
            BlockPos elevatorPos = ElevatorTileEntity.getPosAtY(this.getPos(), y);
            IBlockState otherState = this.getWorld().getBlockState(elevatorPos);
            if (otherState.getBlock() != ElevatorSetup.elevatorBlock || (otherSide = (EnumFacing)otherState.getValue((IProperty)BaseBlock.FACING_HORIZ)) != side) continue;
            this.cachedControllerPos = elevatorPos;
            return elevatorPos;
        }
        return null;
    }

    private BlockPos findElevatorWithPlatform() {
        EnumFacing side = (EnumFacing)this.getWorld().getBlockState(this.getPos()).getValue((IProperty)BaseBlock.FACING_HORIZ);
        for (int y = 0; y < this.getWorld().getHeight(); ++y) {
            BlockPos frontPos;
            EnumFacing otherSide;
            BlockPos elevatorPos = ElevatorTileEntity.getPosAtY(this.getPos(), y);
            IBlockState otherState = this.getWorld().getBlockState(elevatorPos);
            if (otherState.getBlock() != ElevatorSetup.elevatorBlock || (otherSide = (EnumFacing)otherState.getValue((IProperty)BaseBlock.FACING_HORIZ)) != side || !this.isValidPlatformBlock(frontPos = elevatorPos.offset(side))) continue;
            return elevatorPos;
        }
        return null;
    }

    private boolean isValidPlatformBlock(BlockPos frontPos) {
        World world = this.getWorld();
        IBlockState state = world.getBlockState(frontPos);
        Block block = state.getBlock();
        return !block.isAir(state, (IBlockAccess)world, frontPos) && !block.hasTileEntity(state);
    }

    public Set<BlockPos> getPositions() {
        return this.positions;
    }

    public IBlockState getMovingState() {
        return this.movingState;
    }

    private void stopMoving() {
        this.movingY = this.stopY;
        for (BlockPos pos : this.positions) {
            if (!this.getWorld().getBlockState(pos).getBlock().isReplaceable((IBlockAccess)this.getWorld(), pos)) continue;
            this.getWorld().setBlockState(ElevatorTileEntity.getPosAtY(pos, this.stopY), this.movingState, 3);
        }
        this.cachedCurrent = -1;
        this.markDirtyClient();
    }

    private void clearMovement() {
        this.positions.clear();
        this.entitiesOnPlatform.clear();
        this.movingState = null;
        this.bounds = null;
        this.movingY = -1.0;
    }

    private boolean startMoving(BlockPos start, BlockPos stop, IBlockState state) {
        this.movingState = state;
        this.positions.clear();
        this.getBounds(start);
        if (this.bounds.getMaxX() < this.bounds.getMinX() || this.bounds.getMaxZ() < this.bounds.getMinZ()) {
            this.bounds = null;
            return false;
        }
        this.movingY = start.getY();
        this.startY = start.getY();
        this.stopY = stop.getY();
        this.markDirtyClient();
        return true;
    }

    private boolean canMoveBlock(BlockPos pos) {
        World world = this.getWorld();
        IBlockState state = world.getBlockState(pos);
        return state == this.movingState && state.getBlockHardness(world, pos) >= 0.0f && BuilderTileEntity.allowedToBreak(state, world, pos, (EntityPlayer)this.getHarvester());
    }

    private void getBounds(BlockPos start) {
        BlockPos offset;
        EnumFacing side = (EnumFacing)this.getWorld().getBlockState(this.getPos()).getValue((IProperty)BaseBlock.FACING_HORIZ);
        this.bounds = new Bounds();
        for (int a = 1; a < ElevatorConfiguration.maxPlatformSize.get() && this.canMoveBlock(offset = start.offset(side, a)); ++a) {
            BlockPos offsetRight;
            BlockPos offsetLeft;
            int b;
            this.getWorld().setBlockToAir(offset);
            this.bounds.addPos(offset);
            this.positions.add(ElevatorTileEntity.getPosAtY(offset, this.getPos().getY()));
            for (b = 1; b <= ElevatorConfiguration.maxPlatformSize.get() / 2 && this.canMoveBlock(offsetLeft = offset.offset(side.rotateY(), b)); ++b) {
                this.getWorld().setBlockToAir(offsetLeft);
                this.bounds.addPos(offsetLeft);
                this.positions.add(ElevatorTileEntity.getPosAtY(offsetLeft, this.getPos().getY()));
            }
            for (b = 1; b <= ElevatorConfiguration.maxPlatformSize.get() / 2 && this.canMoveBlock(offsetRight = offset.offset(side.rotateYCCW(), b)); ++b) {
                this.getWorld().setBlockToAir(offsetRight);
                this.bounds.addPos(offsetRight);
                this.positions.add(ElevatorTileEntity.getPosAtY(offsetRight, this.getPos().getY()));
            }
        }
    }

    public AxisAlignedBB getAABBBigMargin() {
        return new AxisAlignedBB((double)this.bounds.getMinX(), this.movingY - 150.0, (double)this.bounds.getMinZ(), (double)(this.bounds.getMaxX() + 1), this.movingY + 150.0, (double)(this.bounds.getMaxZ() + 1));
    }

    public AxisAlignedBB getAABBAboveElevator(double speed) {
        double o2;
        double o1;
        if (speed > 0.0) {
            o1 = -speed * 2.0;
            o2 = 0.0;
        } else {
            o1 = 0.0;
            o2 = -speed * 2.0;
        }
        return new AxisAlignedBB((double)this.bounds.getMinX(), this.movingY - 1.0 + o1, (double)this.bounds.getMinZ(), (double)(this.bounds.getMaxX() + 1), this.movingY + 3.0 + o2, (double)(this.bounds.getMaxZ() + 1));
    }

    public boolean isMoving() {
        return this.movingY >= 0.0;
    }

    public double getMovingY() {
        return this.movingY;
    }

    public void toLevel(int level) {
        EnumFacing side = (EnumFacing)this.getWorld().getBlockState(this.getPos()).getValue((IProperty)BaseBlock.FACING_HORIZ);
        BlockPos controllerPos = this.findBottomElevator();
        for (int y = controllerPos.getY(); y < this.getWorld().getHeight(); ++y) {
            EnumFacing side2;
            TileEntity te2;
            BlockPos pos2 = ElevatorTileEntity.getPosAtY(controllerPos, y);
            if (this.getWorld().getBlockState(pos2).getBlock() != ElevatorSetup.elevatorBlock || !((te2 = this.getWorld().getTileEntity(pos2)) instanceof ElevatorTileEntity) || side != (side2 = (EnumFacing)this.getWorld().getBlockState(pos2).getValue((IProperty)BaseBlock.FACING_HORIZ))) continue;
            if (level == 0) {
                ((ElevatorTileEntity)te2).movePlatformHere();
                return;
            }
            --level;
        }
    }

    public void findElevatorBlocks(List<Integer> heights) {
        BlockPos controllerPos = this.findBottomElevator();
        if (controllerPos == null) {
            return;
        }
        IBlockState blockState = this.getWorld().getBlockState(this.getPos());
        if (blockState.getBlock() != ElevatorSetup.elevatorBlock) {
            return;
        }
        EnumFacing side = (EnumFacing)blockState.getValue((IProperty)BaseBlock.FACING_HORIZ);
        for (int y = controllerPos.getY(); y < this.getWorld().getHeight(); ++y) {
            EnumFacing side2;
            BlockPos pos2 = ElevatorTileEntity.getPosAtY(controllerPos, y);
            TileEntity te2 = this.getWorld().getTileEntity(pos2);
            if (!(te2 instanceof ElevatorTileEntity) || side != (side2 = (EnumFacing)this.getWorld().getBlockState(pos2).getValue((IProperty)BaseBlock.FACING_HORIZ))) continue;
            heights.add(y);
        }
    }

    public int getCurrentLevel(List<Integer> heights) {
        BlockPos controllerPos = this.findBottomElevator();
        TileEntity te = this.getWorld().getTileEntity(controllerPos);
        if (te instanceof ElevatorTileEntity) {
            EnumFacing side = (EnumFacing)this.getWorld().getBlockState(controllerPos).getValue((IProperty)BaseBlock.FACING_HORIZ);
            ElevatorTileEntity controller = (ElevatorTileEntity)te;
            if (controller.cachedCurrent == -1) {
                int level = 0;
                for (Integer y : heights) {
                    BlockPos pos2 = ElevatorTileEntity.getPosAtY(controllerPos, y);
                    BlockPos frontPos = pos2.offset(side);
                    if (this.isValidPlatformBlock(frontPos)) {
                        controller.cachedCurrent = level;
                    }
                    ++level;
                }
            }
            return controller.cachedCurrent;
        }
        return 0;
    }

    public int getLevelCount(List<Integer> heights) {
        return heights.size();
    }

    public boolean isPlatformHere() {
        IBlockState blockState = this.getWorld().getBlockState(this.getPos());
        if (blockState.getBlock() != ElevatorSetup.elevatorBlock) {
            return false;
        }
        EnumFacing side = (EnumFacing)blockState.getValue((IProperty)BaseBlock.FACING_HORIZ);
        BlockPos frontPos = this.getPos().offset(side);
        return this.isValidPlatformBlock(frontPos);
    }

    private void movePlatformHere() {
        IBlockState blockState = this.getWorld().getBlockState(this.getPos());
        if (blockState.getBlock() != ElevatorSetup.elevatorBlock) {
            return;
        }
        EnumFacing side = (EnumFacing)blockState.getValue((IProperty)BaseBlock.FACING_HORIZ);
        BlockPos frontPos = this.getPos().offset(side);
        if (this.isValidPlatformBlock(frontPos)) {
            return;
        }
        BlockPos platformPos = this.findElevatorWithPlatform();
        if (platformPos == null) {
            return;
        }
        BlockPos controllerPos = this.findBottomElevator();
        ElevatorTileEntity controller = (ElevatorTileEntity)this.getWorld().getTileEntity(controllerPos);
        if (controller.isMoving()) {
            return;
        }
        int rfNeeded = (int)((float)(ElevatorConfiguration.rfPerHeightUnit.get() * Math.abs(this.getPos().getY() - platformPos.getY())) * (3.0f - this.getInfusedFactor()) / 3.0f);
        if (controller.getStoredPower() < (long)rfNeeded) {
            Broadcaster.broadcast((World)this.getWorld(), (int)this.getPos().getX(), (int)this.getPos().getY(), (int)this.getPos().getZ(), (String)(TextFormatting.RED + "Not enough power to move the elevator platform!"), (float)10.0f);
            return;
        }
        if (controller.startMoving(platformPos, this.getPos(), this.getWorld().getBlockState(platformPos.offset(side)))) {
            controller.consumeEnergy(rfNeeded);
        } else {
            Broadcaster.broadcast((World)this.getWorld(), (int)this.getPos().getX(), (int)this.getPos().getY(), (int)this.getPos().getZ(), (String)(TextFormatting.RED + "The block in front of the elevator platform could not be moved!"), (float)10.0f);
        }
    }

    public static BlockPos getPosAtY(BlockPos p, int y) {
        return new BlockPos(p.getX(), y, p.getZ());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isMoving()) {
            return new AxisAlignedBB(this.getPos().add(-9, 0, -9), this.getPos().add(9, 255, 9));
        }
        return super.getRenderBoundingBox();
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        if (this.isMoving()) {
            return 65536.0;
        }
        return super.getMaxRenderDistanceSquared();
    }

    private static short bytesToShort(byte b1, byte b2) {
        short s1 = (short)(b1 & 0xFF);
        short s2 = (short)(b2 & 0xFF);
        return (short)(s1 * 256 + s2);
    }

    private static byte shortToByte1(short s) {
        return (byte)((s & 0xFF00) >> 8);
    }

    private static byte shortToByte2(short s) {
        return (byte)(s & 0xFF);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.getNbtCompound();
        this.readFromNBTCommon(compound);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.readFromNBTCommon(tagCompound);
        this.redstoneOut = tagCompound.getBoolean("rs");
        this.entitiesOnPlatformComplete = false;
        if (tagCompound.hasKey("players")) {
            this.entitiesOnPlatform.clear();
            WorldServer world = DimensionManager.getWorld((int)0);
            List serverPlayers = world.getMinecraftServer().getPlayerList().getPlayers();
            NBTTagList playerList = tagCompound.getTagList("players", 10);
            block0: for (int i = 0; i < playerList.tagCount(); ++i) {
                NBTTagCompound p = playerList.getCompoundTagAt(i);
                long lsb = p.getLong("lsb");
                long msb = p.getLong("msb");
                UUID uuid = new UUID(msb, lsb);
                for (EntityPlayerMP serverPlayer : serverPlayers) {
                    if (!serverPlayer.getGameProfile().getId().equals(uuid)) continue;
                    this.entitiesOnPlatform.add((Entity)serverPlayer);
                    continue block0;
                }
            }
        }
    }

    private void readFromNBTCommon(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.prevIn = tagCompound.getBoolean("prevIn");
        this.movingY = tagCompound.getDouble("movingY");
        this.startY = tagCompound.getInteger("startY");
        this.stopY = tagCompound.getInteger("stopY");
        byte[] byteArray = tagCompound.getByteArray("relcoords");
        this.positions.clear();
        int j = 0;
        for (int i = 0; i < byteArray.length / 6; ++i) {
            short dx = ElevatorTileEntity.bytesToShort(byteArray[j + 0], byteArray[j + 1]);
            short dy = ElevatorTileEntity.bytesToShort(byteArray[j + 2], byteArray[j + 3]);
            short dz = ElevatorTileEntity.bytesToShort(byteArray[j + 4], byteArray[j + 5]);
            j += 6;
            RelCoordinate c = new RelCoordinate(dx, dy, dz);
            this.positions.add(new BlockPos(this.getPos().getX() + c.getDx(), this.getPos().getY() + c.getDy(), this.getPos().getZ() + c.getDz()));
        }
        if (tagCompound.hasKey("bminX")) {
            int bminX = tagCompound.getInteger("bminX");
            int bminZ = tagCompound.getInteger("bminZ");
            int bmaxX = tagCompound.getInteger("bmaxX");
            int bmaxZ = tagCompound.getInteger("bmaxZ");
            if (bminX <= bmaxX && bminZ <= bmaxZ) {
                this.bounds = new Bounds(bminX, bminZ, bmaxX, bmaxZ);
            }
        }
        if (tagCompound.hasKey("movingId")) {
            Integer id = tagCompound.getInteger("movingId");
            this.movingState = Block.getStateById((int)id);
        } else if (tagCompound.hasKey("movingBlock")) {
            String id = tagCompound.getString("movingBlock");
            int meta = tagCompound.getInteger("movingMeta");
            this.movingState = ((Block)Block.REGISTRY.getObject((Object)new ResourceLocation(id))).getStateFromMeta(meta);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setBoolean("rs", this.redstoneOut);
        tagCompound.setBoolean("prevIn", this.prevIn);
        tagCompound.setDouble("movingY", this.movingY);
        tagCompound.setInteger("startY", this.startY);
        tagCompound.setInteger("stopY", this.stopY);
        byte[] blocks = new byte[this.positions.size() * 6];
        int j = 0;
        for (BlockPos pos : this.positions) {
            RelCoordinate c = new RelCoordinate(pos.getX() - this.getPos().getX(), pos.getY() - this.getPos().getY(), pos.getZ() - this.getPos().getZ());
            blocks[j + 0] = ElevatorTileEntity.shortToByte1((short)c.getDx());
            blocks[j + 1] = ElevatorTileEntity.shortToByte2((short)c.getDx());
            blocks[j + 2] = ElevatorTileEntity.shortToByte1((short)c.getDy());
            blocks[j + 3] = ElevatorTileEntity.shortToByte2((short)c.getDy());
            blocks[j + 4] = ElevatorTileEntity.shortToByte1((short)c.getDz());
            blocks[j + 5] = ElevatorTileEntity.shortToByte2((short)c.getDz());
            j += 6;
        }
        if (this.bounds != null) {
            tagCompound.setInteger("bminX", this.bounds.getMinX());
            tagCompound.setInteger("bminZ", this.bounds.getMinZ());
            tagCompound.setInteger("bmaxX", this.bounds.getMaxX());
            tagCompound.setInteger("bmaxZ", this.bounds.getMaxZ());
        }
        tagCompound.setByteArray("relcoords", blocks);
        if (this.movingState != null) {
            tagCompound.setInteger("movingId", Block.getStateId((IBlockState)this.movingState));
        }
        if (!this.getWorld().isRemote && !this.entitiesOnPlatform.isEmpty()) {
            NBTTagList playerList = new NBTTagList();
            for (Entity entity : this.entitiesOnPlatform) {
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)entity;
                UUID id = player.getGameProfile().getId();
                NBTTagCompound p = new NBTTagCompound();
                p.setLong("lsb", id.getLeastSignificantBits());
                p.setLong("msb", id.getMostSignificantBits());
                playerList.appendTag((NBTBase)p);
            }
            tagCompound.setTag("players", (NBTBase)playerList);
        }
        return tagCompound;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.name = tagCompound.getString("levelName");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.setString("levelName", this.name == null ? "" : this.name);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETNAME.equals(command)) {
            this.setName((String)params.get(TextField.PARAM_TEXT));
            return true;
        }
        return false;
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        this.clearCaches((EnumFacing)world.getBlockState(pos).getValue((IProperty)BaseBlock.FACING_HORIZ));
    }

    public void onBlockBreak(World world, BlockPos pos, IBlockState state) {
        super.onBlockBreak(world, pos, state);
        this.clearCaches((EnumFacing)state.getValue((IProperty)BaseBlock.FACING_HORIZ));
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        probeInfo.text(TextFormatting.BLUE + "Name: " + this.getName());
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public void addWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.addWailaBody(itemStack, currenttip, accessor, config);
        long energy = this.getStoredPower();
        currenttip.add(TextFormatting.GREEN + "RF: " + energy);
        if (this.getName() != null && !this.getName().isEmpty()) {
            currenttip.add(TextFormatting.BLUE + "Name: " + this.getName());
        }
    }

    public int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumFacing direction = (EnumFacing)state.getValue((IProperty)BaseBlock.FACING_HORIZ);
        if (side == direction) {
            return this.isPlatformHere() ? 15 : 0;
        }
        return 0;
    }

    private static class Bounds {
        private int minX = 1000000000;
        private int minZ = 1000000000;
        private int maxX = -1000000000;
        private int maxZ = -1000000000;

        public Bounds() {
        }

        public Bounds(int minX, int minZ, int maxX, int maxZ) {
            this.maxX = maxX;
            this.maxZ = maxZ;
            this.minX = minX;
            this.minZ = minZ;
        }

        public void addPos(BlockPos pos) {
            if (pos.getX() < this.minX) {
                this.minX = pos.getX();
            }
            if (pos.getX() > this.maxX) {
                this.maxX = pos.getX();
            }
            if (pos.getZ() < this.minZ) {
                this.minZ = pos.getZ();
            }
            if (pos.getZ() > this.maxZ) {
                this.maxZ = pos.getZ();
            }
        }

        public int getMinX() {
            return this.minX;
        }

        public int getMinZ() {
            return this.minZ;
        }

        public int getMaxX() {
            return this.maxX;
        }

        public int getMaxZ() {
            return this.maxZ;
        }
    }
}

