/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.elevator;

import java.util.Set;
import javax.annotation.Nullable;
import mcjty.rftools.blocks.elevator.ElevatorTileEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FakeElevatorWorld
implements IBlockAccess {
    private Set<BlockPos> positions;
    private IBlockState state;
    private World realWorld;
    private final IBlockState AIR = Blocks.AIR.getDefaultState();

    public void setWorldAndState(ElevatorTileEntity elevatorTileEntity) {
        this.state = elevatorTileEntity.getMovingState();
        this.realWorld = elevatorTileEntity.getWorld();
        this.positions = elevatorTileEntity.getPositions();
    }

    @SideOnly(value=Side.CLIENT)
    public int getCombinedLight(BlockPos pos, int lightValue) {
        return this.realWorld.getCombinedLight(pos, lightValue);
    }

    @Nullable
    public TileEntity getTileEntity(BlockPos pos) {
        return null;
    }

    public IBlockState getBlockState(BlockPos pos) {
        return this.positions.contains(pos) ? this.state : this.AIR;
    }

    public boolean isAirBlock(BlockPos pos) {
        return !this.positions.contains(pos);
    }

    public Biome getBiome(BlockPos pos) {
        return this.realWorld.getBiome(pos);
    }

    public int getStrongPower(BlockPos pos, EnumFacing direction) {
        return 0;
    }

    public WorldType getWorldType() {
        return this.realWorld.getWorldType();
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return this.getBlockState(pos).isSideSolid((IBlockAccess)this, pos, side);
    }
}

