/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.endergen.EndergenicTileEntity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EndergenicPearl {
    private int ticksLeft;
    private final BlockPos destination;
    private final int age;

    public EndergenicPearl(int ticksLeft, BlockPos destination, int age) {
        this.ticksLeft = ticksLeft;
        this.destination = destination;
        this.age = age;
    }

    public EndergenicPearl(NBTTagCompound tagCompound) {
        this.ticksLeft = tagCompound.getInteger("t");
        this.destination = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"dest");
        this.age = tagCompound.getInteger("age");
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public int getAge() {
        return this.age;
    }

    public BlockPos getDestination() {
        return this.destination;
    }

    public boolean handleTick(World world) {
        --this.ticksLeft;
        if (this.ticksLeft <= 0) {
            TileEntity te = world.getTileEntity(this.destination);
            if (te instanceof EndergenicTileEntity) {
                EndergenicTileEntity endergenicTileEntity = (EndergenicTileEntity)te;
                endergenicTileEntity.receivePearl(this.age);
            } else {
                Logging.log((String)"Pearl: where did the destination go?");
            }
            return true;
        }
        return false;
    }

    public NBTTagCompound getTagCompound() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.setInteger("t", this.ticksLeft);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"dest", (BlockPos)this.destination);
        tagCompound.setInteger("age", this.age);
        return tagCompound;
    }
}

