/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftools.TickOrderHandler;
import mcjty.rftools.blocks.endergen.EndergenicTileEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class PearlInjectorTileEntity
extends GenericTileEntity
implements DefaultSidedInventory,
ITickable,
TickOrderHandler.ICheckStateServer {
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(new ResourceLocation("rftools", "gui/pearl_injector.gui"));
    public static final int BUFFER_SIZE = 18;
    public static final int SLOT_BUFFER = 0;
    public static final int SLOT_PLAYERINV = 18;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 18);
    private boolean prevIn = false;
    private int[] accessibleSlots;

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public EndergenicTileEntity findEndergenicTileEntity() {
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        EnumFacing k = OrientationTools.getOrientation((IBlockState)state);
        EndergenicTileEntity te = this.getEndergenicGeneratorAt(k.getOpposite());
        if (te != null) {
            return te;
        }
        return this.getEndergenicGeneratorAt(EnumFacing.UP);
    }

    private EndergenicTileEntity getEndergenicGeneratorAt(EnumFacing k) {
        BlockPos o = this.getPos().offset(k);
        TileEntity te = this.getWorld().getTileEntity(o);
        if (te instanceof EndergenicTileEntity) {
            return (EndergenicTileEntity)te;
        }
        return null;
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            TickOrderHandler.queuePearlInjector(this);
        }
    }

    @Override
    public void checkStateServer() {
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        if (this.prevIn == this.powerLevel > 0) {
            return;
        }
        boolean bl = this.prevIn = this.powerLevel > 0;
        if (pulse) {
            this.injectPearl();
        }
        this.markDirty();
    }

    @Override
    public int getDimension() {
        return this.world.provider.getDimension();
    }

    private boolean takePearl() {
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            if (stack.isEmpty() || !Items.ENDER_PEARL.equals(stack.getItem()) || stack.getCount() <= 0) continue;
            this.decrStackSize(i, 1);
            return true;
        }
        return false;
    }

    public void injectPearl() {
        EndergenicTileEntity endergen = this.findEndergenicTileEntity();
        if (endergen != null) {
            if (!this.takePearl()) {
                return;
            }
            int mode = endergen.getChargingMode();
            if (mode != -1) {
                endergen.firePearlFromInjector();
            }
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.prevIn = tagCompound.getBoolean("prevIn");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setBoolean("prevIn", this.prevIn);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return Items.ENDER_PEARL.equals(stack.getItem());
    }

    public int[] getSlotsForFace(EnumFacing side) {
        if (this.accessibleSlots == null) {
            this.accessibleSlots = new int[18];
            for (int i = 0; i < 18; ++i) {
                this.accessibleSlots[i] = i;
            }
        }
        return this.accessibleSlots;
    }

    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.isItemValidForSlot(index, itemStackIn);
    }
}

