/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.environmental.modules;

import java.util.ArrayList;
import java.util.List;
import mcjty.rftools.PlayerBuff;
import mcjty.rftools.blocks.environmental.EnvironmentalControllerTileEntity;
import mcjty.rftools.blocks.environmental.modules.EnvironmentModule;
import mcjty.rftools.playerprops.BuffProperties;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class PotionEffectModule
implements EnvironmentModule {
    public static final int MAXTICKS = 180;
    private final Potion potion;
    private final int amplifier;
    private boolean active = false;
    private int ticks = 180;

    public PotionEffectModule(String potionname, int amplifier) {
        this.potion = (Potion)Potion.REGISTRY.getObject((Object)new ResourceLocation(potionname));
        this.amplifier = amplifier;
    }

    protected abstract PlayerBuff getBuff();

    protected boolean allowedForPlayers() {
        return true;
    }

    @Override
    public void tick(World world, BlockPos pos, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        if (!this.active) {
            return;
        }
        --this.ticks;
        if (this.ticks > 0) {
            return;
        }
        this.ticks = 180;
        EnvironmentalControllerTileEntity.EnvironmentalMode mode = controllerTileEntity.getMode();
        switch (mode) {
            case MODE_BLACKLIST: 
            case MODE_WHITELIST: {
                if (!this.allowedForPlayers()) break;
                this.processPlayers(world, pos, radius, miny, maxy, controllerTileEntity);
                break;
            }
            case MODE_HOSTILE: 
            case MODE_PASSIVE: 
            case MODE_MOBS: 
            case MODE_ALL: {
                this.processEntities(world, pos, radius, miny, maxy, controllerTileEntity);
            }
        }
    }

    private void processPlayers(World world, BlockPos pos, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        double maxsqdist = radius * radius;
        ArrayList players = new ArrayList(world.playerEntities);
        for (EntityPlayer player : players) {
            double py = player.posY;
            if (!(py >= (double)miny) || !(py <= (double)maxy)) continue;
            double px = player.posX;
            double pz = player.posZ;
            double sqdist = (px - (double)pos.getX()) * (px - (double)pos.getX()) + (pz - (double)pos.getZ()) * (pz - (double)pos.getZ());
            if (!(sqdist < maxsqdist) || !controllerTileEntity.isPlayerAffected(player)) continue;
            player.addPotionEffect(new PotionEffect(this.potion, 540, this.amplifier, true, false));
            PlayerBuff buff = this.getBuff();
            if (buff == null) continue;
            BuffProperties.addBuffToPlayer(player, buff, 180);
        }
    }

    private void processEntities(World world, BlockPos pos, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        double maxsqdist = radius * radius;
        List entities = world.getEntitiesWithinAABB(EntityLivingBase.class, new AxisAlignedBB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius)));
        for (EntityLivingBase entity : entities) {
            PlayerBuff buff;
            double py = entity.posY;
            if (!(py >= (double)miny) || !(py <= (double)maxy)) continue;
            double px = entity.posX;
            double pz = entity.posZ;
            double sqdist = (px - (double)pos.getX()) * (px - (double)pos.getX()) + (pz - (double)pos.getZ()) * (pz - (double)pos.getZ());
            if (!(sqdist < maxsqdist)) continue;
            if (controllerTileEntity.isEntityAffected((Entity)entity)) {
                if (entity instanceof EntityPlayer && !this.allowedForPlayers()) continue;
                entity.addPotionEffect(new PotionEffect(this.potion, 540, this.amplifier, true, false));
                buff = this.getBuff();
                if (buff == null || !(entity instanceof EntityPlayer)) continue;
                BuffProperties.addBuffToPlayer((EntityPlayer)entity, buff, 180);
                continue;
            }
            if (!(entity instanceof EntityPlayer) || (buff = this.getBuff()) == null) continue;
            BuffProperties.addBuffToPlayer((EntityPlayer)entity, buff, 180);
        }
    }

    @Override
    public boolean apply(World world, BlockPos pos, EntityLivingBase entity, int duration) {
        entity.addPotionEffect(new PotionEffect(this.potion, duration, this.amplifier, true, false));
        return true;
    }

    @Override
    public void activate(boolean a) {
        if (this.active == a) {
            return;
        }
        this.active = a;
        this.ticks = 1;
    }
}

