/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.infuser;

import mcjty.lib.api.Infusable;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.blocks.GenericBlock;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotType;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.rftools.blocks.infuser.MachineInfuserConfiguration;
import mcjty.rftools.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class MachineInfuserTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable {
    public static final int SLOT_SHARDINPUT = 0;
    public static final int SLOT_MACHINEOUTPUT = 1;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){

        protected void setup() {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)ModItems.dimensionalShardItem)}), "container", 0, 64, 24, 1, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_OUTPUT, new ItemStack[0]), "container", 1, 118, 24, 1, 18, 1, 18);
            this.layoutPlayerInventorySlots(10, 70);
        }
    };
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 2);
    private int infusing = 0;

    public MachineInfuserTileEntity() {
        super((long)MachineInfuserConfiguration.MAXENERGY.get(), (long)MachineInfuserConfiguration.RECEIVEPERTICK.get());
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (this.infusing > 0) {
            --this.infusing;
            if (this.infusing == 0) {
                ItemStack outputStack = this.inventoryHelper.getStackInSlot(1);
                this.finishInfusing(outputStack);
            }
            this.markDirty();
        } else {
            ItemStack inputStack = this.inventoryHelper.getStackInSlot(0);
            ItemStack outputStack = this.inventoryHelper.getStackInSlot(1);
            if (!inputStack.isEmpty() && inputStack.getItem() == ModItems.dimensionalShardItem && this.isInfusable(outputStack)) {
                this.startInfusing();
            }
        }
    }

    private boolean isInfusable(ItemStack stack) {
        NBTTagCompound tagCompound = MachineInfuserTileEntity.getTagCompound(stack);
        if (tagCompound == null) {
            return false;
        }
        int infused = tagCompound.getInteger("infused");
        return infused < GeneralConfig.maxInfuse;
    }

    public static NBTTagCompound getTagCompound(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        if (stack.getCount() != 1) {
            return null;
        }
        Item item = stack.getItem();
        if (!(item instanceof ItemBlock)) {
            return null;
        }
        Block block = ((ItemBlock)item).getBlock();
        if (!(block instanceof Infusable || block instanceof GenericBlock && ((GenericBlock)block).isInfusable())) {
            return null;
        }
        NBTTagCompound tagCompound = stack.getTagCompound();
        if (tagCompound == null) {
            return new NBTTagCompound();
        }
        return tagCompound;
    }

    private void finishInfusing(ItemStack stack) {
        NBTTagCompound tagCompound = MachineInfuserTileEntity.getTagCompound(stack);
        if (tagCompound == null) {
            return;
        }
        int infused = tagCompound.getInteger("infused");
        tagCompound.setInteger("infused", infused + 1);
        stack.setTagCompound(tagCompound);
    }

    private void startInfusing() {
        int rf = MachineInfuserConfiguration.rfPerTick.get();
        rf = (int)((float)rf * (2.0f - this.getInfusedFactor()) / 2.0f);
        if (this.getStoredPower() < (long)rf) {
            return;
        }
        this.consumeEnergy(rf);
        this.inventoryHelper.getStackInSlot(0).splitStack(1);
        if (this.inventoryHelper.getStackInSlot(0).isEmpty()) {
            this.inventoryHelper.setStackInSlot(0, ItemStack.EMPTY);
        }
        this.infusing = 5;
        this.markDirty();
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
        return CONTAINER_FACTORY.isInputSlot(index) || CONTAINER_FACTORY.isSpecificItemSlot(index);
    }

    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        return CONTAINER_FACTORY.isOutputSlot(index);
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index != 0 || stack.getItem() == ModItems.dimensionalShardItem;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.infusing = tagCompound.getInteger("infusing");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.setInteger("infusing", this.infusing);
    }
}

