/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.counter;

import java.util.List;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.CommandHandler;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CounterTileEntity
extends LogicTileEntity {
    public static final String CMD_SETCOUNTER = "counter.setCounter";
    public static final String CMD_SETCURRENT = "counter.setCurrent";
    private boolean prevIn = false;
    private int counter = 1;
    private int current = 0;
    private static long lastTime = 0L;
    public static int cntReceived = 0;

    public int getCounter() {
        return this.counter;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCounter(int counter) {
        this.counter = counter;
        this.current = 0;
        this.markDirtyClient();
    }

    public void setCurrent(int current) {
        this.current = current;
        this.markDirtyClient();
    }

    protected void update() {
        if (this.getWorld().isRemote) {
            return;
        }
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        this.prevIn = this.powerLevel > 0;
        int newout = 0;
        if (pulse) {
            ++this.current;
            if (this.current >= this.counter) {
                this.current = 0;
                newout = 15;
            }
            this.markDirty();
            this.setRedstoneState(newout);
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.powerOutput = tagCompound.getBoolean("rs") ? 15 : 0;
        this.prevIn = tagCompound.getBoolean("prevIn");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.counter = tagCompound.getInteger("counter");
        if (this.counter == 0) {
            this.counter = 1;
        }
        this.current = tagCompound.getInteger("current");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setBoolean("rs", this.powerOutput > 0);
        tagCompound.setBoolean("prevIn", this.prevIn);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.setInteger("counter", this.counter);
        tagCompound.setInteger("current", this.current);
    }

    public void checkRedstone(World world, BlockPos pos) {
        super.checkRedstone(world, pos);
        this.update();
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETCOUNTER.equals(command)) {
            int counter;
            try {
                counter = Integer.parseInt((String)params.get(TextField.PARAM_TEXT));
            }
            catch (NumberFormatException e) {
                counter = 1;
            }
            this.setCounter(counter);
            return true;
        }
        if (CMD_SETCURRENT.equals(command)) {
            int current;
            try {
                current = Integer.parseInt((String)params.get(TextField.PARAM_TEXT));
            }
            catch (NumberFormatException e) {
                current = 1;
            }
            this.setCurrent(current);
            return true;
        }
        return false;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        probeInfo.text(TextFormatting.GREEN + "Current: " + this.getCurrent());
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public void addWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.addWailaBody(itemStack, currenttip, accessor, config);
        if (System.currentTimeMillis() - lastTime > 500L) {
            lastTime = System.currentTimeMillis();
            RFToolsMessages.sendToServer("getCounterInfo", TypedMap.builder().put(CommandHandler.PARAM_DIMENSION, (Object)this.getWorld().provider.getDimension()).put(CommandHandler.PARAM_POS, (Object)this.getPos()));
        }
        currenttip.add(TextFormatting.GREEN + "Current: " + cntReceived);
    }
}

