/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.sensor;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LogicFacing;
import mcjty.rftools.blocks.logic.sensor.AreaType;
import mcjty.rftools.blocks.logic.sensor.GroupType;
import mcjty.rftools.blocks.logic.sensor.SensorType;
import mcjty.rftools.varia.NamedEnum;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SensorTileEntity
extends LogicTileEntity
implements ITickable,
DefaultSidedInventory {
    public static final String CMD_SETNUMBER = "sensor.setNumber";
    public static final String CMD_SETTYPE = "sensor.setType";
    public static final String CMD_SETAREA = "sensor.setArea";
    public static final String CMD_SETGROUP = "sensor.setGroup";
    public static final String CONTAINER_INVENTORY = "container";
    public static final int SLOT_ITEMMATCH = 0;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(new ResourceLocation("rftools", "gui/sensor.gui"));
    private int number = 0;
    private SensorType sensorType = SensorType.SENSOR_BLOCK;
    private AreaType areaType = AreaType.AREA_1;
    private GroupType groupType = GroupType.GROUP_ONE;
    private int checkCounter = 0;
    private AxisAlignedBB cachedBox = null;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 1);

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
        this.cachedBox = null;
        this.markDirtyClient();
    }

    public SensorType getSensorType() {
        return this.sensorType;
    }

    public void setSensorType(SensorType sensorType) {
        this.sensorType = sensorType;
        this.cachedBox = null;
        this.markDirtyClient();
    }

    public AreaType getAreaType() {
        return this.areaType;
    }

    public void setAreaType(AreaType areaType) {
        this.areaType = areaType;
        this.cachedBox = null;
        this.markDirtyClient();
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public void setGroupType(GroupType groupType) {
        this.groupType = groupType;
        this.cachedBox = null;
        this.markDirtyClient();
    }

    public void update() {
        if (this.getWorld().isRemote) {
            return;
        }
        --this.checkCounter;
        if (this.checkCounter > 0) {
            return;
        }
        this.checkCounter = 10;
        this.setRedstoneState(this.checkSensor() ? 15 : 0);
    }

    public boolean checkSensor() {
        boolean newout;
        LogicFacing facing = this.getFacing(this.getWorld().getBlockState(this.getPos()));
        EnumFacing inputSide = facing.getInputSide();
        BlockPos newpos = this.getPos().offset(inputSide);
        switch (this.sensorType) {
            case SENSOR_BLOCK: {
                newout = this.checkBlockOrFluid(newpos, facing, inputSide, this::checkBlock);
                break;
            }
            case SENSOR_FLUID: {
                newout = this.checkBlockOrFluid(newpos, facing, inputSide, this::checkFluid);
                break;
            }
            case SENSOR_GROWTHLEVEL: {
                newout = this.checkGrowthLevel(newpos, facing, inputSide);
                break;
            }
            case SENSOR_ENTITIES: {
                newout = this.checkEntities(newpos, facing, inputSide, Entity.class);
                break;
            }
            case SENSOR_PLAYERS: {
                newout = this.checkEntities(newpos, facing, inputSide, EntityPlayer.class);
                break;
            }
            case SENSOR_HOSTILE: {
                newout = this.checkEntitiesHostile(newpos, facing, inputSide);
                break;
            }
            case SENSOR_PASSIVE: {
                newout = this.checkEntitiesPassive(newpos, facing, inputSide);
                break;
            }
            default: {
                newout = false;
            }
        }
        return newout;
    }

    private boolean checkBlockOrFluid(BlockPos newpos, LogicFacing facing, EnumFacing dir, Function<BlockPos, Boolean> blockChecker) {
        int blockCount = this.areaType.getBlockCount();
        if (blockCount > 0) {
            Boolean x = this.checkBlockOrFluidRow(newpos, dir, blockChecker, blockCount);
            if (x != null) {
                return x;
            }
        } else if (blockCount < 0) {
            EnumFacing downSide = facing.getSide();
            EnumFacing inputSide = facing.getInputSide();
            EnumFacing rightSide = LogicSlabBlock.rotateLeft((EnumFacing)downSide, (EnumFacing)inputSide);
            EnumFacing leftSide = LogicSlabBlock.rotateRight((EnumFacing)downSide, (EnumFacing)inputSide);
            Boolean x = this.checkBlockOrFluidRow(newpos, dir, blockChecker, blockCount = -blockCount);
            if (x != null) {
                return x;
            }
            for (int i = 1; i <= (blockCount - 1) / 2; ++i) {
                BlockPos p = newpos.offset(leftSide, i);
                x = this.checkBlockOrFluidRow(p, dir, blockChecker, blockCount);
                if (x != null) {
                    return x;
                }
                p = newpos.offset(rightSide, i);
                x = this.checkBlockOrFluidRow(p, dir, blockChecker, blockCount);
                if (x == null) continue;
                return x;
            }
        }
        return this.groupType == GroupType.GROUP_ALL;
    }

    private Boolean checkBlockOrFluidRow(BlockPos newpos, EnumFacing dir, Function<BlockPos, Boolean> blockChecker, int count) {
        for (int i = 0; i < count; ++i) {
            boolean result = blockChecker.apply(newpos);
            if (result && this.groupType == GroupType.GROUP_ONE) {
                return true;
            }
            if (!result && this.groupType == GroupType.GROUP_ALL) {
                return false;
            }
            newpos = newpos.offset(dir);
        }
        return null;
    }

    private boolean checkBlock(BlockPos newpos) {
        IBlockState state = this.getWorld().getBlockState(newpos);
        ItemStack matcher = this.inventoryHelper.getStackInSlot(0);
        if (matcher.isEmpty()) {
            return state.getBlock().isFullBlock(state);
        }
        ItemStack stack = state.getBlock().getItem(this.getWorld(), newpos, state);
        if (!stack.isEmpty()) {
            return matcher.isItemEqual(stack);
        }
        return matcher.getItem() == Item.getItemFromBlock((Block)state.getBlock());
    }

    private boolean checkFluid(BlockPos newpos) {
        IBlockState state = this.getWorld().getBlockState(newpos);
        ItemStack matcher = this.inventoryHelper.getStackInSlot(0);
        Block block = state.getBlock();
        if (matcher.isEmpty()) {
            if (block instanceof BlockLiquid || block instanceof IFluidBlock) {
                return !block.isAir(state, (IBlockAccess)this.getWorld(), newpos);
            }
            return false;
        }
        ItemStack stack = block.getItem(this.getWorld(), newpos, state);
        Item matcherItem = matcher.getItem();
        FluidStack matcherFluidStack = null;
        if (matcherItem instanceof ItemBucket || matcherItem instanceof UniversalBucket) {
            matcherFluidStack = new FluidBucketWrapper(matcher).getFluid();
            return this.checkFluid(block, matcherFluidStack, state, newpos);
        }
        return false;
    }

    private boolean checkFluid(Block block, FluidStack matcherFluidStack, IBlockState state, BlockPos newpos) {
        if (matcherFluidStack == null) {
            return block.isAir(state, (IBlockAccess)this.getWorld(), newpos);
        }
        Fluid matcherFluid = matcherFluidStack.getFluid();
        if (matcherFluid == null) {
            return false;
        }
        Block matcherFluidBlock = matcherFluid.getBlock();
        if (matcherFluidBlock == null) {
            return false;
        }
        String matcherBlockName = matcherFluidBlock.getTranslationKey();
        String blockName = block.getTranslationKey();
        return blockName.equals(matcherBlockName);
    }

    private boolean checkGrowthLevel(BlockPos newpos, LogicFacing facing, EnumFacing dir) {
        int blockCount = this.areaType.getBlockCount();
        if (blockCount > 0) {
            Boolean x = this.checkGrowthLevelRow(newpos, dir, blockCount);
            if (x != null) {
                return x;
            }
        } else if (blockCount < 0) {
            EnumFacing downSide = facing.getSide();
            EnumFacing inputSide = facing.getInputSide();
            EnumFacing rightSide = LogicSlabBlock.rotateLeft((EnumFacing)downSide, (EnumFacing)inputSide);
            EnumFacing leftSide = LogicSlabBlock.rotateRight((EnumFacing)downSide, (EnumFacing)inputSide);
            Boolean x = this.checkGrowthLevelRow(newpos, dir, blockCount = -blockCount);
            if (x != null) {
                return x;
            }
            for (int i = 1; i <= (blockCount - 1) / 2; ++i) {
                BlockPos p = newpos.offset(leftSide, i);
                x = this.checkGrowthLevelRow(p, dir, blockCount);
                if (x != null) {
                    return x;
                }
                p = newpos.offset(rightSide, i);
                x = this.checkGrowthLevelRow(p, dir, blockCount);
                if (x == null) continue;
                return x;
            }
        }
        return this.groupType == GroupType.GROUP_ALL;
    }

    private Boolean checkGrowthLevelRow(BlockPos newpos, EnumFacing dir, int blockCount) {
        for (int i = 0; i < blockCount; ++i) {
            boolean result = this.checkGrowthLevel(newpos);
            if (result && this.groupType == GroupType.GROUP_ONE) {
                return true;
            }
            if (!result && this.groupType == GroupType.GROUP_ALL) {
                return false;
            }
            newpos = newpos.offset(dir);
        }
        return null;
    }

    private boolean checkGrowthLevel(BlockPos newpos) {
        IBlockState state = this.getWorld().getBlockState(newpos);
        int pct = 0;
        for (IProperty property : state.getProperties().keySet()) {
            if (!"age".equals(property.getName())) continue;
            if (property.getValueClass() != Integer.class) break;
            IProperty integerProperty = property;
            int age = (Integer)state.getValue(integerProperty);
            int maxAge = (Integer)Collections.max(integerProperty.getAllowedValues());
            pct = age * 100 / maxAge;
            break;
        }
        return pct >= this.number;
    }

    public void invalidateCache() {
        this.cachedBox = null;
    }

    private AxisAlignedBB getCachedBox(BlockPos pos1, LogicFacing facing, EnumFacing dir) {
        if (this.cachedBox == null) {
            int n = this.areaType.getBlockCount();
            if (n > 0) {
                this.cachedBox = new AxisAlignedBB(pos1);
                if (n > 1) {
                    BlockPos pos2 = pos1.offset(dir, n - 1);
                    this.cachedBox = this.cachedBox.union(new AxisAlignedBB(pos2));
                }
                this.cachedBox = this.cachedBox.expand(0.1, 0.1, 0.1);
            } else {
                BlockPos pos2;
                n = -n;
                this.cachedBox = new AxisAlignedBB(pos1);
                EnumFacing downSide = facing.getSide();
                EnumFacing inputSide = facing.getInputSide();
                EnumFacing rightSide = LogicSlabBlock.rotateLeft((EnumFacing)downSide, (EnumFacing)inputSide);
                EnumFacing leftSide = LogicSlabBlock.rotateRight((EnumFacing)downSide, (EnumFacing)inputSide);
                if (n > 1) {
                    pos2 = pos1.offset(dir, n - 1);
                    this.cachedBox = this.cachedBox.union(new AxisAlignedBB(pos2));
                }
                pos2 = pos1.offset(leftSide, (n - 1) / 2);
                this.cachedBox = this.cachedBox.union(new AxisAlignedBB(pos2));
                pos2 = pos1.offset(rightSide, (n - 1) / 2);
                this.cachedBox = this.cachedBox.union(new AxisAlignedBB(pos2));
            }
        }
        return this.cachedBox;
    }

    private boolean checkEntities(BlockPos pos1, LogicFacing facing, EnumFacing dir, Class<? extends Entity> clazz) {
        List entities = this.getWorld().getEntitiesWithinAABB(clazz, this.getCachedBox(pos1, facing, dir));
        return entities.size() >= this.number;
    }

    private boolean checkEntitiesHostile(BlockPos pos1, LogicFacing facing, EnumFacing dir) {
        List entities = this.getWorld().getEntitiesWithinAABB(EntityCreature.class, this.getCachedBox(pos1, facing, dir));
        int cnt = 0;
        for (Entity entity : entities) {
            if (!(entity instanceof IMob) || ++cnt < this.number) continue;
            return true;
        }
        return false;
    }

    private boolean checkEntitiesPassive(BlockPos pos1, LogicFacing facing, EnumFacing dir) {
        List entities = this.getWorld().getEntitiesWithinAABB(EntityCreature.class, this.getCachedBox(pos1, facing, dir));
        int cnt = 0;
        for (Entity entity : entities) {
            if (!(entity instanceof IAnimals) || entity instanceof IMob || ++cnt < this.number) continue;
            return true;
        }
        return false;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.powerOutput = tagCompound.getBoolean("rs") ? 15 : 0;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.number = tagCompound.getInteger("number");
        this.sensorType = SensorType.values()[tagCompound.getByte("sensor")];
        this.areaType = AreaType.values()[tagCompound.getByte("area")];
        this.groupType = GroupType.values()[tagCompound.getByte("group")];
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setBoolean("rs", this.powerOutput > 0);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.setInteger("number", this.number);
        tagCompound.setByte("sensor", (byte)this.sensorType.ordinal());
        tagCompound.setByte("area", (byte)this.areaType.ordinal());
        tagCompound.setByte("group", (byte)this.groupType.ordinal());
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETAREA.equals(command)) {
            AreaType type = (AreaType)NamedEnum.getEnumByName((String)((String)params.get(ChoiceLabel.PARAM_CHOICE)), (NamedEnum[])AreaType.values());
            this.setAreaType(type);
            return true;
        }
        if (CMD_SETTYPE.equals(command)) {
            SensorType type = (SensorType)NamedEnum.getEnumByName((String)((String)params.get(ChoiceLabel.PARAM_CHOICE)), (NamedEnum[])SensorType.values());
            this.setSensorType(type);
            return true;
        }
        if (CMD_SETGROUP.equals(command)) {
            GroupType type = (GroupType)NamedEnum.getEnumByName((String)((String)params.get(ChoiceLabel.PARAM_CHOICE)), (NamedEnum[])GroupType.values());
            this.setGroupType(type);
            return true;
        }
        if (CMD_SETNUMBER.equals(command)) {
            int number;
            try {
                number = Integer.parseInt((String)params.get(TextField.PARAM_TEXT));
            }
            catch (NumberFormatException e) {
                number = 1;
            }
            this.setNumber(number);
            return true;
        }
        return false;
    }

    public void rotateBlock(EnumFacing axis) {
        this.invalidateCache();
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        SensorType sensorType = this.getSensorType();
        if (sensorType.isSupportsNumber()) {
            probeInfo.text("Type: " + sensorType.getName() + " (" + this.getNumber() + ")");
        } else {
            probeInfo.text("Type: " + sensorType.getName());
        }
        int blockCount = this.getAreaType().getBlockCount();
        if (blockCount == 1) {
            probeInfo.text("Area: 1 block");
        } else if (blockCount < 0) {
            probeInfo.text("Area: " + -blockCount + "x" + -blockCount + " blocks");
        } else {
            probeInfo.text("Area: " + blockCount + " blocks");
        }
        boolean rc = this.checkSensor();
        probeInfo.text(TextFormatting.GREEN + "Output: " + TextFormatting.WHITE + (rc ? "on" : "off"));
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public void addWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.addWailaBody(itemStack, currenttip, accessor, config);
    }
}

