/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.sequencer;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.logic.sequencer.SequencerTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiSequencer
extends GenericGuiContainer<SequencerTileEntity> {
    private List<ImageChoiceLabel> bits = new ArrayList<ImageChoiceLabel>();

    public GuiSequencer(SequencerTileEntity sequencerTileEntity, GenericContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)sequencerTileEntity, (Container)container, GuiProxy.GUI_MANUAL_MAIN, "sequencer");
    }

    public void initGui() {
        this.window = new Window((GuiScreen)this, this.tileEntity, RFToolsMessages.INSTANCE, new ResourceLocation("rftools", "gui/sequencer.gui"));
        super.initGui();
        this.initializeFields();
        this.setupEvents();
    }

    private void initializeFields() {
        ImageChoiceLabel choiceLabel = (ImageChoiceLabel)this.window.findChild("endchoice");
        choiceLabel.setCurrentChoice(((SequencerTileEntity)this.tileEntity).getEndState() ? 1 : 0);
        TextField countField = (TextField)this.window.findChild("count");
        int count = ((SequencerTileEntity)this.tileEntity).getStepCount();
        if (count < 1 || count > 64) {
            count = 64;
        }
        countField.setText(String.valueOf(count));
        TextField speedField = (TextField)this.window.findChild("speed");
        int delay = ((SequencerTileEntity)this.tileEntity).getDelay();
        if (delay <= 0) {
            delay = 1;
        }
        speedField.setText(String.valueOf(delay));
        for (int row = 0; row < 8; ++row) {
            for (int col = 0; col < 8; ++col) {
                int bit = row * 8 + col;
                ImageChoiceLabel label = (ImageChoiceLabel)this.window.findChild("grid" + bit);
                label.setCurrentChoice(((SequencerTileEntity)this.tileEntity).getCycleBit(bit) ? 1 : 0);
                this.bits.add(label);
            }
        }
        ChoiceLabel mode = (ChoiceLabel)this.window.findChild("mode");
        mode.setChoice(((SequencerTileEntity)this.tileEntity).getMode().getDescription());
    }

    private void setupEvents() {
        this.window.event("grid", (source, params) -> {
            int bit = Integer.parseInt(source.getName().substring("grid".length()));
            this.changeBit(bit, (String)params.get(ImageChoiceLabel.PARAM_CHOICE));
        });
        this.window.event("flip", (source, params) -> this.flipGrid());
        this.window.event("clear", (source, params) -> this.fillGrid());
    }

    private void flipGrid() {
        for (ImageChoiceLabel bit : this.bits) {
            bit.setCurrentChoice(1 - bit.getCurrentChoiceIndex());
        }
        ((SequencerTileEntity)this.tileEntity).flipCycleBits();
        this.sendServerCommand(RFToolsMessages.INSTANCE, "sequencer.flipBits", TypedMap.EMPTY);
    }

    private void fillGrid() {
        for (ImageChoiceLabel bit : this.bits) {
            bit.setCurrentChoice(0);
        }
        ((SequencerTileEntity)this.tileEntity).clearCycleBits();
        this.sendServerCommand(RFToolsMessages.INSTANCE, "sequencer.clearBits", TypedMap.EMPTY);
    }

    private void changeBit(int bit, String choice) {
        boolean newChoice = "1".equals(choice);
        ((SequencerTileEntity)this.tileEntity).setCycleBit(bit, newChoice);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "sequencer.setBit", TypedMap.builder().put(SequencerTileEntity.PARAM_BIT, (Object)bit).put(SequencerTileEntity.PARAM_CHOICE, (Object)newChoice).build());
    }
}

