/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.threelogic;

import java.util.HashSet;
import java.util.Set;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LogicFacing;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ThreeLogicTileEntity
extends LogicTileEntity {
    public static final String CMD_SETSTATE = "logic.setState";
    public static final Key<Integer> PARAM_INDEX = new Key("index", Type.INTEGER);
    public static final Key<Integer> PARAM_STATE = new Key("state", Type.INTEGER);
    private int[] logicTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static Set<BlockPos> loopDetector = new HashSet<BlockPos>();

    public int getState(int index) {
        return this.logicTable[index];
    }

    public void checkRedstone() {
        int s = this.logicTable[this.powerLevel];
        if (s == -1) {
            return;
        }
        this.setRedstoneState(s == 1 ? 15 : 0);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.powerOutput = tagCompound.getBoolean("rs") ? 15 : 0;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        for (int i = 0; i < 8; ++i) {
            this.logicTable[i] = tagCompound.getInteger("state" + i);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setBoolean("rs", this.powerOutput > 0);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        for (int i = 0; i < 8; ++i) {
            tagCompound.setInteger("state" + i, this.logicTable[i]);
        }
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETSTATE.equals(command)) {
            this.logicTable[((Integer)params.get(ThreeLogicTileEntity.PARAM_INDEX)).intValue()] = (Integer)params.get(PARAM_STATE);
            this.markDirtyClient();
            this.checkRedstone(this.world, this.pos);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRedstone(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        if (loopDetector.add(pos)) {
            try {
                LogicFacing facing = this.getFacing(state);
                EnumFacing downSide = facing.getSide();
                EnumFacing inputSide = facing.getInputSide();
                EnumFacing leftSide = LogicSlabBlock.rotateLeft((EnumFacing)downSide, (EnumFacing)inputSide);
                EnumFacing rightSide = LogicSlabBlock.rotateRight((EnumFacing)downSide, (EnumFacing)inputSide);
                int powered1 = this.getInputStrength(world, pos, leftSide) > 0 ? 1 : 0;
                int powered2 = this.getInputStrength(world, pos, inputSide) > 0 ? 2 : 0;
                int powered3 = this.getInputStrength(world, pos, rightSide) > 0 ? 4 : 0;
                this.setPowerInput(powered1 + powered2 + powered3);
                this.checkRedstone();
            }
            finally {
                loopDetector.remove(pos);
            }
        }
    }
}

