/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.wireless;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class RedstoneChannels
extends AbstractWorldData<RedstoneChannels> {
    private static final String REDSTONE_CHANNELS_NAME = "RfToolsRedstoneChannels";
    private int lastId = 0;
    private final Map<Integer, RedstoneChannel> channels = new HashMap<Integer, RedstoneChannel>();

    public RedstoneChannels(String name) {
        super(name);
    }

    public void clear() {
        this.channels.clear();
        this.lastId = 0;
    }

    public static RedstoneChannels getChannels(World world) {
        return (RedstoneChannels)RedstoneChannels.getData((World)world, RedstoneChannels.class, (String)REDSTONE_CHANNELS_NAME);
    }

    public RedstoneChannel getOrCreateChannel(int id) {
        RedstoneChannel channel = this.channels.get(id);
        if (channel == null) {
            channel = new RedstoneChannel();
            this.channels.put(id, channel);
        }
        return channel;
    }

    public RedstoneChannel getChannel(int id) {
        return this.channels.get(id);
    }

    public void deleteChannel(int id) {
        this.channels.remove(id);
    }

    public int newChannel() {
        ++this.lastId;
        return this.lastId;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.channels.clear();
        NBTTagList lst = tagCompound.getTagList("channels", 10);
        for (int i = 0; i < lst.tagCount(); ++i) {
            NBTTagCompound tc = lst.getCompoundTagAt(i);
            int channel = tc.getInteger("channel");
            int v = tc.getInteger("value");
            RedstoneChannel value = new RedstoneChannel();
            value.value = v;
            this.channels.put(channel, value);
        }
        this.lastId = tagCompound.getInteger("lastId");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (Map.Entry<Integer, RedstoneChannel> entry : this.channels.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.setInteger("channel", entry.getKey().intValue());
            tc.setInteger("value", entry.getValue().getValue());
            lst.appendTag((NBTBase)tc);
        }
        tagCompound.setTag("channels", (NBTBase)lst);
        tagCompound.setInteger("lastId", this.lastId);
        return tagCompound;
    }

    public static class RedstoneChannel {
        private int value = 0;

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

