/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.ores;

import java.util.Collection;
import java.util.Random;
import mcjty.lib.McJtyRegister;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.DamageMetadataItemBlock;
import mcjty.rftools.RFTools;
import mcjty.rftools.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DimensionalShardBlock
extends Block {
    public static final PropertyEnum<OreType> ORETYPE = PropertyEnum.create((String)"oretype", OreType.class);
    private Random rand = new Random();

    public static boolean activateBlock(Block block, World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return block.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public static Collection<IProperty<?>> getPropertyKeys(IBlockState state) {
        return state.getPropertyKeys();
    }

    public void getSubBlocks(CreativeTabs itemIn, NonNullList<ItemStack> tab) {
        tab.add((Object)new ItemStack((Block)this, 1, 0));
        tab.add((Object)new ItemStack((Block)this, 1, 1));
        tab.add((Object)new ItemStack((Block)this, 1, 2));
    }

    public ItemStack getItem(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, ((OreType)((Object)state.getValue(ORETYPE))).ordinal());
    }

    public DimensionalShardBlock() {
        super(Material.ROCK);
        this.setHardness(3.0f);
        this.setResistance(5.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.setTranslationKey("rftools.dimensional_shard_ore");
        this.setRegistryName("dimensional_shard_ore");
        this.setLightLevel(0.5f);
        this.setCreativeTab(RFTools.setup.getTab());
        McJtyRegister.registerLater((Block)this, (ModBase)RFTools.instance, DamageMetadataItemBlock::new);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.getItemFromBlock((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "oretype=overworld"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.getItemFromBlock((Block)this), (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "oretype=nether"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.getItemFromBlock((Block)this), (int)2, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "oretype=end"));
    }

    public void onPlayerDestroy(World world, BlockPos pos, IBlockState state) {
        if (world.isRemote) {
            for (int i = 0; i < 10; ++i) {
                world.spawnParticle(EnumParticleTypes.FIREWORKS_SPARK, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), this.rand.nextGaussian() / 3.0, this.rand.nextGaussian() / 3.0, this.rand.nextGaussian() / 3.0, new int[0]);
            }
        }
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return ModItems.dimensionalShardItem;
    }

    public int quantityDropped(Random random) {
        return 2 + random.nextInt(3);
    }

    public int quantityDroppedWithBonus(int bonus, Random random) {
        int j = random.nextInt(bonus + 2) - 1;
        if (j < 0) {
            j = 0;
        }
        return this.quantityDropped(random) * (j + 1);
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        return this.rand.nextInt(4) + 3;
    }

    public void onBlockHarvested(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.onBlockHarvested(worldIn, pos, state, player);
        if (player != null) {
            // empty if block
        }
    }

    public int getMetaFromState(IBlockState state) {
        return ((OreType)((Object)state.getValue(ORETYPE))).ordinal();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(ORETYPE, (Comparable)((Object)OreType.values()[meta]));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{ORETYPE});
    }

    public static enum OreType implements IStringSerializable
    {
        ORE_OVERWORLD("overworld"),
        ORE_NETHER("nether"),
        ORE_END("end");

        private final String name;

        private OreType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

