/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.powercell;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.powercell.PowerCellConfiguration;
import mcjty.rftools.blocks.powercell.PowerCellContainer;
import mcjty.rftools.blocks.powercell.PowerCellTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiPowerCell
extends GenericGuiContainer<PowerCellTileEntity> {
    public static final int POWERCELL_WIDTH = 180;
    public static final int POWERCELL_HEIGHT = 152;
    private EnergyBar energyBar;
    private Button stats;
    private static long lastTime = 0L;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/powercell.png");

    public GuiPowerCell(PowerCellTileEntity te, PowerCellContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)te, (Container)container, GuiProxy.GUI_MANUAL_MAIN, "powercell");
        this.xSize = 180;
        this.ySize = 152;
    }

    public void initGui() {
        super.initGui();
        this.energyBar = ((EnergyBar)new EnergyBar(this.mc, (Gui)this).setVertical().setMaxValue(1000L).setLayoutHint(10, 7, 8, 54)).setShowText(false);
        this.energyBar.setValue(0L);
        Button allNone = (Button)((Button)((Button)((Button)new Button(this.mc, (Gui)this).setName("allnone")).setText("None")).setTooltips(new String[]{"Set all sides to 'none'"})).setLayoutHint(140, 10, 32, 15);
        Button allInput = (Button)((Button)((Button)((Button)new Button(this.mc, (Gui)this).setName("allinput")).setText("In")).setTooltips(new String[]{"Set all sides to", "accept energy"})).setLayoutHint(140, 27, 32, 15);
        Button allOutput = (Button)((Button)((Button)((Button)new Button(this.mc, (Gui)this).setName("alloutput")).setText("Out")).setTooltips(new String[]{"Set all sides to", "send energy"})).setLayoutHint(140, 44, 32, 15);
        this.stats = (Button)((Button)((Button)((Button)new Button(this.mc, (Gui)this).setName("clearstats")).setText("Stats")).setTooltips(new String[]{"Power statistics. Press to clear:"})).setLayoutHint(100, 10, 32, 15);
        Label label = new Label(this.mc, (Gui)this);
        ((Label)((Label)label.setText("Link:")).setTooltips(new String[]{"Link a powercard to card", "on the left"})).setLayoutHint(26, 30, 40, 18);
        Panel toplevel = (Panel)((Panel)new Panel(this.mc, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChildren(new Widget[]{this.energyBar, allNone, allInput, allOutput, label, this.stats});
        toplevel.setBounds(new Rectangle(this.guiLeft, this.guiTop, this.xSize, this.ySize));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        this.window.action(RFToolsMessages.INSTANCE, "allnone", (GenericTileEntity)((PowerCellTileEntity)this.tileEntity), "setNone");
        this.window.action(RFToolsMessages.INSTANCE, "allinput", (GenericTileEntity)((PowerCellTileEntity)this.tileEntity), "setInput");
        this.window.action(RFToolsMessages.INSTANCE, "alloutput", (GenericTileEntity)((PowerCellTileEntity)this.tileEntity), "setOutput");
        this.window.action(RFToolsMessages.INSTANCE, "clearstats", (GenericTileEntity)((PowerCellTileEntity)this.tileEntity), "clearStats");
        this.requestRF();
    }

    private void requestRF() {
        if (System.currentTimeMillis() - lastTime > 250L) {
            lastTime = System.currentTimeMillis();
            ((PowerCellTileEntity)this.tileEntity).requestDataFromServer("rftools", "getInfo", TypedMap.EMPTY);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float v, int i, int i2) {
        this.drawWindow();
        this.requestRF();
        this.stats.setTooltips(new String[]{"Power statistics. Press to clear:", "Inserted: " + PowerCellTileEntity.tooltipInserted, "Extracted: " + PowerCellTileEntity.tooltipExtracted});
        int maxValue = (PowerCellTileEntity.tooltipBlocks - PowerCellTileEntity.tooltipAdvancedBlocks - PowerCellTileEntity.tooltipSimpleBlocks) * PowerCellConfiguration.rfPerNormalCell.get();
        maxValue += PowerCellTileEntity.tooltipAdvancedBlocks * PowerCellConfiguration.rfPerNormalCell.get() * PowerCellConfiguration.advancedFactor.get();
        this.energyBar.setMaxValue((long)(maxValue += PowerCellTileEntity.tooltipSimpleBlocks * PowerCellConfiguration.rfPerNormalCell.get() / PowerCellConfiguration.simpleFactor.get()));
        this.energyBar.setValue((long)PowerCellTileEntity.tooltipEnergy);
    }
}

