/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.powercell;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.MachineInformation;
import mcjty.lib.api.smartwrench.SmartWrenchSelector;
import mcjty.lib.bindings.DefaultAction;
import mcjty.lib.bindings.IAction;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.TeleportationTools;
import mcjty.rftools.blocks.powercell.PowerCellBlock;
import mcjty.rftools.blocks.powercell.PowerCellConfiguration;
import mcjty.rftools.blocks.powercell.PowerCellContainer;
import mcjty.rftools.blocks.powercell.PowerCellNetwork;
import mcjty.rftools.blocks.powercell.PowerCellSetup;
import mcjty.rftools.items.powercell.PowerCellCardItem;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

public class PowerCellTileEntity
extends GenericTileEntity
implements DefaultSidedInventory,
ITickable,
SmartWrenchSelector,
MachineInformation {
    public static final String CMD_GET_INFO = "getInfo";
    public static final Key<Integer> PARAM_ENERGY = new Key("energy", Type.INTEGER);
    public static final Key<Integer> PARAM_BLOCKS = new Key("block", Type.INTEGER);
    public static final Key<Integer> PARAM_SIMPLEBLOCKS = new Key("simpleblocks", Type.INTEGER);
    public static final Key<Integer> PARAM_ADVANCEDBLOCKS = new Key("advancedblocks", Type.INTEGER);
    public static final Key<Long> PARAM_TOTAL_INSERTED = new Key("totalinserted", Type.LONG);
    public static final Key<Long> PARAM_TOTAL_EXTRACTED = new Key("totalextracted", Type.LONG);
    public static final Key<Integer> PARAM_RFPERTICK = new Key("rfpertick", Type.INTEGER);
    public static final Key<Double> PARAM_COSTFACTOR = new Key("costfactor", Type.DOUBLE);
    public static final String ACTION_SETNONE = "setNone";
    public static final String ACTION_SETINPUT = "setInput";
    public static final String ACTION_SETOUTPUT = "setOutput";
    public static final String ACTION_CLEARSTATS = "clearStats";
    public static int tooltipEnergy = 0;
    public static int tooltipBlocks = 0;
    public static int tooltipSimpleBlocks = 0;
    public static int tooltipAdvancedBlocks = 0;
    public static long tooltipInserted = 0L;
    public static long tooltipExtracted = 0L;
    public static int tooltipRfPerTick = 0;
    public static float tooltipCostFactor = 0.0f;
    private static final String[] TAGS = new String[]{"rfpertick_out", "rfpertick_in", "rftotal_in", "rftotal_out"};
    private static final String[] TAG_DESCRIPTIONS = new String[]{"The current RF/t output given by this block (last 2 seconds)", "The current RF/t input received by this block (last 2 seconds)", "The total RF/t output given by this block", "The current RF/t input received by this block"};
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, PowerCellContainer.factory, 3);
    private int networkId = -1;
    private int energy = 0;
    private long totalExtracted = 0L;
    private long totalInserted = 0L;
    private int lastRfPerTickIn = 0;
    private int lastRfPerTickOut = 0;
    private int powerIn = 0;
    private int powerOut = 0;
    private long lastTime = 0L;
    private Mode[] modes = new Mode[]{Mode.MODE_NONE, Mode.MODE_NONE, Mode.MODE_NONE, Mode.MODE_NONE, Mode.MODE_NONE, Mode.MODE_NONE};
    private IEnergyStorage[] sidedHandlers = new IEnergyStorage[6];
    private IEnergyStorage nullHandler;

    public IAction[] getActions() {
        return new IAction[]{new DefaultAction(ACTION_SETNONE, this::setAllNone), new DefaultAction(ACTION_SETINPUT, this::setAllInput), new DefaultAction(ACTION_SETOUTPUT, this::setAllOutput), new DefaultAction(ACTION_CLEARSTATS, () -> {
            this.totalExtracted = 0L;
            this.totalInserted = 0L;
            this.markDirty();
        })};
    }

    public int getTagCount() {
        return TAGS.length;
    }

    public String getTagName(int index) {
        return TAGS[index];
    }

    public String getTagDescription(int index) {
        return TAG_DESCRIPTIONS[index];
    }

    public String getData(int index, long millis) {
        switch (index) {
            case 0: {
                return this.lastRfPerTickOut + "RF/t";
            }
            case 1: {
                return this.lastRfPerTickIn + "RF/t";
            }
            case 2: {
                return this.totalExtracted + "RF";
            }
            case 3: {
                return this.totalInserted + "RF";
            }
        }
        return null;
    }

    public int getLastRfPerTickIn() {
        return this.lastRfPerTickIn;
    }

    public int getLastRfPerTickOut() {
        return this.lastRfPerTickOut;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(int networkId) {
        this.networkId = networkId;
        this.markDirty();
    }

    @Nullable
    public PowerCellNetwork.Network getNetwork() {
        if (this.world.isRemote) {
            return null;
        }
        int networkId = this.getNetworkId();
        if (networkId == -1) {
            return null;
        }
        PowerCellNetwork generatorNetwork = PowerCellNetwork.getChannels(this.getWorld());
        return generatorNetwork.getOrCreateNetwork(networkId);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        Mode[] old = new Mode[]{this.modes[0], this.modes[1], this.modes[2], this.modes[3], this.modes[4], this.modes[5]};
        super.onDataPacket(net, packet);
        for (int i = 0; i < 6; ++i) {
            if (old[i] == this.modes[i]) continue;
            this.getWorld().markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
            return;
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.energy = tagCompound.getInteger("energy");
        this.totalInserted = tagCompound.getLong("totIns");
        this.totalExtracted = tagCompound.getLong("totExt");
        this.networkId = tagCompound.getInteger("networkId");
        this.modes[0] = Mode.values()[tagCompound.getByte("m0")];
        this.modes[1] = Mode.values()[tagCompound.getByte("m1")];
        this.modes[2] = Mode.values()[tagCompound.getByte("m2")];
        this.modes[3] = Mode.values()[tagCompound.getByte("m3")];
        this.modes[4] = Mode.values()[tagCompound.getByte("m4")];
        this.modes[5] = Mode.values()[tagCompound.getByte("m5")];
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.setInteger("energy", this.energy);
        tagCompound.setLong("totIns", this.totalInserted);
        tagCompound.setLong("totExt", this.totalExtracted);
        tagCompound.setInteger("networkId", this.networkId);
        tagCompound.setByte("m0", (byte)this.modes[0].ordinal());
        tagCompound.setByte("m1", (byte)this.modes[1].ordinal());
        tagCompound.setByte("m2", (byte)this.modes[2].ordinal());
        tagCompound.setByte("m3", (byte)this.modes[3].ordinal());
        tagCompound.setByte("m4", (byte)this.modes[4].ordinal());
        tagCompound.setByte("m5", (byte)this.modes[5].ordinal());
    }

    public Mode getMode(EnumFacing side) {
        return this.modes[side.ordinal()];
    }

    public void toggleMode(EnumFacing side) {
        switch (this.modes[side.ordinal()]) {
            case MODE_NONE: {
                this.modes[side.ordinal()] = Mode.MODE_INPUT;
                break;
            }
            case MODE_INPUT: {
                this.modes[side.ordinal()] = Mode.MODE_OUTPUT;
                break;
            }
            case MODE_OUTPUT: {
                this.modes[side.ordinal()] = Mode.MODE_NONE;
            }
        }
        this.markDirtyClient();
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            int energyStored;
            long time = this.world.getTotalWorldTime();
            if (this.lastTime == 0L) {
                this.lastTime = time;
            } else if (time > this.lastTime + 40L) {
                this.lastRfPerTickIn = (int)((long)this.powerIn / (time - this.lastTime));
                this.lastRfPerTickOut = (int)((long)this.powerOut / (time - this.lastTime));
                this.lastTime = time;
                this.powerIn = 0;
                this.powerOut = 0;
            }
            if (this.isCreative()) {
                int gain = 1000000;
                int networkId = this.getNetworkId();
                if (networkId == -1) {
                    this.receiveEnergyLocal(gain, false);
                } else {
                    this.receiveEnergyMulti(gain, false);
                }
            }
            if ((energyStored = this.getEnergyStored()) <= 0) {
                return;
            }
            this.handleChargingItem();
            this.sendOutEnergy();
        }
    }

    private void handleChargingItem() {
        ItemStack stack = this.inventoryHelper.getStackInSlot(2);
        if (stack.isEmpty()) {
            return;
        }
        int rfToGive = Math.min(PowerCellConfiguration.CHARGEITEMPERTICK.get(), this.getEnergyStored());
        int received = (int)EnergyTools.receiveEnergy((ItemStack)stack, (long)rfToGive);
        if (received == 0) {
            return;
        }
        this.extractEnergyInternal(received, false, PowerCellConfiguration.CHARGEITEMPERTICK.get());
    }

    private void sendOutEnergy() {
        int energyStored = this.getEnergyStored();
        for (EnumFacing face : EnumFacing.VALUES) {
            int rfToGive;
            int received;
            EnumFacing opposite;
            if (this.modes[face.ordinal()] != Mode.MODE_OUTPUT) continue;
            BlockPos pos = this.getPos().offset(face);
            TileEntity te = this.getWorld().getTileEntity(pos);
            if (!EnergyTools.isEnergyTE((TileEntity)te, (EnumFacing)(opposite = face.getOpposite())) || te instanceof PowerCellTileEntity && this.getNetworkId() != -1 && ((PowerCellTileEntity)te).getNetworkId() == this.getNetworkId()) continue;
            float factor = this.getCostFactor();
            int rfPerTick = this.getRfPerTickPerSide();
            if ((energyStored -= this.extractEnergyInternal(received = (int)EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (long)(rfToGive = Math.min(rfPerTick, (int)((float)energyStored / factor)))), false, Integer.MAX_VALUE)) <= 0) break;
        }
    }

    public float getCostFactor() {
        float factor;
        float infusedFactor = this.getInfusedFactor();
        if (this.getNetworkId() == -1) {
            factor = 1.0f;
        } else {
            factor = this.getNetwork().calculateCostFactor(this.getWorld(), this.getGlobalPos());
            factor = (factor - 1.0f) * (1.0f - infusedFactor / 2.0f) + 1.0f;
        }
        return factor;
    }

    public int getRfPerTickPerSide() {
        return (int)((double)(PowerCellConfiguration.rfPerTick.get() * this.getPowerFactor() / PowerCellConfiguration.simpleFactor.get()) * ((double)this.getInfusedFactor() * 0.5 + 1.0));
    }

    private void handleCardRemoval() {
        PowerCellNetwork.Network network;
        if (!this.getWorld().isRemote && (network = this.getNetwork()) != null) {
            this.energy = network.extractEnergySingleBlock(this.isAdvanced(), this.isSimple());
            network.remove(this.getWorld(), this.getGlobalPos(), this.isAdvanced(), this.isSimple());
            PowerCellNetwork.getChannels(this.getWorld()).save();
        }
        this.networkId = -1;
        this.markDirty();
    }

    private void handleCardInsertion() {
        ItemStack stack = this.inventoryHelper.getStackInSlot(0);
        int id = PowerCellCardItem.getId(stack);
        if (!this.getWorld().isRemote) {
            PowerCellNetwork channels = PowerCellNetwork.getChannels(this.getWorld());
            if (id == -1) {
                id = channels.newChannel();
                PowerCellCardItem.setId(stack, id);
            }
            this.networkId = id;
            PowerCellNetwork.Network network = this.getNetwork();
            network.add(this.getWorld(), this.getGlobalPos(), this.isAdvanced(), this.isSimple());
            network.receiveEnergy(this.energy);
            channels.save();
        } else {
            this.networkId = id;
        }
        this.markDirty();
    }

    private boolean isAdvanced() {
        return PowerCellBlock.isAdvanced(this.getWorld().getBlockState(this.getPos()).getBlock());
    }

    private boolean isSimple() {
        return PowerCellBlock.isSimple(this.getWorld().getBlockState(this.getPos()).getBlock());
    }

    private boolean isCreative() {
        return PowerCellBlock.isCreative(this.getWorld().getBlockState(this.getPos()).getBlock());
    }

    private int getPowerFactor() {
        if (this.isSimple()) {
            return 1;
        }
        return this.isAdvanced() ? PowerCellConfiguration.advancedFactor.get() * PowerCellConfiguration.simpleFactor.get() : PowerCellConfiguration.simpleFactor.get();
    }

    public int getEnergy() {
        return this.energy;
    }

    public GlobalCoordinate getGlobalPos() {
        return new GlobalCoordinate(this.getPos(), this.getWorld().provider.getDimension());
    }

    public ItemStack removeStackFromSlot(int index) {
        if (index == 0) {
            this.handleCardRemoval();
        }
        return this.inventoryHelper.removeStackFromSlot(index);
    }

    public ItemStack decrStackSize(int index, int count) {
        if (index == 0 && this.inventoryHelper.containsItem(index) && count >= this.inventoryHelper.getStackInSlot(index).getCount()) {
            this.handleCardRemoval();
        }
        return this.inventoryHelper.decrStackSize(index, count);
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        if (index == 0) {
            this.handleCardRemoval();
        }
        this.inventoryHelper.setInventorySlotContents(this.getInventoryStackLimit(), index, stack);
        if (index == 0 && this.inventoryHelper.containsItem(index)) {
            this.handleCardInsertion();
        } else if (index == 1 && this.inventoryHelper.containsItem(index)) {
            PowerCellCardItem.setId(this.inventoryHelper.getStackInSlot(index), this.networkId);
        }
    }

    public long getTotalExtracted() {
        return this.totalExtracted;
    }

    public long getTotalInserted() {
        return this.totalInserted;
    }

    public void resetTotalExtracted() {
        this.totalExtracted = 0L;
    }

    public void resetTotalInserted() {
        this.totalInserted = 0L;
    }

    public int receiveEnergyFacing(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.modes[from.ordinal()] != Mode.MODE_INPUT) {
            return 0;
        }
        maxReceive = Math.min(maxReceive, this.getRfPerTickPerSide());
        int networkId = this.getNetworkId();
        int received = networkId == -1 ? this.receiveEnergyLocal(maxReceive, simulate) : this.receiveEnergyMulti(maxReceive, simulate);
        if (!simulate) {
            this.totalInserted += (long)received;
            this.powerIn += received;
            this.markDirty();
        }
        return received;
    }

    private int receiveEnergyMulti(int maxReceive, boolean simulate) {
        if (this.getWorld().isRemote) {
            return 0;
        }
        PowerCellNetwork.Network network = this.getNetwork();
        int totEnergy = network.calculateMaximumEnergy();
        int maxInsert = Math.min(totEnergy - network.getEnergy(), maxReceive);
        if (maxInsert > 0 && !simulate) {
            maxInsert = network.receiveEnergy(maxInsert);
            PowerCellNetwork.getChannels(this.getWorld()).save();
        }
        return this.isCreative() ? maxReceive : maxInsert;
    }

    private int receiveEnergyLocal(int maxReceive, boolean simulate) {
        long capacityL = (long)PowerCellConfiguration.rfPerNormalCell.get() * (long)this.getPowerFactor() / (long)PowerCellConfiguration.simpleFactor.get();
        int capacity = capacityL > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)capacityL;
        int maxInsert = Math.min(capacity - this.energy, maxReceive);
        if (maxInsert > 0 && !simulate) {
            this.energy += maxInsert;
            this.markDirty();
        }
        return this.isCreative() ? maxReceive : maxInsert;
    }

    private int extractEnergyInternal(int maxExtract, boolean simulate, int maximum) {
        int networkId = this.getNetworkId();
        int extracted = networkId == -1 ? this.extractEnergyLocal(maxExtract, simulate, maximum) : this.extractEnergyMulti(maxExtract, simulate, maximum);
        if (!simulate) {
            this.totalExtracted += (long)extracted;
            this.powerOut += extracted;
            this.markDirty();
        }
        return extracted;
    }

    private int extractEnergyMulti(int maxExtract, boolean simulate, int maximum) {
        if (this.getWorld().isRemote) {
            return 0;
        }
        PowerCellNetwork.Network network = this.getNetwork();
        if (maxExtract > maximum) {
            maxExtract = maximum;
        }
        if (!simulate) {
            maxExtract = network.extractEnergy(maxExtract);
            PowerCellNetwork.getChannels(this.getWorld()).save();
        }
        return maxExtract;
    }

    private int extractEnergyLocal(int maxExtract, boolean simulate, int maximum) {
        if (maxExtract > this.energy) {
            maxExtract = this.energy;
        }
        if (maxExtract > maximum) {
            maxExtract = maximum;
        }
        if (!simulate) {
            this.energy -= maxExtract;
            this.markDirty();
        }
        return maxExtract;
    }

    public int getEnergyStored() {
        if (this.world.isRemote) {
            return 0;
        }
        int networkId = this.getNetworkId();
        if (networkId == -1) {
            return this.energy;
        }
        PowerCellNetwork.Network network = this.getNetwork();
        return network.getEnergy();
    }

    public int getMaxEnergyStored() {
        if (this.world.isRemote) {
            return 0;
        }
        int networkId = this.getNetworkId();
        if (networkId == -1) {
            return PowerCellConfiguration.rfPerNormalCell.get() * this.getPowerFactor() / PowerCellConfiguration.simpleFactor.get();
        }
        PowerCellNetwork.Network network = this.getNetwork();
        return network.calculateMaximumEnergy();
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        if (index == 0 && stack.getItem() != PowerCellSetup.powerCellCardItem) {
            return false;
        }
        return index != 1 || stack.getItem() == PowerCellSetup.powerCellCardItem;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void setAllOutput() {
        for (EnumFacing facing : EnumFacing.VALUES) {
            this.modes[facing.ordinal()] = Mode.MODE_OUTPUT;
        }
        this.markDirtyClient();
    }

    private void setAllInput() {
        for (EnumFacing facing : EnumFacing.VALUES) {
            this.modes[facing.ordinal()] = Mode.MODE_INPUT;
        }
        this.markDirtyClient();
    }

    private void setAllNone() {
        for (EnumFacing facing : EnumFacing.VALUES) {
            this.modes[facing.ordinal()] = Mode.MODE_NONE;
        }
        this.markDirtyClient();
    }

    public void selectBlock(EntityPlayer player, BlockPos pos) {
        PowerCellTileEntity.dumpNetwork(player, this);
    }

    public static void dumpNetwork(EntityPlayer player, PowerCellTileEntity powerCellTileEntity) {
        PowerCellNetwork.Network network = powerCellTileEntity.getNetwork();
        Set<GlobalCoordinate> blocks = network.getBlocks();
        blocks.forEach(b -> {
            String msg;
            World w = TeleportationTools.getWorldForDimension((int)b.getDimension());
            if (w == null) {
                msg = "dimension missing!";
            } else {
                Block block = w.getBlockState(b.getCoordinate()).getBlock();
                msg = block == PowerCellSetup.powerCellBlock ? "normal" : (block == PowerCellSetup.advancedPowerCellBlock ? "advanced" : (block == PowerCellSetup.creativePowerCellBlock ? "creative" : "not a powercell!"));
                TileEntity te = w.getTileEntity(b.getCoordinate());
                if (te instanceof PowerCellTileEntity) {
                    PowerCellTileEntity power = (PowerCellTileEntity)te;
                    msg = msg + " (+:" + power.getTotalInserted() + ", -:" + power.getTotalExtracted() + ")";
                }
            }
            Logging.message((EntityPlayer)player, (String)("Block: " + BlockPosTools.toString((BlockPos)b.getCoordinate()) + " (" + b.getDimension() + "): " + msg));
        });
    }

    public TypedMap executeWithResult(String command, TypedMap args) {
        TypedMap rc = super.executeWithResult(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_GET_INFO.equals(command)) {
            if (this.networkId == -1) {
                return TypedMap.builder().put(PARAM_ENERGY, (Object)this.getEnergy()).put(PARAM_BLOCKS, (Object)1).put(PARAM_SIMPLEBLOCKS, (Object)(this.isSimple() ? 1 : 0)).put(PARAM_ADVANCEDBLOCKS, (Object)(this.isAdvanced() ? 1 : 0)).put(PARAM_TOTAL_INSERTED, (Object)this.getTotalInserted()).put(PARAM_TOTAL_EXTRACTED, (Object)this.getTotalExtracted()).put(PARAM_RFPERTICK, (Object)this.getRfPerTickPerSide()).put(PARAM_COSTFACTOR, (Object)1.0).build();
            }
            PowerCellNetwork.Network network = this.getNetwork();
            return TypedMap.builder().put(PARAM_ENERGY, (Object)network.getEnergy()).put(PARAM_BLOCKS, (Object)network.getBlockCount()).put(PARAM_SIMPLEBLOCKS, (Object)network.getSimpleBlockCount()).put(PARAM_ADVANCEDBLOCKS, (Object)network.getAdvancedBlockCount()).put(PARAM_TOTAL_INSERTED, (Object)this.getTotalInserted()).put(PARAM_TOTAL_EXTRACTED, (Object)this.getTotalExtracted()).put(PARAM_RFPERTICK, (Object)this.getRfPerTickPerSide()).put(PARAM_COSTFACTOR, (Object)this.getCostFactor()).build();
        }
        return null;
    }

    public boolean receiveDataFromServer(String command, @Nonnull TypedMap result) {
        boolean rc = super.receiveDataFromServer(command, result);
        if (rc) {
            return true;
        }
        if (CMD_GET_INFO.equals(command)) {
            tooltipEnergy = (Integer)result.get(PARAM_ENERGY);
            tooltipBlocks = (Integer)result.get(PARAM_BLOCKS);
            tooltipSimpleBlocks = (Integer)result.get(PARAM_SIMPLEBLOCKS);
            tooltipAdvancedBlocks = (Integer)result.get(PARAM_ADVANCEDBLOCKS);
            tooltipInserted = (Long)result.get(PARAM_TOTAL_INSERTED);
            tooltipExtracted = (Long)result.get(PARAM_TOTAL_EXTRACTED);
            tooltipRfPerTick = (Integer)result.get(PARAM_RFPERTICK);
            tooltipCostFactor = ((Double)result.get(PARAM_COSTFACTOR)).floatValue();
            return true;
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY || capability == EnergyTools.TESLA_HOLDER || capability == EnergyTools.TESLA_CONSUMER && facing != null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY || capability == EnergyTools.TESLA_HOLDER || capability == EnergyTools.TESLA_CONSUMER && facing != null) {
            if (facing == null) {
                if (this.nullHandler == null) {
                    this.nullHandler = new NullHandler();
                }
                return (T)this.nullHandler;
            }
            if (this.sidedHandlers[facing.ordinal()] == null) {
                this.sidedHandlers[facing.ordinal()] = new SidedHandler(facing);
            }
            return (T)this.sidedHandlers[facing.ordinal()];
        }
        return (T)super.getCapability(capability, facing);
    }

    public static enum Mode implements IStringSerializable
    {
        MODE_NONE("none"),
        MODE_INPUT("input"),
        MODE_OUTPUT("output");

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla")
    private class NullHandler
    implements IEnergyStorage,
    ITeslaHolder {
        private NullHandler() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return PowerCellTileEntity.this.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return PowerCellTileEntity.this.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return false;
        }

        @Optional.Method(modid="tesla")
        public long getStoredPower() {
            return PowerCellTileEntity.this.getEnergyStored();
        }

        @Optional.Method(modid="tesla")
        public long getCapacity() {
            return PowerCellTileEntity.this.getMaxEnergyStored();
        }
    }

    @Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla")})
    private class SidedHandler
    implements IEnergyStorage,
    ITeslaConsumer,
    ITeslaHolder {
        private final EnumFacing facing;

        private SidedHandler(EnumFacing facing) {
            this.facing = facing;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return PowerCellTileEntity.this.receiveEnergyFacing(this.facing, maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return PowerCellTileEntity.this.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return PowerCellTileEntity.this.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        @Optional.Method(modid="tesla")
        public long getStoredPower() {
            return PowerCellTileEntity.this.getEnergyStored();
        }

        @Optional.Method(modid="tesla")
        public long getCapacity() {
            return PowerCellTileEntity.this.getMaxEnergyStored();
        }

        @Optional.Method(modid="tesla")
        public long givePower(long power, boolean simulated) {
            return PowerCellTileEntity.this.receiveEnergyFacing(this.facing, EnergyTools.unsignedClampToInt((long)power), simulated);
        }
    }
}

