/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.RFTools;
import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.IModuleProvider;
import mcjty.rftools.blocks.screens.CreativeScreenTileEntity;
import mcjty.rftools.blocks.screens.ScreenBlock;
import mcjty.rftools.blocks.screens.ScreenContainer;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import mcjty.rftools.blocks.screens.modulesclient.helper.ScreenModuleGuiBuilder;
import mcjty.rftools.blocks.screens.network.PacketModuleUpdate;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.client.gui.Gui;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiScreen
extends GenericGuiContainer<ScreenTileEntity> {
    public static final int SCREEN_WIDTH = 256;
    public static final int SCREEN_HEIGHT = 224;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/screen.png");
    private Panel toplevel;
    private ToggleButton[] buttons = new ToggleButton[11];
    private Panel[] modulePanels = new Panel[11];
    private IClientScreenModule<?>[] clientScreenModules = new IClientScreenModule[11];
    private ToggleButton bright;
    private ChoiceLabel trueType;
    private int selected = -1;

    public GuiScreen(CreativeScreenTileEntity te, ScreenContainer container) {
        this((ScreenTileEntity)te, container);
    }

    public GuiScreen(ScreenTileEntity screenTileEntity, ScreenContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)screenTileEntity, (Container)container, GuiProxy.GUI_MANUAL_MAIN, "screens");
        this.xSize = 256;
        this.ySize = 224;
    }

    public void initGui() {
        super.initGui();
        this.toplevel = ((Panel)new Panel(this.mc, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        for (int i = 0; i < 11; ++i) {
            this.buttons[i] = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(30, 7 + i * 18 + 1, 40, 16))).setEnabled(false)).setTooltips(new String[]{"Open the gui for this", "module"});
            int finalI = i;
            this.buttons[i].addButtonEvent(parent -> this.selectPanel(finalI));
            this.toplevel.addChild((Widget)this.buttons[i]);
            this.modulePanels[i] = null;
            this.clientScreenModules[i] = null;
        }
        this.bright = (ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, (Gui)this).setName("bright")).setText("Bright")).setCheckMarker(true).setTooltips(new String[]{"Toggle full brightness"})).setLayoutHint(85, 123, 55, 14);
        this.toplevel.addChild((Widget)this.bright);
        this.toplevel.addChild((Widget)((Label)((Label)new Label(this.mc, (Gui)this).setText("Font:")).setHorizontalAlignment(HorizontalAlignment.ALIGN_RIGHT)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(144, 123, 30, 14)));
        this.trueType = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.mc, (Gui)this).addChoices(new String[]{"Default", "Truetype", "Vanilla"}).setTooltips(new String[]{"Set truetype font mode", "for the screen"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(179, 123, 68, 14));
        int trueTypeMode = ((ScreenTileEntity)this.tileEntity).getTrueTypeMode();
        this.trueType.setChoice(trueTypeMode == 0 ? "Default" : (trueTypeMode == -1 ? "Vanilla" : "Truetype"));
        this.trueType.addChoiceEvent((a, b) -> this.sendServerCommand(RFToolsMessages.INSTANCE, "screen.setTruetype", TypedMap.builder().put(ScreenTileEntity.PARAM_TRUETYPE, (Object)this.getCurrentTruetypeChoice()).build()));
        this.toplevel.addChild((Widget)this.trueType);
        this.toplevel.setBounds(new Rectangle(this.guiLeft, this.guiTop, this.xSize, this.ySize));
        this.window = new Window((net.minecraft.client.gui.GuiScreen)this, (AbstractContainerWidget)this.toplevel);
        this.window.bind(RFToolsMessages.INSTANCE, "bright", (GenericTileEntity)((ScreenTileEntity)this.tileEntity), ScreenTileEntity.VALUE_BRIGHT.getName());
        Keyboard.enableRepeatEvents((boolean)true);
        this.selected = -1;
    }

    private int getCurrentTruetypeChoice() {
        String c = this.trueType.getCurrentChoice();
        if ("Default".equals(c)) {
            return 0;
        }
        if ("Truetype".equals(c)) {
            return 1;
        }
        return -1;
    }

    private void selectPanel(int i) {
        this.selected = this.buttons[i].isPressed() ? i : -1;
    }

    private void refreshButtons() {
        for (int i = 0; i < 11; ++i) {
            ItemStack slot = ((ScreenTileEntity)this.tileEntity).getStackInSlot(i);
            if (!slot.isEmpty() && ScreenBlock.hasModuleProvider(slot)) {
                IModuleProvider moduleProvider = ScreenBlock.getModuleProvider(slot);
                Class<IClientScreenModule<?>> clientScreenModuleClass = moduleProvider.getClientScreenModule();
                if (!clientScreenModuleClass.isInstance(this.clientScreenModules[i])) {
                    this.installModuleGui(i, slot, moduleProvider, clientScreenModuleClass);
                }
            } else {
                this.uninstallModuleGui(i);
            }
            if (this.modulePanels[i] == null) continue;
            this.modulePanels[i].setVisible(this.selected == i);
            this.buttons[i].setPressed(this.selected == i);
        }
    }

    private void uninstallModuleGui(int i) {
        this.buttons[i].setEnabled(false);
        this.buttons[i].setPressed(false);
        this.buttons[i].setText("");
        this.clientScreenModules[i] = null;
        this.toplevel.removeChild((Widget)this.modulePanels[i]);
        this.modulePanels[i] = null;
        if (this.selected == i) {
            this.selected = -1;
        }
    }

    private void installModuleGui(int i, ItemStack slot, IModuleProvider moduleProvider, Class<? extends IClientScreenModule<?>> clientScreenModuleClass) {
        this.buttons[i].setEnabled(true);
        this.toplevel.removeChild((Widget)this.modulePanels[i]);
        try {
            IClientScreenModule<?> clientScreenModule = clientScreenModuleClass.newInstance();
            this.clientScreenModules[i] = clientScreenModule;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        NBTTagCompound tagCompound = slot.getTagCompound();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        NBTTagCompound finalTagCompound = tagCompound;
        ScreenModuleGuiBuilder guiBuilder = new ScreenModuleGuiBuilder(this.mc, (Gui)this, tagCompound, () -> {
            slot.setTagCompound(finalTagCompound);
            ((ScreenTileEntity)this.tileEntity).setInventorySlotContents(i, slot);
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketModuleUpdate(((ScreenTileEntity)this.tileEntity).getPos(), i, finalTagCompound));
        });
        moduleProvider.createGui(guiBuilder);
        this.modulePanels[i] = guiBuilder.build();
        this.modulePanels[i].setLayoutHint(80, 8, 170, 114);
        ((Panel)this.modulePanels[i].setFilledRectThickness(-2)).setFilledBackground(-7631989);
        this.toplevel.addChild((Widget)this.modulePanels[i]);
        this.buttons[i].setText(moduleProvider.getName());
    }

    protected void drawGuiContainerBackgroundLayer(float v, int i, int i2) {
        this.refreshButtons();
        this.drawWindow();
    }
}

