/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import java.util.List;
import java.util.Random;
import mcjty.lib.McJtyLib;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.GenericBlock;
import mcjty.lib.container.EmptyContainer;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.screens.ScreenBlock;
import mcjty.rftools.blocks.screens.ScreenHitTileEntity;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ScreenHitBlock
extends GenericBlock<ScreenHitTileEntity, EmptyContainer> {
    public static final AxisAlignedBB BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
    public static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    public static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);

    public ScreenHitBlock() {
        super((ModBase)RFTools.instance, Material.GLASS, ScreenHitTileEntity.class, EmptyContainer::new, null, "screen_hitblock", false);
        this.setBlockUnbreakable();
        this.setResistance(6000000.0f);
    }

    public ItemStack getItem(World worldIn, BlockPos pos, IBlockState state) {
        BlockPos screenPos = this.getScreenBlockPos(worldIn, pos);
        if (screenPos == null) {
            return ItemStack.EMPTY;
        }
        IBlockState screenState = worldIn.getBlockState(screenPos);
        return screenState.getBlock().getItem(worldIn, screenPos, screenState);
    }

    public int getGuiID() {
        return -1;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        BlockPos pos = data.getPos();
        ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.getTileEntity(pos);
        int dx = screenHitTileEntity.getDx();
        int dy = screenHitTileEntity.getDy();
        int dz = screenHitTileEntity.getDz();
        Block block = world.getBlockState(pos.add(dx, dy, dz)).getBlock();
        if (block instanceof ScreenBlock) {
            ((ScreenBlock)block).addProbeInfoScreen(mode, probeInfo, player, world, pos.add(dx, dy, dz));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te;
        super.getWailaBody(itemStack, currenttip, accessor, config);
        BlockPos pos = accessor.getPosition();
        World world = accessor.getWorld();
        ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.getTileEntity(pos);
        int dx = screenHitTileEntity.getDx();
        int dy = screenHitTileEntity.getDy();
        int dz = screenHitTileEntity.getDz();
        BlockPos rpos = pos.add(dx, dy, dz);
        IBlockState state = world.getBlockState(rpos);
        Block block = state.getBlock();
        if (block instanceof ScreenBlock && (te = world.getTileEntity(rpos)) instanceof ScreenTileEntity) {
            RayTraceResult mouseOver = accessor.getMOP();
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)te;
            ScreenTileEntity.ModuleRaytraceResult hit = screenTileEntity.getHitModule(mouseOver.hitVec.x - (double)pos.getX() - (double)dx, mouseOver.hitVec.y - (double)pos.getY() - (double)dy, mouseOver.hitVec.z - (double)pos.getZ() - (double)dz, mouseOver.sideHit, (EnumFacing)state.getValue((IProperty)ScreenBlock.HORIZONTAL_FACING));
            ((ScreenBlock)block).getWailaBodyScreen(currenttip, accessor.getPlayer(), screenTileEntity, hit);
        }
        return currenttip;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new ScreenHitTileEntity();
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new ScreenHitTileEntity();
    }

    public void initModel() {
        McJtyLib.proxy.initTESRItemStack(Item.getItemFromBlock((Block)this), 0, ScreenTileEntity.class);
        super.initModel();
    }

    public void onBlockClicked(World world, BlockPos pos, EntityPlayer playerIn) {
        if (world.isRemote) {
            int dz;
            int dy;
            ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.getTileEntity(pos);
            int dx = screenHitTileEntity.getDx();
            IBlockState state = world.getBlockState(pos.add(dx, dy = screenHitTileEntity.getDy(), dz = screenHitTileEntity.getDz()));
            Block block = state.getBlock();
            if (block != ScreenSetup.screenBlock && block != ScreenSetup.creativeScreenBlock) {
                return;
            }
            RayTraceResult mouseOver = Minecraft.getMinecraft().objectMouseOver;
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.getTileEntity(pos.add(dx, dy, dz));
            screenTileEntity.hitScreenClient(mouseOver.hitVec.x - (double)pos.getX() - (double)dx, mouseOver.hitVec.y - (double)pos.getY() - (double)dy, mouseOver.hitVec.z - (double)pos.getZ() - (double)dz, mouseOver.sideHit, (EnumFacing)state.getValue((IProperty)ScreenBlock.HORIZONTAL_FACING));
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.activate(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if ((pos = this.getScreenBlockPos(world, pos)) == null) {
            return false;
        }
        Block block = world.getBlockState(pos).getBlock();
        return ((ScreenBlock)block).activate(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public BlockPos getScreenBlockPos(World world, BlockPos pos) {
        int dz;
        int dy;
        ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.getTileEntity(pos);
        int dx = screenHitTileEntity.getDx();
        Block block = world.getBlockState(pos = pos.add(dx, dy = screenHitTileEntity.getDy(), dz = screenHitTileEntity.getDz())).getBlock();
        if (block != ScreenSetup.screenBlock && block != ScreenSetup.creativeScreenBlock) {
            return null;
        }
        return pos;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.getValue((IProperty)BaseBlock.FACING);
        if (facing == EnumFacing.NORTH) {
            return NORTH_AABB;
        }
        if (facing == EnumFacing.SOUTH) {
            return SOUTH_AABB;
        }
        if (facing == EnumFacing.WEST) {
            return WEST_AABB;
        }
        if (facing == EnumFacing.EAST) {
            return EAST_AABB;
        }
        if (facing == EnumFacing.UP) {
            return UP_AABB;
        }
        if (facing == EnumFacing.DOWN) {
            return DOWN_AABB;
        }
        return BLOCK_AABB;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isBlockNormalCube(IBlockState state) {
        return false;
    }

    public boolean isFullBlock(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public int quantityDropped(Random random) {
        return 0;
    }

    public EnumPushReaction getPushReaction(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }
}

