/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;

public class ScreenHitTileEntity
extends GenericTileEntity {
    private int dx;
    private int dy;
    private int dz;

    public void setRelativeLocation(int dx, int dy, int dz) {
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.markDirty();
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        this.getWorld().notifyBlockUpdate(this.getPos(), state, state, 3);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.dx = tagCompound.getInteger("dx");
        this.dy = tagCompound.getInteger("dy");
        this.dz = tagCompound.getInteger("dz");
    }

    public int getDx() {
        return this.dx;
    }

    public int getDy() {
        return this.dy;
    }

    public int getDz() {
        return this.dz;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setInteger("dx", this.dx);
        tagCompound.setInteger("dy", this.dy);
        tagCompound.setInteger("dz", this.dz);
        return tagCompound;
    }
}

