/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.IModuleProvider;
import mcjty.rftools.api.screens.IScreenDataHelper;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.api.screens.IScreenModuleUpdater;
import mcjty.rftools.api.screens.ITooltipInfo;
import mcjty.rftools.api.screens.data.IModuleData;
import mcjty.rftools.api.screens.data.IModuleDataBoolean;
import mcjty.rftools.api.screens.data.IModuleDataContents;
import mcjty.rftools.api.screens.data.IModuleDataInteger;
import mcjty.rftools.api.screens.data.IModuleDataString;
import mcjty.rftools.blocks.screens.NbtSanitizerModuleGuiBuilder;
import mcjty.rftools.blocks.screens.ScreenBlock;
import mcjty.rftools.blocks.screens.ScreenContainer;
import mcjty.rftools.blocks.screens.data.ModuleDataBoolean;
import mcjty.rftools.blocks.screens.data.ModuleDataInteger;
import mcjty.rftools.blocks.screens.data.ModuleDataString;
import mcjty.rftools.blocks.screens.modules.ComputerScreenModule;
import mcjty.rftools.blocks.screens.modules.ScreenModuleHelper;
import mcjty.rftools.blocks.screens.modulesclient.TextClientScreenModule;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ScreenTileEntity
extends GenericTileEntity
implements ITickable,
DefaultSidedInventory {
    public static final String CMD_SCREEN_INFO = "getScreenInfo";
    public static final Key<List<String>> PARAM_INFO = new Key("info", Type.STRING_LIST);
    public static List<String> infoReceived = Collections.emptyList();
    public static final String CMD_CLICK = "screen.click";
    public static final String CMD_HOVER = "screen.hover";
    public static final String CMD_SETTRUETYPE = "screen.setTruetype";
    public static final Key<Integer> PARAM_X = new Key("x", Type.INTEGER);
    public static final Key<Integer> PARAM_Y = new Key("y", Type.INTEGER);
    public static final Key<Integer> PARAM_MODULE = new Key("module", Type.INTEGER);
    public static final Key<Integer> PARAM_TRUETYPE = new Key("truetype", Type.INTEGER);
    public static Key<Boolean> VALUE_BRIGHT = new Key("bright", Type.BOOLEAN);
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, ScreenContainer.factory, 11);
    public static Map<GlobalCoordinate, Map<Integer, IModuleData>> screenData = new HashMap<GlobalCoordinate, Map<Integer, IModuleData>>();
    private List<IClientScreenModule<?>> clientScreenModules = null;
    private final Map<String, List<ComputerScreenModule>> computerModules = new HashMap<String, List<ComputerScreenModule>>();
    private boolean needsServerData = false;
    private boolean showHelp = true;
    private boolean powerOn = false;
    private boolean connected = false;
    private int size = 0;
    private boolean transparent = false;
    private int color = 0;
    private boolean bright = false;
    private int trueTypeMode = 0;
    private int hoveringModule = -1;
    private int hoveringX = -1;
    private int hoveringY = -1;
    public static final int SIZE_NORMAL = 0;
    public static final int SIZE_LARGE = 1;
    public static final int SIZE_HUGE = 2;
    private List<IScreenModule<?>> screenModules = null;
    private List<ActivatedModule> clickedModules = new ArrayList<ActivatedModule>();
    private int totalRfPerTick = 0;
    private boolean controllerNeededInCreative = false;
    public long lastTime = 0L;
    private static List<IClientScreenModule<?>> helpingScreenModules = null;
    private IScreenDataHelper screenDataHelper = new IScreenDataHelper(){

        @Override
        public IModuleDataInteger createInteger(int i) {
            return new ModuleDataInteger(i);
        }

        @Override
        public IModuleDataBoolean createBoolean(boolean b) {
            return new ModuleDataBoolean(b);
        }

        @Override
        public IModuleDataString createString(String b) {
            return new ModuleDataString(b);
        }

        @Override
        public IModuleDataContents createContents(long contents, long maxContents, long lastPerTick) {
            return new ScreenModuleHelper.ModuleDataContents(contents, maxContents, lastPerTick);
        }
    };

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_BRIGHT, this::isBright, this::setBright)};
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int xCoord = this.getPos().getX();
        int yCoord = this.getPos().getY();
        int zCoord = this.getPos().getZ();
        return new AxisAlignedBB((double)(xCoord - this.size - 1), (double)(yCoord - this.size - 1), (double)(zCoord - this.size - 1), (double)(xCoord + this.size + 1), (double)(yCoord + this.size + 1), (double)(zCoord + this.size + 1));
    }

    public void update() {
        if (this.getWorld().isRemote) {
            this.checkStateClient();
        } else {
            this.checkStateServer();
        }
    }

    private void checkStateClient() {
        if (this.clickedModules.isEmpty()) {
            return;
        }
        ArrayList<ActivatedModule> newClickedModules = new ArrayList<ActivatedModule>();
        for (ActivatedModule cm : this.clickedModules) {
            cm.ticks--;
            if (cm.ticks > 0) {
                newClickedModules.add(cm);
                continue;
            }
            List<IClientScreenModule<?>> modules = this.getClientScreenModules();
            if (cm.module >= modules.size()) continue;
            modules.get(cm.module).mouseClick(this.getWorld(), cm.x, cm.y, false);
        }
        this.clickedModules = newClickedModules;
    }

    private void checkStateServer() {
        if (this.clickedModules.isEmpty()) {
            return;
        }
        ArrayList<ActivatedModule> newClickedModules = new ArrayList<ActivatedModule>();
        for (ActivatedModule cm : this.clickedModules) {
            NBTTagCompound newCompound;
            cm.ticks--;
            if (cm.ticks > 0) {
                newClickedModules.add(cm);
                continue;
            }
            List<IScreenModule<?>> modules = this.getScreenModules();
            if (cm.module >= modules.size()) continue;
            ItemStack itemStack = this.inventoryHelper.getStackInSlot(cm.module);
            IScreenModule<?> module = modules.get(cm.module);
            module.mouseClick(this.getWorld(), cm.x, cm.y, false, null);
            if (!(module instanceof IScreenModuleUpdater) || (newCompound = ((IScreenModuleUpdater)((Object)module)).update(itemStack.getTagCompound(), this.getWorld(), null)) == null) continue;
            itemStack.setTagCompound(newCompound);
            this.markDirtyClient();
        }
        this.clickedModules = newClickedModules;
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return ScreenContainer.factory.getAccessibleSlots();
    }

    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        return ScreenContainer.factory.isOutputSlot(index);
    }

    public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
        return ScreenContainer.factory.isInputSlot(index);
    }

    public int getSizeInventory() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack getStackInSlot(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack decrStackSize(int index, int amount) {
        this.resetModules();
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    private void resetModules() {
        this.clientScreenModules = null;
        this.screenModules = null;
        this.clickedModules.clear();
        this.showHelp = true;
        this.computerModules.clear();
    }

    private boolean isActivated(int index) {
        for (ActivatedModule module : this.clickedModules) {
            if (module.module != index) continue;
            return true;
        }
        return false;
    }

    public void focusModuleClient(double hitX, double hitY, double hitZ, EnumFacing side, EnumFacing horizontalFacing) {
        int module;
        int y;
        int x;
        ModuleRaytraceResult result = this.getHitModule(hitX, hitY, hitZ, side, horizontalFacing);
        if (result == null) {
            x = -1;
            y = -1;
            module = -1;
        } else {
            x = result.getX();
            y = result.getY() - result.getCurrenty();
            module = result.getModuleIndex();
        }
        if (x != this.hoveringX || y != this.hoveringY || module != this.hoveringModule) {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketServerCommandTyped(this.getPos(), CMD_HOVER, TypedMap.builder().put(PARAM_X, (Object)x).put(PARAM_Y, (Object)y).put(PARAM_MODULE, (Object)module).build()));
            this.hoveringX = x;
            this.hoveringY = y;
            this.hoveringModule = module;
        }
    }

    public void hitScreenClient(double hitX, double hitY, double hitZ, EnumFacing side, EnumFacing horizontalFacing) {
        ModuleRaytraceResult result = this.getHitModule(hitX, hitY, hitZ, side, horizontalFacing);
        if (result == null) {
            return;
        }
        List<IClientScreenModule<?>> modules = this.getClientScreenModules();
        int module = result.getModuleIndex();
        if (this.isActivated(module)) {
            return;
        }
        modules.get(module).mouseClick(this.getWorld(), result.getX(), result.getY() - result.getCurrenty(), true);
        this.clickedModules.add(new ActivatedModule(module, 3, result.getX(), result.getY()));
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketServerCommandTyped(this.getPos(), CMD_CLICK, TypedMap.builder().put(PARAM_X, (Object)result.getX()).put(PARAM_Y, (Object)(result.getY() - result.getCurrenty())).put(PARAM_MODULE, (Object)module).build()));
    }

    public ModuleRaytraceResult getHitModule(double hitX, double hitY, double hitZ, EnumFacing side, EnumFacing horizontalFacing) {
        float factor = (float)this.size + 1.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        switch (side) {
            case NORTH: {
                dx = (float)((1.0 - hitX) / (double)factor);
                dy = (float)((1.0 - hitY) / (double)factor);
                break;
            }
            case SOUTH: {
                dx = (float)(hitX / (double)factor);
                dy = (float)((1.0 - hitY) / (double)factor);
                break;
            }
            case WEST: {
                dx = (float)(hitZ / (double)factor);
                dy = (float)((1.0 - hitY) / (double)factor);
                break;
            }
            case EAST: {
                dx = (float)((1.0 - hitZ) / (double)factor);
                dy = (float)((1.0 - hitY) / (double)factor);
                break;
            }
            case UP: {
                switch (horizontalFacing) {
                    case NORTH: {
                        dx = (float)((1.0 - hitX) / (double)factor);
                        dy = (float)((1.0 - hitZ) / (double)factor);
                        break;
                    }
                    case SOUTH: {
                        dx = (float)(hitX / (double)factor);
                        dy = (float)(hitZ / (double)factor);
                        break;
                    }
                    case WEST: {
                        dx = (float)(hitZ / (double)factor);
                        dy = (float)((1.0 - hitX) / (double)factor);
                        break;
                    }
                    case EAST: {
                        dx = (float)((1.0 - hitZ) / (double)factor);
                        dy = (float)(hitX / (double)factor);
                    }
                }
                break;
            }
            case DOWN: {
                switch (horizontalFacing) {
                    case NORTH: {
                        dx = (float)((1.0 - hitX) / (double)factor);
                        dy = (float)(hitZ / (double)factor);
                        break;
                    }
                    case SOUTH: {
                        dx = (float)(hitX / (double)factor);
                        dy = (float)((1.0 - hitZ) / (double)factor);
                        break;
                    }
                    case WEST: {
                        dx = (float)(hitZ / (double)factor);
                        dy = (float)(hitX / (double)factor);
                        break;
                    }
                    case EAST: {
                        dx = (float)((1.0 - hitZ) / (double)factor);
                        dy = (float)((1.0 - hitX) / (double)factor);
                    }
                }
                break;
            }
            default: {
                return null;
            }
        }
        int x = (int)(dx * 128.0f);
        int y = (int)(dy * 128.0f);
        int currenty = 7;
        int moduleIndex = 0;
        List<IClientScreenModule<?>> clientScreenModules = this.getClientScreenModules();
        for (IClientScreenModule<?> module : clientScreenModules) {
            int height;
            if (module != null && currenty + (height = module.getHeight()) <= 124) {
                if (currenty <= y && y < currenty + height) break;
                currenty += height;
            }
            ++moduleIndex;
        }
        if (moduleIndex >= clientScreenModules.size()) {
            return null;
        }
        ModuleRaytraceResult result = new ModuleRaytraceResult(moduleIndex, x, y, currenty);
        return result;
    }

    private void hitScreenServer(EntityPlayer player, int x, int y, int module) {
        List<IScreenModule<?>> screenModules = this.getScreenModules();
        IScreenModule<?> screenModule = screenModules.get(module);
        if (screenModule != null) {
            NBTTagCompound newCompound;
            ItemStack itemStack = this.inventoryHelper.getStackInSlot(module);
            screenModule.mouseClick(this.getWorld(), x, y, true, player);
            if (screenModule instanceof IScreenModuleUpdater && (newCompound = ((IScreenModuleUpdater)((Object)screenModule)).update(itemStack.getTagCompound(), this.getWorld(), player)) != null) {
                itemStack.setTagCompound(newCompound);
                this.markDirtyClient();
            }
            this.clickedModules.add(new ActivatedModule(module, 5, x, y));
        }
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.getInventoryStackLimit(), index, stack);
        this.resetModules();
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.powerOn = tagCompound.getBoolean("powerOn");
        this.connected = tagCompound.getBoolean("connected");
        this.totalRfPerTick = tagCompound.getInteger("rfPerTick");
        this.controllerNeededInCreative = tagCompound.getBoolean("controllerNeededInCreative");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.resetModules();
        this.size = tagCompound.hasKey("large") ? (tagCompound.getBoolean("large") ? 1 : 0) : tagCompound.getInteger("size");
        this.transparent = tagCompound.getBoolean("transparent");
        this.color = tagCompound.getInteger("color");
        this.bright = tagCompound.getBoolean("bright");
        this.trueTypeMode = tagCompound.getInteger("truetype");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setBoolean("powerOn", this.powerOn);
        tagCompound.setBoolean("connected", this.connected);
        tagCompound.setInteger("rfPerTick", this.totalRfPerTick);
        tagCompound.setBoolean("controllerNeededInCreative", this.controllerNeededInCreative);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.setInteger("size", this.size);
        tagCompound.setBoolean("transparent", this.transparent);
        tagCompound.setInteger("color", this.color);
        tagCompound.setBoolean("bright", this.bright);
        tagCompound.setInteger("truetype", this.trueTypeMode);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.markDirtyClient();
    }

    public void setSize(int size) {
        this.size = size;
        this.markDirtyClient();
    }

    public boolean isBright() {
        return this.bright;
    }

    public void setBright(boolean bright) {
        this.bright = bright;
        this.markDirtyClient();
    }

    public int getTrueTypeMode() {
        return this.trueTypeMode;
    }

    public void setTrueTypeMode(int trueTypeMode) {
        this.trueTypeMode = trueTypeMode;
        this.markDirtyClient();
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
        this.markDirtyClient();
    }

    public int getSize() {
        return this.size;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setPower(boolean power) {
        if (this.powerOn == power) {
            return;
        }
        this.powerOn = power;
        this.markDirtyClient();
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    public boolean isRenderable() {
        if (this.powerOn) {
            return true;
        }
        if (this.isShowHelp()) {
            return true;
        }
        return this.isCreative();
    }

    protected boolean isCreative() {
        return false;
    }

    public void setConnected(boolean c) {
        if (this.connected == c) {
            return;
        }
        this.connected = c;
        this.markDirtyClient();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void updateModuleData(int slot, NBTTagCompound tagCompound) {
        ItemStack stack = this.inventoryHelper.getStackInSlot(slot);
        IModuleProvider moduleProvider = ScreenBlock.getModuleProvider(stack);
        if (stack.isEmpty() || moduleProvider == null) {
            Logging.logError((String)"PacketModuleUpdate: ItemStack does not have a module provider!");
            return;
        }
        NbtSanitizerModuleGuiBuilder sanitizer = new NbtSanitizerModuleGuiBuilder(this.getWorld(), stack.getTagCompound());
        moduleProvider.createGui(sanitizer);
        stack.setTagCompound(sanitizer.sanitizeNbt(tagCompound));
        this.screenModules = null;
        this.clientScreenModules = null;
        this.computerModules.clear();
        this.markDirty();
    }

    public static List<IClientScreenModule<?>> getHelpingScreenModules() {
        if (helpingScreenModules == null) {
            helpingScreenModules = new ArrayList();
            ScreenTileEntity.addLine("Read me", 0x7799FF, true);
            ScreenTileEntity.addLine("", 0xFFFFFF, false);
            ScreenTileEntity.addLine("Sneak-right click for", 0xFFFFFF, false);
            ScreenTileEntity.addLine("GUI and insertion of", 0xFFFFFF, false);
            ScreenTileEntity.addLine("modules", 0xFFFFFF, false);
            ScreenTileEntity.addLine("", 0xFFFFFF, false);
            ScreenTileEntity.addLine("Use Screen Controller", 0xFFFFFF, false);
            ScreenTileEntity.addLine("to power screens", 0xFFFFFF, false);
            ScreenTileEntity.addLine("remotely", 0xFFFFFF, false);
        }
        return helpingScreenModules;
    }

    private static void addLine(String s, int color, boolean large) {
        TextClientScreenModule t1 = new TextClientScreenModule();
        t1.setLine(s);
        t1.setColor(color);
        t1.setLarge(large);
        helpingScreenModules.add(t1);
    }

    public List<IClientScreenModule<?>> getClientScreenModules() {
        if (this.clientScreenModules == null) {
            this.needsServerData = false;
            this.showHelp = true;
            this.clientScreenModules = new ArrayList();
            for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
                ItemStack itemStack = this.inventoryHelper.getStackInSlot(i);
                if (!itemStack.isEmpty() && ScreenBlock.hasModuleProvider(itemStack)) {
                    IClientScreenModule<?> clientScreenModule;
                    IModuleProvider moduleProvider = ScreenBlock.getModuleProvider(itemStack);
                    try {
                        clientScreenModule = moduleProvider.getClientScreenModule().newInstance();
                    }
                    catch (InstantiationException e) {
                        Logging.logError((String)"Internal error with screen modules!", (Throwable)e);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        Logging.logError((String)"Internal error with screen modules!", (Throwable)e);
                        continue;
                    }
                    clientScreenModule.setupFromNBT(itemStack.getTagCompound(), this.getWorld().provider.getDimension(), this.getPos());
                    this.clientScreenModules.add(clientScreenModule);
                    if (clientScreenModule.needsServerData()) {
                        this.needsServerData = true;
                    }
                    this.showHelp = false;
                    continue;
                }
                this.clientScreenModules.add(null);
            }
        }
        return this.clientScreenModules;
    }

    public boolean isShowHelp() {
        return this.showHelp;
    }

    public boolean isNeedsServerData() {
        return this.needsServerData;
    }

    public int getTotalRfPerTick() {
        if (this.isCreative()) {
            return 0;
        }
        if (this.screenModules == null) {
            this.getScreenModules();
        }
        return this.totalRfPerTick;
    }

    public boolean isControllerNeeded() {
        if (!this.isCreative()) {
            return true;
        }
        if (this.screenModules == null) {
            this.getScreenModules();
        }
        return this.controllerNeededInCreative;
    }

    public List<IScreenModule<?>> getScreenModules() {
        if (this.screenModules == null) {
            this.totalRfPerTick = 0;
            this.controllerNeededInCreative = false;
            this.screenModules = new ArrayList();
            for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
                ItemStack itemStack = this.inventoryHelper.getStackInSlot(i);
                if (!itemStack.isEmpty() && ScreenBlock.hasModuleProvider(itemStack)) {
                    IScreenModule<?> screenModule;
                    IModuleProvider moduleProvider = ScreenBlock.getModuleProvider(itemStack);
                    try {
                        screenModule = moduleProvider.getServerScreenModule().newInstance();
                    }
                    catch (InstantiationException e) {
                        Logging.logError((String)"Internal error with screen modules!", (Throwable)e);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        Logging.logError((String)"Internal error with screen modules!", (Throwable)e);
                        continue;
                    }
                    screenModule.setupFromNBT(itemStack.getTagCompound(), this.getWorld().provider.getDimension(), this.getPos());
                    this.screenModules.add(screenModule);
                    this.totalRfPerTick += screenModule.getRfPerTick();
                    if (screenModule.needsController()) {
                        this.controllerNeededInCreative = true;
                    }
                    if (!(screenModule instanceof ComputerScreenModule)) continue;
                    ComputerScreenModule computerScreenModule = (ComputerScreenModule)screenModule;
                    String tag = computerScreenModule.getTag();
                    if (!this.computerModules.containsKey(tag)) {
                        this.computerModules.put(tag, new ArrayList());
                    }
                    this.computerModules.get(tag).add(computerScreenModule);
                    continue;
                }
                this.screenModules.add(null);
            }
        }
        return this.screenModules;
    }

    public List<ComputerScreenModule> getComputerModules(String tag) {
        return this.computerModules.get(tag);
    }

    public Set<String> getTags() {
        return this.computerModules.keySet();
    }

    public Map<Integer, IModuleData> getScreenData(long millis) {
        HashMap<Integer, IModuleData> map = new HashMap<Integer, IModuleData>();
        List<IScreenModule<?>> screenModules = this.getScreenModules();
        int moduleIndex = 0;
        for (IScreenModule<?> module : screenModules) {
            Object data;
            if (module != null && (data = module.getData(this.screenDataHelper, this.getWorld(), millis)) != null) {
                map.put(moduleIndex, (IModuleData)data);
            }
            ++moduleIndex;
        }
        return map;
    }

    public IScreenModule<?> getHoveringModule() {
        return this.getHoveringModule(this.hoveringModule);
    }

    public IScreenModule<?> getHoveringModule(int hoveringModule) {
        if (hoveringModule == -1) {
            return null;
        }
        this.getScreenModules();
        if (hoveringModule >= 0 && hoveringModule < this.screenModules.size()) {
            return this.screenModules.get(hoveringModule);
        }
        return null;
    }

    public int getHoveringX() {
        return this.hoveringX;
    }

    public int getHoveringY() {
        return this.hoveringY;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_CLICK.equals(command)) {
            int x = (Integer)params.get(PARAM_X);
            int y = (Integer)params.get(PARAM_Y);
            int module = (Integer)params.get(PARAM_MODULE);
            this.hitScreenServer((EntityPlayer)playerMP, x, y, module);
            return true;
        }
        if (CMD_HOVER.equals(command)) {
            this.hoveringX = (Integer)params.get(PARAM_X);
            this.hoveringY = (Integer)params.get(PARAM_Y);
            this.hoveringModule = (Integer)params.get(PARAM_MODULE);
            return true;
        }
        if (CMD_SETTRUETYPE.equals(command)) {
            int b = (Integer)params.get(PARAM_TRUETYPE);
            this.setTrueTypeMode(b);
            return true;
        }
        return false;
    }

    public TypedMap executeWithResult(String command, TypedMap args) {
        TypedMap rc = super.executeWithResult(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_SCREEN_INFO.equals(command)) {
            IScreenModule<?> module = this.getHoveringModule((Integer)args.get(PARAM_MODULE));
            List<Object> info = Collections.emptyList();
            if (module instanceof ITooltipInfo) {
                info = ((ITooltipInfo)((Object)module)).getInfo(this.world, (Integer)args.get(PARAM_X), (Integer)args.get(PARAM_Y));
            }
            return TypedMap.builder().put(PARAM_INFO, info).build();
        }
        return null;
    }

    public boolean receiveDataFromServer(String command, @Nonnull TypedMap result) {
        boolean rc = super.receiveDataFromServer(command, result);
        if (rc) {
            return rc;
        }
        if (CMD_SCREEN_INFO.equals(command)) {
            infoReceived = (List)result.get(PARAM_INFO);
            return true;
        }
        return false;
    }

    private static class ActivatedModule {
        private int module;
        private int ticks;
        private int x;
        private int y;

        public ActivatedModule(int module, int ticks, int x, int y) {
            this.module = module;
            this.ticks = ticks;
            this.x = x;
            this.y = y;
        }
    }

    public static class ModuleRaytraceResult {
        private final int x;
        private final int y;
        private final int currenty;
        private final int moduleIndex;

        public ModuleRaytraceResult(int moduleIndex, int x, int y, int currenty) {
            this.moduleIndex = moduleIndex;
            this.x = x;
            this.y = y;
            this.currenty = currenty;
        }

        public int getModuleIndex() {
            return this.moduleIndex;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getCurrenty() {
            return this.currenty;
        }
    }
}

