/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modules;

import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.api.screens.IScreenDataHelper;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.api.screens.data.IModuleDataInteger;
import mcjty.rftools.blocks.logic.counter.CounterTileEntity;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class CounterScreenModule
implements IScreenModule<IModuleDataInteger> {
    protected int dim = 0;
    protected BlockPos coordinate = BlockPosTools.INVALID;

    @Override
    public IModuleDataInteger getData(IScreenDataHelper helper, World worldObj, long millis) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null) {
            return null;
        }
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)this.coordinate)) {
            return null;
        }
        TileEntity te = world.getTileEntity(this.coordinate);
        if (!(te instanceof CounterTileEntity)) {
            return null;
        }
        CounterTileEntity counterTileEntity = (CounterTileEntity)te;
        return helper.createInteger(counterTileEntity.getCurrent());
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.coordinate = BlockPosTools.INVALID;
            if (tagCompound.hasKey("monitorx")) {
                this.dim = tagCompound.hasKey("monitordim") ? tagCompound.getInteger("monitordim") : tagCompound.getInteger("dim");
                if (dim == this.dim) {
                    BlockPos c = new BlockPos(tagCompound.getInteger("monitorx"), tagCompound.getInteger("monitory"), tagCompound.getInteger("monitorz"));
                    int dx = Math.abs(c.getX() - pos.getX());
                    int dy = Math.abs(c.getY() - pos.getY());
                    int dz = Math.abs(c.getZ() - pos.getZ());
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    @Override
    public int getRfPerTick() {
        return ScreenConfiguration.COUNTER_RFPERTICK.get();
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked, EntityPlayer player) {
    }
}

