/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modules;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.CapabilityTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.api.screens.IScreenDataHelper;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.api.screens.data.IModuleData;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.items.IItemHandler;

public class ItemStackScreenModule
implements IScreenModule<ModuleDataStacks> {
    private int slot1 = -1;
    private int slot2 = -1;
    private int slot3 = -1;
    private int slot4 = -1;
    protected int dim = 0;
    protected BlockPos coordinate = BlockPosTools.INVALID;

    @Override
    public ModuleDataStacks getData(IScreenDataHelper helper, World worldObj, long millis) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null) {
            return null;
        }
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)this.coordinate)) {
            return null;
        }
        TileEntity te = world.getTileEntity(this.coordinate);
        if (te == null) {
            return null;
        }
        if (CapabilityTools.hasItemCapabilitySafe((TileEntity)te)) {
            IItemHandler itemHandler = CapabilityTools.getItemCapabilitySafe((TileEntity)te);
            ItemStack stack1 = this.getItemStack(itemHandler, this.slot1);
            ItemStack stack2 = this.getItemStack(itemHandler, this.slot2);
            ItemStack stack3 = this.getItemStack(itemHandler, this.slot3);
            ItemStack stack4 = this.getItemStack(itemHandler, this.slot4);
            return new ModuleDataStacks(stack1, stack2, stack3, stack4);
        }
        if (te instanceof IInventory) {
            IInventory inventory = (IInventory)te;
            ItemStack stack1 = this.getItemStack(inventory, this.slot1);
            ItemStack stack2 = this.getItemStack(inventory, this.slot2);
            ItemStack stack3 = this.getItemStack(inventory, this.slot3);
            ItemStack stack4 = this.getItemStack(inventory, this.slot4);
            return new ModuleDataStacks(stack1, stack2, stack3, stack4);
        }
        return null;
    }

    private ItemStack getItemStack(IInventory inventory, int slot) {
        if (slot == -1) {
            return ItemStack.EMPTY;
        }
        if (slot < inventory.getSizeInventory()) {
            return inventory.getStackInSlot(slot);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack getItemStack(IItemHandler itemHandler, int slot) {
        if (slot == -1) {
            return ItemStack.EMPTY;
        }
        if (slot < itemHandler.getSlots()) {
            return itemHandler.getStackInSlot(slot);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
            if (tagCompound.hasKey("slot1")) {
                this.slot1 = tagCompound.getInteger("slot1");
            }
            if (tagCompound.hasKey("slot2")) {
                this.slot2 = tagCompound.getInteger("slot2");
            }
            if (tagCompound.hasKey("slot3")) {
                this.slot3 = tagCompound.getInteger("slot3");
            }
            if (tagCompound.hasKey("slot4")) {
                this.slot4 = tagCompound.getInteger("slot4");
            }
        }
    }

    protected void setupCoordinateFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        if (tagCompound.hasKey("monitorx")) {
            this.dim = tagCompound.hasKey("monitordim") ? tagCompound.getInteger("monitordim") : tagCompound.getInteger("dim");
            if (dim == this.dim) {
                BlockPos c = new BlockPos(tagCompound.getInteger("monitorx"), tagCompound.getInteger("monitory"), tagCompound.getInteger("monitorz"));
                int dx = Math.abs(c.getX() - pos.getX());
                int dy = Math.abs(c.getY() - pos.getY());
                int dz = Math.abs(c.getZ() - pos.getZ());
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    @Override
    public int getRfPerTick() {
        return ScreenConfiguration.ITEMSTACK_RFPERTICK.get();
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked, EntityPlayer player) {
    }

    public static class ModuleDataStacks
    implements IModuleData {
        public static final String ID = "rftools:itemStacks";
        private final ItemStack[] stacks = new ItemStack[4];

        @Override
        public String getId() {
            return ID;
        }

        public ModuleDataStacks(ItemStack stack1, ItemStack stack2, ItemStack stack3, ItemStack stack4) {
            this.stacks[0] = stack1;
            this.stacks[1] = stack2;
            this.stacks[2] = stack3;
            this.stacks[3] = stack4;
        }

        public ModuleDataStacks(ByteBuf buf) {
            for (int i = 0; i < 4; ++i) {
                this.stacks[i] = buf.readBoolean() ? NetworkTools.readItemStack((ByteBuf)buf) : ItemStack.EMPTY;
            }
        }

        public ItemStack getStack(int idx) {
            return this.stacks[idx];
        }

        @Override
        public void writeToBuf(ByteBuf buf) {
            this.writeStack(buf, this.stacks[0]);
            this.writeStack(buf, this.stacks[1]);
            this.writeStack(buf, this.stacks[2]);
            this.writeStack(buf, this.stacks[3]);
        }

        private void writeStack(ByteBuf buf, ItemStack stack) {
            if (!stack.isEmpty()) {
                buf.writeBoolean(true);
                NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)stack);
            } else {
                buf.writeBoolean(false);
            }
        }
    }
}

